/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.animator;

import java.util.HashMap;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.animator.AbstractDonut2DAnimator;
import org.jensoft.core.view.View;

public class Donut2DFlashAnimator
extends AbstractDonut2DAnimator {
    private View view2D;
    private HashMap<Donut2DSlice, AlphaRunner> cacheAnimator = new HashMap();
    public float alphaMin = 0.0f;
    public float alphaMax = 1.0f;
    private FlashSpeed flashSpeed = FlashSpeed.Default;
    private ShowFlashBehavior showFlashBehavior = ShowFlashBehavior.ShowOnSliceRollover;

    public Donut2DFlashAnimator() {
    }

    public Donut2DFlashAnimator(float alphaMin, float alphaMax) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
    }

    public Donut2DFlashAnimator(float alphaMin, float alphaMax, FlashSpeed flashSpeed) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
        this.flashSpeed = flashSpeed;
    }

    public float getAlphaMin() {
        return this.alphaMin;
    }

    public ShowFlashBehavior getShowFlashBehavior() {
        return this.showFlashBehavior;
    }

    public void setShowFlashBehavior(ShowFlashBehavior showFlashBehavior) {
        this.showFlashBehavior = showFlashBehavior;
    }

    public void setAlphaMin(float alphaMin) {
        this.alphaMin = alphaMin;
    }

    public float getAlphaMax() {
        return this.alphaMax;
    }

    public void setAlphaMax(float alphaMax) {
        this.alphaMax = alphaMax;
    }

    @Override
    protected void onPressed(Donut2DSlice slice) {
        if (this.showFlashBehavior == ShowFlashBehavior.ShowOnSlicePressed) {
            this.view2D = slice.getHost().getHostPlugin().getProjection().getView();
            AlphaRunner runner = (AlphaRunner)this.getAnimator(slice);
            if (!runner.isRunning()) {
                Thread t = new Thread(this.getAnimator(slice));
                runner.setHost(t);
                t.start();
            } else {
                runner.getHost().interrupt();
                slice.setAlpha(runner.getInitialAlpha());
            }
        }
    }

    @Override
    protected void onEntered(Donut2DSlice slice) {
        if (this.showFlashBehavior == ShowFlashBehavior.ShowOnSliceRollover) {
            this.view2D = slice.getHost().getHostPlugin().getProjection().getView();
            AlphaRunner runner = (AlphaRunner)this.getAnimator(slice);
            if (!runner.isRunning()) {
                Thread t = new Thread(this.getAnimator(slice));
                runner.setHost(t);
                t.start();
            }
        }
    }

    @Override
    protected void onExited(Donut2DSlice slice) {
        AlphaRunner runner;
        if (this.showFlashBehavior == ShowFlashBehavior.ShowOnSliceRollover && (runner = (AlphaRunner)this.getAnimator(slice)).isRunning()) {
            runner.getHost().interrupt();
            slice.setAlpha(runner.getInitialAlpha());
            this.getView(slice).repaintDevice();
        }
    }

    @Override
    public Runnable getAnimator(Donut2DSlice slice) {
        AlphaRunner runner = null;
        if (this.cacheAnimator.get(slice) != null) {
            runner = this.cacheAnimator.get(slice);
        } else {
            runner = new AlphaRunner(slice);
            this.cacheAnimator.put(slice, runner);
        }
        return runner;
    }

    public class AlphaRunner
    implements Runnable {
        private float initialAlpha;
        private Donut2DSlice slice;
        private boolean running = false;
        private Thread host;

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public Thread getHost() {
            return this.host;
        }

        public void setHost(Thread host) {
            this.host = host;
        }

        public float getInitialAlpha() {
            return this.initialAlpha;
        }

        public void setInitialAlpha(float initialAlpha) {
            this.initialAlpha = initialAlpha;
        }

        public Donut2DSlice getSlice() {
            return this.slice;
        }

        public void setSlice(Donut2DSlice slice) {
            this.slice = slice;
        }

        public AlphaRunner(Donut2DSlice slice) {
            this.slice = slice;
            this.initialAlpha = slice.getAlpha();
        }

        @Override
        public void run() {
            this.running = true;
            int sleep = 300;
            if (Donut2DFlashAnimator.this.flashSpeed == FlashSpeed.VeryFast) {
                sleep = 100;
            }
            if (Donut2DFlashAnimator.this.flashSpeed == FlashSpeed.Fast) {
                sleep = 200;
            }
            if (Donut2DFlashAnimator.this.flashSpeed == FlashSpeed.Slow) {
                sleep = 400;
            }
            if (Donut2DFlashAnimator.this.flashSpeed == FlashSpeed.VerySlow) {
                sleep = 500;
            }
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    this.slice.setAlpha(Donut2DFlashAnimator.this.alphaMin);
                    Donut2DFlashAnimator.this.view2D.repaintDevice();
                    Thread.sleep(sleep);
                    this.slice.setAlpha(Donut2DFlashAnimator.this.alphaMax);
                    Donut2DFlashAnimator.this.view2D.repaintDevice();
                    Thread.sleep(sleep);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.running = false;
        }
    }

    public static enum ShowFlashBehavior {
        ShowOnSlicePressed,
        ShowOnSliceRollover;

    }

    public static enum FlashSpeed {
        VeryFast,
        Fast,
        Slow,
        VerySlow,
        Default;

    }
}

