/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.animator;

import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.animator.AbstractDonut2DAnimator;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;

public class Donut2DLabelAnimator
extends AbstractDonut2DAnimator {
    private Donut2DSlice slice;
    private AbstractDonut2DSliceLabel sliceLabel;
    private ShowLabelBehavior showLabelBehavior = ShowLabelBehavior.ShowOnSliceRollover;

    public Donut2DLabelAnimator(Donut2DSlice slice, AbstractDonut2DSliceLabel sliceLabel) {
        this.slice = slice;
        this.sliceLabel = sliceLabel;
    }

    public Donut2DSlice getSlice() {
        return this.slice;
    }

    public void setSlice(Donut2DSlice slice) {
        this.slice = slice;
    }

    public AbstractDonut2DSliceLabel getSliceLabel() {
        return this.sliceLabel;
    }

    public void setSliceLabel(AbstractDonut2DSliceLabel sliceLabel) {
        this.sliceLabel = sliceLabel;
    }

    public ShowLabelBehavior getShowLabelBehavior() {
        return this.showLabelBehavior;
    }

    public void setShowLabelBehavior(ShowLabelBehavior showLabelBehavior) {
        this.showLabelBehavior = showLabelBehavior;
    }

    @Override
    protected void onPressed(Donut2DSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSlicePressed && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    protected void onEntered(Donut2DSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSliceRollover && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    protected void onExited(Donut2DSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSliceRollover && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    public Runnable getAnimator(Donut2DSlice pieSection) {
        return new LabelRunner(pieSection);
    }

    public class LabelRunner
    implements Runnable {
        private Donut2DSlice animateSlice;

        public LabelRunner(Donut2DSlice pieSection) {
            this.animateSlice = pieSection;
        }

        @Override
        public void run() {
            if (!this.animateSlice.containsSliceLabel(Donut2DLabelAnimator.this.sliceLabel)) {
                this.animateSlice.addSliceLabel(Donut2DLabelAnimator.this.sliceLabel);
            } else {
                this.animateSlice.removeSliceLabel(Donut2DLabelAnimator.this.sliceLabel);
            }
            Donut2DLabelAnimator.this.getView(this.animateSlice).repaintDevice();
        }
    }

    public static enum ShowLabelBehavior {
        ShowOnSlicePressed,
        ShowOnSliceRollover;

    }
}

