/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.animator;

import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.animator.AbstractDonut2DAnimator;

public class Donut2DShiftStartAngleAnimator
extends AbstractDonut2DAnimator {
    private Donut2DShifting donut2DShifting;

    public void shift(ShiftVelocity velocity) {
        this.interrupt();
        this.donut2DShifting = new Donut2DShifting(velocity);
        this.donut2DShifting.start();
    }

    public void interrupt() {
        if (this.donut2DShifting != null && this.donut2DShifting.isAlive()) {
            this.donut2DShifting.interrupt();
        }
    }

    public void interruptShiftingAfter(final int millis) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(millis);
                    this.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    public void shiftAndInterrupt(ShiftVelocity velocity, int millis) {
        this.shift(velocity);
        this.interruptShiftingAfter(millis);
    }

    @Override
    protected Runnable getAnimator(Donut2DSlice slice) {
        return null;
    }

    class Donut2DShifting
    extends Thread {
        private ShiftVelocity velocity;

        public Donut2DShifting(ShiftVelocity velocity) {
            this.velocity = velocity;
        }

        public ShiftVelocity getVelocity() {
            return this.velocity;
        }

        public void setVelocity(ShiftVelocity velocity) {
            this.velocity = velocity;
        }

        @Override
        public void run() {
            Donut2D donut2D = Donut2DShiftStartAngleAnimator.this.getDonut2D();
            try {
                while (!Donut2DShifting.interrupted()) {
                    donut2D.setStartAngleDegree(donut2D.getStartAngleDegree() + 1.0);
                    Thread.sleep(this.velocity.getVelocity());
                    donut2D.getHostPlugin().getProjection().getView().repaintDevice();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum ShiftVelocity {
        Slow(40),
        Default(20),
        Speed(10);

        private int velocity;

        private ShiftVelocity(int velocity) {
            this.velocity = velocity;
        }

        public int getVelocity() {
            return this.velocity;
        }
    }
}

