/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.effect;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.effect.AbstractDonut2DEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DShiftIncidence;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DSliceLinearEffect;

public class Donut2DLinearEffect
extends AbstractDonut2DEffect {
    private Color startColor;
    private Color endColor;
    private int offsetRadius = 0;
    private int incidenceAngleDegree = 90;
    private Donut2DSliceLinearEffect pieSliceLinearEffect;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private boolean reload = false;
    private boolean shifting = false;

    public Donut2DLinearEffect() {
    }

    public Donut2DLinearEffect(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public Donut2DLinearEffect(int incidenceAngleDegree, int offsetRadius) {
        this.incidenceAngleDegree = incidenceAngleDegree;
        this.offsetRadius = offsetRadius;
    }

    public Donut2DLinearEffect(Color startColor, Color endColor, int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.startColor = startColor;
        this.endColor = endColor;
        this.offsetRadius = offsetRadius;
    }

    public Donut2DLinearEffect(Color startColor, Color endColor, int offsetRadius, int incidenceAngleDegree) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.startColor = startColor;
        this.endColor = endColor;
        this.offsetRadius = offsetRadius;
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public Donut2DLinearEffect(Color startColor, Color endColor) {
        this(startColor, endColor, 0);
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
        this.setReload(true);
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
        this.setReload(true);
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
        this.setReload(true);
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        this.shadeFractions = shader.getFractions();
        this.shadeColors = shader.getColors();
    }

    public int getIncidenceAngleDegree() {
        return this.incidenceAngleDegree;
    }

    public void setIncidenceAngleDegree(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
        this.setReload(true);
    }

    public static void shiftIncidence(Donut2D donut2D) {
        AbstractDonut2DEffect effect = donut2D.getDonut2DEffect();
        if (effect != null && effect instanceof Donut2DLinearEffect) {
            Donut2DShiftIncidence shift = new Donut2DShiftIncidence(donut2D);
            shift.start();
        }
    }

    public boolean isShifting() {
        return this.shifting;
    }

    public void setShifting(boolean shifting) {
        this.shifting = shifting;
    }

    @Override
    public final void paintDonut2DEffect(Graphics2D g2d, Donut2D donut2D) {
        if (this.pieSliceLinearEffect == null || this.reload) {
            this.pieSliceLinearEffect = new Donut2DSliceLinearEffect(this.startColor, this.endColor, this.offsetRadius, this.incidenceAngleDegree);
            if (this.shadeFractions != null && this.shadeColors != null) {
                this.pieSliceLinearEffect.setShader(this.shadeFractions, this.shadeColors);
            }
        }
        for (Donut2DSlice slice : donut2D.getSlices()) {
            g2d.setComposite(AlphaComposite.getInstance(3, slice.getAlpha()));
            this.pieSliceLinearEffect.paintDonut2DSlice(g2d, donut2D, slice);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }
}

