/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.label;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.AbstractDonut2DSlicePainter;

public abstract class AbstractDonut2DSliceLabel
extends AbstractDonut2DSlicePainter {
    private String label;
    private Color labelColor;
    private Font labelFont;
    private int outlineRound = 6;
    private Color outlineColor;
    private Stroke outlineStroke;
    private int labelPaddingX = 10;
    private int labelPaddingY = 2;
    private Color fillColor;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Stroke defaultStroke = new BasicStroke();
    private Style style = Style.Both;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public int getLabelPaddingX() {
        return this.labelPaddingX;
    }

    public void setLabelPaddingX(int labelPaddingX) {
        this.labelPaddingX = labelPaddingX;
    }

    public int getLabelPaddingY() {
        return this.labelPaddingY;
    }

    public void setLabelPaddingY(int labelPaddingY) {
        this.labelPaddingY = labelPaddingY;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public float[] getShadeFractions() {
        return this.shadeFractions;
    }

    public void setShadeFractions(float[] shadeFractions) {
        this.shadeFractions = shadeFractions;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        if (shader != null) {
            this.shadeFractions = shader.getFractions();
            this.shadeColors = shader.getColors();
        }
    }

    public Color[] getShadeColors() {
        return this.shadeColors;
    }

    public void setShadeColors(Color[] shadeColors) {
        this.shadeColors = shadeColors;
    }

    public Stroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void setDefaultStroke(Stroke defaultStroke) {
        this.defaultStroke = defaultStroke;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    protected abstract void paintDonut2DSliceLabel(Graphics2D var1, Donut2D var2, Donut2DSlice var3);

    @Override
    public final void paintDonut2DSlice(Graphics2D g2d, Donut2D donut2d, Donut2DSlice slice) {
        this.paintDonut2DSliceLabel(g2d, donut2d, slice);
    }

    public static enum Style {
        Nothing,
        Stroke,
        Fill,
        Both;


        public static Style parseStyle(String style) {
            if (style == null) {
                return Both;
            }
            if (style.equalsIgnoreCase("Nothing")) {
                return Nothing;
            }
            if (style.equalsIgnoreCase("Stroke")) {
                return Stroke;
            }
            if (style.equalsIgnoreCase("Fill")) {
                return Fill;
            }
            if (style.equalsIgnoreCase("Both")) {
                return Both;
            }
            return Both;
        }
    }
}

