/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut2d.painter.label;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;

public class Donut2DPathLabel
extends AbstractDonut2DSliceLabel {
    private TextPath.TextPosition textPosition = TextPath.TextPosition.Left;
    private TextPath.PathSide pathSide = TextPath.PathSide.Above;
    private float[] fractions;
    private Color[] colors;
    private int divergence = 10;
    private Donut2DFacetPathName facetPathName = Donut2DFacetPathName.OuterArc;
    private boolean lockReverse = false;
    private boolean autoReverse = true;

    public Donut2DPathLabel() {
    }

    public Donut2DPathLabel(TextPath.TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public Donut2DPathLabel(String label) {
        super.setLabel(label);
    }

    public Donut2DPathLabel(String label, Color labelColor) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
    }

    public Donut2DPathLabel(String label, Color labelColor, Font labelFont) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
        super.setLabelFont(labelFont);
    }

    public Donut2DPathLabel(TextPath.TextPosition textPosition, String label) {
        this.textPosition = textPosition;
        super.setLabel(label);
    }

    public Donut2DPathLabel(TextPath.TextPosition textPosition, String label, Color labelColor) {
        this.textPosition = textPosition;
        super.setLabel(label);
        super.setLabelColor(labelColor);
    }

    public Donut2DFacetPathName getFacetPathName() {
        return this.facetPathName;
    }

    public void setFacetPathName(Donut2DFacetPathName facetPathName) {
        this.facetPathName = facetPathName;
    }

    public boolean isLockReverse() {
        return this.lockReverse;
    }

    public void setLockReverse(boolean lockReverse) {
        this.lockReverse = lockReverse;
    }

    public boolean isAutoReverse() {
        return this.autoReverse;
    }

    public void setAutoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
    }

    public TextPath.TextPosition getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(TextPath.TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public TextPath.PathSide getPathSide() {
        return this.pathSide;
    }

    public void setPathSide(TextPath.PathSide pathSide) {
        this.pathSide = pathSide;
    }

    public int getDivergence() {
        return this.divergence;
    }

    public void setDivergence(int divergence) {
        this.divergence = divergence;
    }

    public static int parseDivergence(String divergence) {
        try {
            return Integer.parseInt(divergence);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public void setTextShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("colors and fractions length array does not match");
        }
        this.fractions = fractions;
        this.colors = colors;
    }

    public void setTextShader(Shader shader) {
        if (shader != null) {
            this.fractions = shader.getFractions();
            this.colors = shader.getColors();
        }
    }

    public Shader getTextShader() {
        if (this.fractions != null && this.colors != null) {
            Shader shader = new Shader(this.fractions, this.colors);
            return shader;
        }
        return null;
    }

    @Override
    protected void paintDonut2DSliceLabel(Graphics2D g2d, Donut2D donut3d, Donut2DSlice donutSlice) {
        TextPath pt = null;
        if (this.facetPathName == Donut2DFacetPathName.OuterArc) {
            pt = new TextPath(donutSlice.getOuterArc());
        }
        if (this.facetPathName == Donut2DFacetPathName.InnerArc) {
            pt = new TextPath(donutSlice.getInnerArc());
        }
        if (this.facetPathName == Donut2DFacetPathName.Start) {
            pt = new TextPath(donutSlice.getLineStart());
        }
        if (this.facetPathName == Donut2DFacetPathName.End) {
            pt = new TextPath(donutSlice.getLineEnd());
        }
        if (pt != null) {
            pt.setTextPosition(this.textPosition);
            pt.setLockReverse(this.isLockReverse());
            pt.setAutoReverse(this.isAutoReverse());
            pt.setLabel(this.getLabel());
            pt.setTextColor(this.getLabelColor());
            pt.setLabelFont(this.getLabelFont());
            pt.setPathSide(this.pathSide);
            pt.setDivergence(this.divergence);
            if (this.fractions != null && this.colors != null && this.fractions.length == this.colors.length) {
                pt.setShader(this.fractions, this.colors);
            }
            pt.draw(g2d);
        }
    }

    public static enum Donut2DFacetPathName {
        Start("start"),
        OuterArc("outerArc"),
        InnerArc("innerArc"),
        End("end");

        private String pathName;

        private Donut2DFacetPathName(String path) {
            this.pathName = path;
        }

        public String getPathName() {
            return this.pathName;
        }

        public static Donut2DFacetPathName parse(String path) {
            if (Start.getPathName().equalsIgnoreCase(path)) {
                return Start;
            }
            if (OuterArc.getPathName().equalsIgnoreCase(path)) {
                return OuterArc;
            }
            if (InnerArc.getPathName().equalsIgnoreCase(path)) {
                return InnerArc;
            }
            if (End.getPathName().equalsIgnoreCase(path)) {
                return End;
            }
            return OuterArc;
        }
    }
}

