/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;

public class Donut3DSlice {
    private String name;
    private double value;
    private double normalizedValue;
    private double startAngleDegree;
    private double endAngleDegree;
    private Color themeColor;
    private double divergence = 0.0;
    private Arc2D outerArcTop;
    private Arc2D innerArcTop;
    private Arc2D outerArcBottom;
    private Arc2D innerArcBottom;
    private Shape topFace;
    private Shape bottomFace;
    private Shape startFace;
    private Shape endFace;
    private Shape innerFace;
    private Shape outerFace;
    private Line2D startBottomLine;
    private Line2D startTopLine;
    private Line2D startInnerLine;
    private Line2D startOuterLine;
    private Line2D endBottomLine;
    private Line2D endTopLine;
    private Line2D endInnerLine;
    private Line2D endOuterLine;
    private List<AbstractDonut3DSliceLabel> sliceLabels;
    private Type type;
    private boolean isFragment;
    private Donut3DSlice parentSlice;
    private Ellipse2D innerModel;
    private double centerX;
    private double centerY;
    private boolean painted = false;
    private boolean lockEnter = false;
    private Donut3D host;
    private List<Donut3DSlice> fragments = new ArrayList<Donut3DSlice>();

    public String toString() {
        return "Donut3DSlice [name=" + this.name + ", startAngleDegree=" + this.startAngleDegree + ", endAngleDegree=" + this.endAngleDegree + ", painted=" + this.painted + "]";
    }

    public Donut3DSlice(String name, Color themeColor) {
        this.name = name;
        this.themeColor = themeColor;
        this.divergence = 0.0;
        this.sliceLabels = new ArrayList<AbstractDonut3DSliceLabel>();
    }

    public Donut3D getHost() {
        return this.host;
    }

    public void setHost(Donut3D host) {
        this.host = host;
    }

    public boolean isLockEnter() {
        return this.lockEnter;
    }

    public void lockEnter() {
        if (!this.isLockEnter()) {
            this.lockEnter = true;
        }
    }

    public void unlockEnter() {
        if (this.isLockEnter()) {
            this.lockEnter = false;
        }
    }

    public void clearFragment() {
        this.fragments.clear();
    }

    public void addFragment(Donut3DSlice fragment) {
        this.fragments.add(fragment);
    }

    public boolean isFirst(Donut3DSlice fragment) {
        return this.fragments.get(0).equals(fragment);
    }

    public boolean isLast(Donut3DSlice fragment) {
        return this.fragments.get(this.fragments.size() - 1).equals(fragment);
    }

    public Area getFrontInnerFace() {
        Area frontInnerFace = new Area();
        for (Donut3DSlice fragment : this.fragments) {
            if (fragment.getType() != Type.Front) continue;
            frontInnerFace.add(new Area(fragment.getInnerFace()));
        }
        return frontInnerFace;
    }

    public Area getBackInnerFace() {
        Area frontInnerFace = new Area();
        for (Donut3DSlice fragment : this.fragments) {
            if (fragment.getType() != Type.Back) continue;
            frontInnerFace.add(new Area(fragment.getInnerFace()));
        }
        return frontInnerFace;
    }

    public List<Donut3DSlice> getFragments() {
        return this.fragments;
    }

    public void setFragments(List<Donut3DSlice> fragments) {
        this.fragments = fragments;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public Ellipse2D getInnerModel() {
        return this.innerModel;
    }

    public void setInnerModel(Ellipse2D innerModel) {
        this.innerModel = innerModel;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public double getEndAngleDegree() {
        return this.endAngleDegree;
    }

    public void setEndAngleDegree(double endAngleDegree) {
        this.endAngleDegree = endAngleDegree;
    }

    public double getExtendsDegree() {
        return Math.abs(this.getEndAngleDegree() - this.getStartAngleDegree());
    }

    public double getMedianDegree() {
        return this.getStartAngleDegree() + this.getExtendsDegree() / 2.0;
    }

    public List<AbstractDonut3DSliceLabel> getSliceLabels() {
        return this.sliceLabels;
    }

    public void addSliceLabel(AbstractDonut3DSliceLabel sliceLabel) {
        this.sliceLabels.add(sliceLabel);
    }

    public void removeSliceLabel(AbstractDonut3DSliceLabel sliceLabel) {
        this.sliceLabels.remove(sliceLabel);
    }

    public boolean containsSliceLabel(AbstractDonut3DSliceLabel sliceLabel) {
        return this.sliceLabels.contains(sliceLabel);
    }

    public void removeAllSliceLabels() {
        this.sliceLabels.clear();
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Slice value should be greater than 0");
        }
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getNormalizedValue() {
        return this.normalizedValue;
    }

    public void setNormalizedValue(double normalizedValue) {
        this.normalizedValue = normalizedValue;
    }

    public Arc2D getOuterArcTop() {
        return this.outerArcTop;
    }

    public void setOuterArcTop(Arc2D outerArcTop) {
        this.outerArcTop = outerArcTop;
    }

    public Arc2D getInnerArcTop() {
        return this.innerArcTop;
    }

    public void setInnerArcTop(Arc2D innerArcTop) {
        this.innerArcTop = innerArcTop;
    }

    public Arc2D getOuterArcBottom() {
        return this.outerArcBottom;
    }

    public void setOuterArcBottom(Arc2D outerArcBottom) {
        this.outerArcBottom = outerArcBottom;
    }

    public Arc2D getInnerArcBottom() {
        return this.innerArcBottom;
    }

    public void setInnerArcBottom(Arc2D innerArcBottom) {
        this.innerArcBottom = innerArcBottom;
    }

    public Shape getTopFace() {
        return this.topFace;
    }

    public void setTopFace(Shape topFace) {
        this.topFace = topFace;
    }

    public Shape getBottomFace() {
        return this.bottomFace;
    }

    public void setBottomFace(Shape bottomFace) {
        this.bottomFace = bottomFace;
    }

    public Shape getStartFace() {
        return this.startFace;
    }

    public void setStartFace(Shape startFace) {
        this.startFace = startFace;
    }

    public Shape getEndFace() {
        return this.endFace;
    }

    public void setEndFace(Shape endFace) {
        this.endFace = endFace;
    }

    public Shape getInnerFace() {
        return this.innerFace;
    }

    public void setInnerFace(Shape innerFace) {
        this.innerFace = innerFace;
    }

    public Shape getOuterFace() {
        return this.outerFace;
    }

    public void setOuterFace(Shape outerFace) {
        this.outerFace = outerFace;
    }

    public double getDivergence() {
        return this.divergence;
    }

    public void setDivergence(double divergence) {
        this.divergence = divergence;
    }

    public Line2D getStartBottomLine() {
        return this.startBottomLine;
    }

    public void setStartBottomLine(Line2D startBottomLine) {
        this.startBottomLine = startBottomLine;
    }

    public Line2D getStartTopLine() {
        return this.startTopLine;
    }

    public void setStartTopLine(Line2D startTopLine) {
        this.startTopLine = startTopLine;
    }

    public Line2D getStartInnerLine() {
        return this.startInnerLine;
    }

    public void setStartInnerLine(Line2D startInnerLine) {
        this.startInnerLine = startInnerLine;
    }

    public Line2D getStartOuterLine() {
        return this.startOuterLine;
    }

    public void setStartOuterLine(Line2D startOuterLine) {
        this.startOuterLine = startOuterLine;
    }

    public Line2D getEndBottomLine() {
        return this.endBottomLine;
    }

    public void setEndBottomLine(Line2D endBottomLine) {
        this.endBottomLine = endBottomLine;
    }

    public Line2D getEndTopLine() {
        return this.endTopLine;
    }

    public void setEndTopLine(Line2D endTopLine) {
        this.endTopLine = endTopLine;
    }

    public Line2D getEndInnerLine() {
        return this.endInnerLine;
    }

    public void setEndInnerLine(Line2D endInnerLine) {
        this.endInnerLine = endInnerLine;
    }

    public Line2D getEndOuterLine() {
        return this.endOuterLine;
    }

    public void setEndOuterLine(Line2D endOuterLine) {
        this.endOuterLine = endOuterLine;
    }

    public boolean isPainted() {
        return this.painted;
    }

    public void setPainted(boolean painted) {
        this.painted = painted;
    }

    public Area getSensibleArea() {
        Area sensibleArea = new Area();
        if (this.getTopFace() != null) {
            sensibleArea.add(new Area(this.getTopFace()));
        }
        for (Donut3DSlice fragment : this.getFragments()) {
            if (fragment.getType() == Type.Back) {
                if (this.getInnerFace() == null) continue;
                sensibleArea.add(new Area(this.getInnerFace()));
                continue;
            }
            if (this.getOuterFace() == null) continue;
            sensibleArea.add(new Area(this.getOuterFace()));
        }
        return sensibleArea;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public void setFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }

    public Donut3DSlice getParentSlice() {
        return this.parentSlice;
    }

    public void setParentSlice(Donut3DSlice parentSlice) {
        this.parentSlice = parentSlice;
    }

    public static enum Type {
        Front,
        Back;

    }
}

