/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.plugin.Toolkit;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DBorderLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DPathLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DRadialLabel;
import org.jensoft.core.plugin.donut3d.painter.paint.Donut3DDefaultPaint;

public class Donut3DToolkit
extends Toolkit {
    public static Donut3D createDonut3D(String name, double innerRadius, double outerRadius, double thickness) {
        Donut3D donut3d = new Donut3D();
        donut3d.setName(name);
        donut3d.setCenterX(0.0);
        donut3d.setCenterY(0.0);
        donut3d.setInnerRadius(innerRadius);
        donut3d.setOuterRadius(outerRadius);
        donut3d.setThickness(thickness);
        donut3d.setStartAngleDegree(0.0);
        donut3d.setTilt(40.0);
        donut3d.setDonut3DPaint(new Donut3DDefaultPaint(90));
        return donut3d;
    }

    public static Donut3D createDonut3D(String name, double innerRadius, double outerRadius, double thickness, double startAngleDegree) {
        Donut3D donut3d = new Donut3D();
        donut3d.setName(name);
        donut3d.setCenterX(0.0);
        donut3d.setCenterY(0.0);
        donut3d.setInnerRadius(innerRadius);
        donut3d.setOuterRadius(outerRadius);
        donut3d.setThickness(thickness);
        donut3d.setStartAngleDegree(startAngleDegree);
        donut3d.setTilt(40.0);
        donut3d.setDonut3DPaint(new Donut3DDefaultPaint(90));
        return donut3d;
    }

    public static Donut3D createDonut3D(String name, double innerRadius, double outerRadius, double thickness, double startAngleDegree, double tilt) {
        Donut3D donut3d = new Donut3D();
        donut3d.setName(name);
        donut3d.setCenterX(0.0);
        donut3d.setCenterY(0.0);
        donut3d.setInnerRadius(innerRadius);
        donut3d.setOuterRadius(outerRadius);
        donut3d.setThickness(thickness);
        donut3d.setStartAngleDegree(startAngleDegree);
        donut3d.setTilt(tilt);
        donut3d.setDonut3DPaint(new Donut3DDefaultPaint(90));
        return donut3d;
    }

    public static Donut3DSlice createDonut3DSlice(String name, Color color, double value) {
        Donut3DSlice slice = new Donut3DSlice(name, color);
        slice.setValue(value);
        slice.setDivergence(0.0);
        return slice;
    }

    public static Donut3DSlice createDonut3DSlice(String name, Color color, double value, AbstractDonut3DSliceLabel sliceLabel) {
        Donut3DSlice slice = new Donut3DSlice(name, color);
        slice.setValue(value);
        slice.addSliceLabel(sliceLabel);
        slice.setDivergence(0.0);
        return slice;
    }

    public static Donut3DSlice createDonut3DSlice(String name, Color color, double value, double divergence) {
        Donut3DSlice slice = new Donut3DSlice(name, color);
        slice.setValue(value);
        slice.setDivergence(divergence);
        return slice;
    }

    public static Donut3DSlice createDonut3DSlice(String name, Color color, double value, AbstractDonut3DSliceLabel sliceLabel, double divergence) {
        Donut3DSlice slice = new Donut3DSlice(name, color);
        slice.setValue(value);
        slice.addSliceLabel(sliceLabel);
        slice.setDivergence(divergence);
        return slice;
    }

    public static Donut3DRadialLabel createRadialLabel(String label) {
        return new Donut3DRadialLabel(label);
    }

    public static Donut3DRadialLabel createRadialLabel(String label, int offsetRadius) {
        Donut3DRadialLabel radialLabel = new Donut3DRadialLabel(label);
        radialLabel.setOffsetRadius(offsetRadius);
        return radialLabel;
    }

    public static Donut3DRadialLabel createRadialLabel(String label, Color labelColor) {
        return new Donut3DRadialLabel(label, labelColor);
    }

    public static Donut3DRadialLabel createRadialLabel(String label, Color labelColor, int offsetRadius) {
        Donut3DRadialLabel radialLabel = new Donut3DRadialLabel(label, labelColor);
        radialLabel.setOffsetRadius(offsetRadius);
        return radialLabel;
    }

    public static Donut3DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont) {
        return new Donut3DRadialLabel(label, labelColor, labelFont);
    }

    public static Donut3DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius) {
        Donut3DRadialLabel radialLabel = new Donut3DRadialLabel(label, labelColor, labelFont);
        radialLabel.setOffsetRadius(offsetRadius);
        return radialLabel;
    }

    public static Donut3DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius, AbstractDonut3DSliceLabel.Style style) {
        Donut3DRadialLabel radialLabel = new Donut3DRadialLabel(label, labelColor, labelFont);
        radialLabel.setOffsetRadius(offsetRadius);
        radialLabel.setStyle(style);
        return radialLabel;
    }

    public static Donut3DRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius, int outlineRound, AbstractDonut3DSliceLabel.Style style) {
        Donut3DRadialLabel radialLabel = new Donut3DRadialLabel(label, labelColor, labelFont);
        radialLabel.setOffsetRadius(offsetRadius);
        radialLabel.setOutlineRound(outlineRound);
        radialLabel.setStyle(style);
        return radialLabel;
    }

    public static Donut3DPathLabel createPathLabel(String label, Color labelColor) {
        Donut3DPathLabel Donut3DPathLabel2 = new Donut3DPathLabel(label, labelColor);
        return Donut3DPathLabel2;
    }

    public static Donut3DPathLabel createPathLabel(String label, Color labelColor, int divergence) {
        Donut3DPathLabel Donut3DPathLabel2 = new Donut3DPathLabel(label, labelColor);
        Donut3DPathLabel2.setDivergence(divergence);
        return Donut3DPathLabel2;
    }

    public static Donut3DPathLabel createPathLabel(String label, Color labelColor, Font labelFont) {
        Donut3DPathLabel Donut3DPathLabel2 = new Donut3DPathLabel(label, labelColor, labelFont);
        return Donut3DPathLabel2;
    }

    public static Donut3DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, int divergence) {
        Donut3DPathLabel Donut3DPathLabel2 = new Donut3DPathLabel(label, labelColor, labelFont);
        Donut3DPathLabel2.setDivergence(divergence);
        return Donut3DPathLabel2;
    }

    public static Donut3DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition) {
        Donut3DPathLabel Donut3DPathLabel2 = new Donut3DPathLabel(label, labelColor, labelFont);
        Donut3DPathLabel2.setTextPosition(textPosition);
        return Donut3DPathLabel2;
    }

    public static Donut3DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition, TextPath.PathSide pathSide) {
        Donut3DPathLabel Donut3DPathLabel2 = new Donut3DPathLabel(label, labelColor, labelFont);
        Donut3DPathLabel2.setTextPosition(textPosition);
        Donut3DPathLabel2.setPathSide(pathSide);
        return Donut3DPathLabel2;
    }

    public static Donut3DPathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition, int divergence) {
        Donut3DPathLabel Donut3DPathLabel2 = new Donut3DPathLabel(label, labelColor, labelFont);
        Donut3DPathLabel2.setTextPosition(textPosition);
        Donut3DPathLabel2.setDivergence(divergence);
        return Donut3DPathLabel2;
    }

    public static Donut3DBorderLabel createBorderLabel(String label) {
        return new Donut3DBorderLabel(label);
    }

    public static Donut3DBorderLabel createBorderLabel(String label, Color labelColor) {
        return new Donut3DBorderLabel(label, labelColor);
    }

    public static Donut3DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont) {
        return new Donut3DBorderLabel(label, labelColor, labelFont);
    }

    public static Donut3DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont, int outlineRound) {
        Donut3DBorderLabel l = new Donut3DBorderLabel(label, labelColor, labelFont);
        l.setOutlineRound(outlineRound);
        return l;
    }

    public static Donut3DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont, int outlineRound, int margin) {
        Donut3DBorderLabel l = new Donut3DBorderLabel(label, labelColor, labelFont);
        l.setOutlineRound(outlineRound);
        l.setMargin(margin);
        return l;
    }

    public static Donut3DBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont, int outlineRound, AbstractDonut3DSliceLabel.Style style) {
        Donut3DBorderLabel l = new Donut3DBorderLabel(label, labelColor, labelFont);
        l.setOutlineRound(outlineRound);
        l.setStyle(style);
        return l;
    }

    public static void pushSlices(Donut3D donut3D, Donut3DSlice ... slices) {
        for (int i = 0; i < slices.length; ++i) {
            donut3D.addSlice(slices[i]);
        }
    }

    public static void pushSlices(Donut3D donut3D, List<Donut3DSlice> slices) {
        for (Donut3DSlice slice : slices) {
            donut3D.addSlice(slice);
        }
    }
}

