/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d.painter.label;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;

public class Donut3DBorderLabel
extends AbstractDonut3DSliceLabel {
    private int margin = 50;
    private boolean link = true;
    private boolean linkMarker = true;
    private Color linkColor;
    private Color linkMarkerFillColor;
    private Color linkMarkerDrawColor;
    private Stroke linkStroke;
    private LinkAlignment linkAlignment = LinkAlignment.Top;
    private int linkExtends = 20;
    private LinkStyle linkStyle = LinkStyle.Line;

    public Donut3DBorderLabel() {
    }

    public Donut3DBorderLabel(String label, Color labelColor, Font labelFont) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
        super.setLabelFont(labelFont);
    }

    public Donut3DBorderLabel(String label, Color labelColor) {
        this(label, labelColor, null);
    }

    public Donut3DBorderLabel(String label) {
        this(label, null, null);
    }

    public LinkStyle getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(LinkStyle linkStyle) {
        this.linkStyle = linkStyle;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public boolean isLinkMarker() {
        return this.linkMarker;
    }

    public void setLinkMarker(boolean linkMarker) {
        this.linkMarker = linkMarker;
    }

    public Color getLinkMarkerFillColor() {
        return this.linkMarkerFillColor;
    }

    public void setLinkMarkerFillColor(Color linkMarkerFillColor) {
        this.linkMarkerFillColor = linkMarkerFillColor;
    }

    public Color getLinkMarkerDrawColor() {
        return this.linkMarkerDrawColor;
    }

    public void setLinkMarkerDrawColor(Color linkMarkerDrawColor) {
        this.linkMarkerDrawColor = linkMarkerDrawColor;
    }

    public LinkAlignment getLinkAlignment() {
        return this.linkAlignment;
    }

    public void setLinkAlignment(LinkAlignment linkAlignment) {
        this.linkAlignment = linkAlignment;
    }

    public int getLinkExtends() {
        return this.linkExtends;
    }

    public void setLinkExtends(int linkExtends) {
        this.linkExtends = linkExtends;
    }

    public Stroke getLinkStroke() {
        return this.linkStroke;
    }

    public void setLinkStroke(Stroke linkStroke) {
        this.linkStroke = linkStroke;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(Color linkColor) {
        this.linkColor = linkColor;
    }

    @Override
    protected void paintDonut3DSliceLabel(Graphics2D g2d, Donut3D donut3D, Donut3DSlice donutSection) {
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setColor(donutSection.getThemeColor());
        double percent = donutSection.getNormalizedValue() * 100.0;
        DecimalFormat df = new DecimalFormat("##.##");
        String s = df.format(percent) + "%";
        if (this.getLabel() != null) {
            s = this.getLabel();
        }
        Font f = new Font("Dialog", 0, 12);
        if (this.getLabelFont() != null) {
            f = this.getLabelFont();
        }
        g2d.setFont(f);
        FontMetrics fm = g2d.getFontMetrics();
        int widthText = fm.stringWidth(s);
        int ascentText = fm.getAscent();
        int descentText = fm.getDescent();
        double centerX = donut3D.getCenterX();
        double centerY = donut3D.getCenterY();
        Point2D c = null;
        if (donut3D.getDonut3DNature() == Donut3D.Donut3DNature.Donut3DUser) {
            c = donut3D.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (donut3D.getDonut3DNature() == Donut3D.Donut3DNature.Donut3DDevice) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX();
        centerY = c.getY();
        double medianDegree = donutSection.getMedianDegree();
        if (medianDegree >= 360.0) {
            medianDegree -= 360.0;
        }
        double oneDegreeTiltDivergence = new Double(donutSection.getDivergence()) / 90.0;
        double tiltedDivergence = oneDegreeTiltDivergence * donut3D.getTilt();
        double pt = donut3D.getProjectionThickness();
        double px1 = c.getX() + (donut3D.getOuterA() + donutSection.getDivergence()) * Math.cos(Math.toRadians(medianDegree));
        double py1 = c.getY() - (donut3D.getOuterB() + tiltedDivergence) * Math.sin(Math.toRadians(medianDegree));
        double divTilted = new Double(this.linkExtends) / 90.0 * donut3D.getTilt();
        double px2 = c.getX() + (donut3D.getOuterA() + donutSection.getDivergence() + (double)this.linkExtends) * Math.cos(Math.toRadians(medianDegree));
        double py2 = c.getY() - (donut3D.getOuterB() + tiltedDivergence + divTilted) * Math.sin(Math.toRadians(medianDegree));
        double px3 = 0.0;
        double py3 = py2;
        px3 = medianDegree >= 270.0 && medianDegree <= 360.0 || medianDegree >= 0.0 && medianDegree <= 90.0 ? c.getX() + donut3D.getOuterA() + (double)this.margin - (double)this.getLabelPaddingX() - 5.0 : c.getX() - donut3D.getOuterA() - (double)this.margin + (double)this.getLabelPaddingX() + 5.0;
        double px4 = 0.0;
        double py4 = py2;
        px4 = medianDegree >= 270.0 && medianDegree <= 360.0 || medianDegree >= 0.0 && medianDegree <= 90.0 ? c.getX() + donut3D.getOuterA() + (double)this.margin : c.getX() - donut3D.getOuterA() - (double)this.margin - (double)widthText;
        if (this.isLink()) {
            if (donutSection.getMedianDegree() > 180.0 && donutSection.getMedianDegree() < 360.0 && this.linkAlignment != LinkAlignment.Top) {
                if (this.linkAlignment == LinkAlignment.Middle) {
                    py1 += pt / 2.0;
                    py2 += pt / 2.0;
                    py3 += pt / 2.0;
                    py4 += pt / 2.0;
                } else if (this.linkAlignment == LinkAlignment.Bottom) {
                    py1 += pt;
                    py2 += pt;
                    py3 += pt;
                    py4 += pt;
                }
            }
            if (this.linkColor != null) {
                g2d.setColor(this.linkColor);
            }
            if (this.linkStroke != null) {
                g2d.setStroke(this.linkStroke);
            }
            if (this.linkStyle == LinkStyle.Line) {
                Line2D.Double l1 = new Line2D.Double(px1, py1, px2, py2);
                Line2D.Double l2 = new Line2D.Double(px2, py2, px3, py3);
                g2d.draw(l1);
                g2d.draw(l2);
            } else if (this.linkStyle == LinkStyle.Quad) {
                QuadCurve2D.Double quad = new QuadCurve2D.Double(px1, py1, px2, py2, px3, py3);
                g2d.draw(quad);
            }
            if (this.isLinkMarker()) {
                if (donutSection.getMedianDegree() > 180.0 && donutSection.getMedianDegree() < 360.0 || this.linkAlignment == LinkAlignment.Top) {
                    int markerExtends = 10;
                    double divMarkerTilted = new Double(markerExtends) / 90.0 * donut3D.getTilt();
                    double pxMarker = c.getX() + (donut3D.getOuterA() + donutSection.getDivergence() + (double)markerExtends) * Math.cos(Math.toRadians(medianDegree));
                    double pyMarker = c.getY() - (donut3D.getOuterB() + tiltedDivergence + divMarkerTilted) * Math.sin(Math.toRadians(medianDegree));
                    if (this.linkAlignment == LinkAlignment.Middle) {
                        pyMarker += pt / 2.0;
                    } else if (this.linkAlignment == LinkAlignment.Bottom) {
                        pyMarker += pt;
                    }
                    GeometryPath geometry = new GeometryPath(new Line2D.Double(pxMarker, pyMarker, px1, py1));
                    float angle = geometry.angleAtLength(0.0f);
                    int markerOrtho = 3;
                    double pxRight = pxMarker - (double)markerOrtho * Math.sin(angle);
                    double pyRight = pyMarker + (double)markerOrtho * Math.cos(angle);
                    double pxLeft = pxMarker + (double)markerOrtho * Math.sin(angle);
                    double pyLeft = pyMarker - (double)markerOrtho * Math.cos(angle);
                    GeneralPath e = new GeneralPath();
                    e.moveTo(pxRight, pyRight);
                    e.lineTo(pxLeft, pyLeft);
                    e.lineTo(px1, py1);
                    e.closePath();
                    if (this.linkMarkerFillColor != null) {
                        g2d.setColor(this.linkMarkerFillColor);
                    } else if (this.linkColor != null) {
                        g2d.setColor(this.linkColor);
                    } else {
                        g2d.setColor(donutSection.getThemeColor());
                    }
                    g2d.fill(e);
                    if (this.linkMarkerDrawColor != null) {
                        g2d.setColor(this.linkMarkerDrawColor);
                        g2d.draw(e);
                    }
                }
                g2d.setColor(donutSection.getThemeColor());
            }
        }
        g2d.setColor(donutSection.getThemeColor());
        g2d.setStroke(this.getDefaultStroke());
        float x = (float)px4;
        float y = (float)py4;
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x - (float)this.getLabelPaddingX(), y - (float)ascentText - (float)this.getLabelPaddingY(), widthText + 2 * this.getLabelPaddingX(), ascentText + descentText + 2 * this.getLabelPaddingY(), this.getOutlineRound(), this.getOutlineRound());
        if (this.getStyle() == AbstractDonut3DSliceLabel.Style.Fill || this.getStyle() == AbstractDonut3DSliceLabel.Style.Both) {
            if (this.getFillColor() != null && this.getShadeFractions() == null) {
                g2d.setColor(this.getFillColor());
                g2d.fill(rect);
            }
            if (this.getFillColor() == null && this.getShadeFractions() == null) {
                g2d.setColor(donutSection.getThemeColor());
                g2d.fill(rect);
            }
            Point2D.Double start2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY() + ((RectangularShape)rect).getHeight());
            Point2D.Double end2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY());
            if (this.getShadeFractions() != null && this.getShadeColors() != null && !start2.equals(end2)) {
                LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, this.getShadeFractions(), this.getShadeColors());
                g2d.setPaint(p2);
                g2d.fill(rect);
            }
        }
        if (this.getStyle() == AbstractDonut3DSliceLabel.Style.Stroke || this.getStyle() == AbstractDonut3DSliceLabel.Style.Both) {
            if (this.getOutlineColor() != null) {
                g2d.setColor(this.getOutlineColor());
            } else {
                g2d.setColor(donutSection.getThemeColor().brighter());
            }
            if (this.getOutlineStroke() != null) {
                g2d.setStroke(this.getOutlineStroke());
            }
            g2d.draw(rect);
        }
        g2d.setColor(donutSection.getThemeColor());
        g2d.setStroke(this.getDefaultStroke());
        g2d.setColor(donutSection.getThemeColor().brighter());
        if (this.getLabelColor() != null) {
            g2d.setColor(this.getLabelColor());
        }
        g2d.drawString(s, x, y);
    }

    public static enum LinkStyle {
        Quad("quad"),
        Line("line");

        private String style;

        private LinkStyle(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }

        public static LinkStyle parseStyle(String style) {
            if (Quad.getStyle().equalsIgnoreCase(style)) {
                return Quad;
            }
            if (Line.getStyle().equalsIgnoreCase(style)) {
                return Line;
            }
            return Quad;
        }
    }

    public static enum LinkAlignment {
        Top("top"),
        Middle("middle"),
        Bottom("bottom");

        private String linkAlignment;

        private LinkAlignment(String linkAlignment) {
            this.linkAlignment = linkAlignment;
        }

        public String getLinkAlignment() {
            return this.linkAlignment;
        }

        public static LinkAlignment parseLinkAlignment(String linkAlignment) {
            if (Top.getLinkAlignment().equalsIgnoreCase(linkAlignment)) {
                return Top;
            }
            if (Middle.getLinkAlignment().equalsIgnoreCase(linkAlignment)) {
                return Middle;
            }
            if (Bottom.getLinkAlignment().equalsIgnoreCase(linkAlignment)) {
                return Bottom;
            }
            return Top;
        }
    }
}

