/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d.painter.label;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;

public class Donut3DPathLabel
extends AbstractDonut3DSliceLabel {
    private TextPath.TextPosition textPosition = TextPath.TextPosition.Left;
    private TextPath.PathSide pathSide = TextPath.PathSide.Above;
    private float[] fractions;
    private Color[] colors;
    private int divergence = 10;
    private Donut3DFacetPathName facetPathName = Donut3DFacetPathName.OuterArcTop;
    private boolean lockReverse = false;
    private boolean autoReverse = true;
    private float offsetLeft = 10.0f;
    private float offsetRight = 10.0f;

    public Donut3DPathLabel() {
    }

    public Donut3DPathLabel(TextPath.TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public Donut3DPathLabel(String label) {
        super.setLabel(label);
    }

    public Donut3DPathLabel(String label, Color labelColor) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
    }

    public Donut3DPathLabel(String label, Color labelColor, Font labelFont) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
        super.setLabelFont(labelFont);
    }

    public Donut3DPathLabel(TextPath.TextPosition textPosition, String label) {
        this.textPosition = textPosition;
        super.setLabel(label);
    }

    public Donut3DPathLabel(TextPath.TextPosition textPosition, String label, Color labelColor) {
        this.textPosition = textPosition;
        super.setLabel(label);
        super.setLabelColor(labelColor);
    }

    public Donut3DFacetPathName getFacetPathName() {
        return this.facetPathName;
    }

    public void setFacetPathName(Donut3DFacetPathName facetPathName) {
        this.facetPathName = facetPathName;
    }

    public TextPath.TextPosition getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(TextPath.TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public boolean isLockReverse() {
        return this.lockReverse;
    }

    public void setLockReverse(boolean lockReverse) {
        this.lockReverse = lockReverse;
    }

    public boolean isAutoReverse() {
        return this.autoReverse;
    }

    public void setAutoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
    }

    public TextPath.PathSide getPathSide() {
        return this.pathSide;
    }

    public void setPathSide(TextPath.PathSide pathSide) {
        this.pathSide = pathSide;
    }

    public int getDivergence() {
        return this.divergence;
    }

    public void setDivergence(int divergence) {
        this.divergence = divergence;
    }

    public float getOffsetLeft() {
        return this.offsetLeft;
    }

    public void setOffsetLeft(float offsetLeft) {
        this.offsetLeft = offsetLeft;
    }

    public float getOffsetRight() {
        return this.offsetRight;
    }

    public void setOffsetRight(float offsetRight) {
        this.offsetRight = offsetRight;
    }

    public static int parseDivergence(String divergence) {
        try {
            return Integer.parseInt(divergence);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public void setTextShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("colors and fractions length array does not match");
        }
        this.fractions = fractions;
        this.colors = colors;
    }

    public void setTextShader(Shader shader) {
        if (shader != null) {
            this.fractions = shader.getFractions();
            this.colors = shader.getColors();
        }
    }

    public Shader getTextShader() {
        if (this.fractions != null && this.colors != null) {
            return new Shader(this.fractions, this.colors);
        }
        return null;
    }

    @Override
    protected void paintDonut3DSliceLabel(Graphics2D g2d, Donut3D donut3d, Donut3DSlice donutSlice) {
        TextPath pt = null;
        if (this.facetPathName == Donut3DFacetPathName.OuterArcTop) {
            pt = new TextPath(donutSlice.getOuterArcTop());
        }
        if (this.facetPathName == Donut3DFacetPathName.InnerArcTop) {
            pt = new TextPath(donutSlice.getInnerArcTop());
        }
        if (this.facetPathName == Donut3DFacetPathName.OuterArcBottom) {
            pt = new TextPath(donutSlice.getOuterArcBottom());
        }
        if (this.facetPathName == Donut3DFacetPathName.InnerArcBottom) {
            pt = new TextPath(donutSlice.getInnerArcBottom());
        }
        if (this.facetPathName == Donut3DFacetPathName.StartLineTop) {
            pt = new TextPath(donutSlice.getStartTopLine());
        }
        if (this.facetPathName == Donut3DFacetPathName.EndLineTop) {
            pt = new TextPath(donutSlice.getEndTopLine());
        }
        if (this.facetPathName == Donut3DFacetPathName.StartLineOuter) {
            pt = new TextPath(donutSlice.getStartOuterLine());
        }
        if (this.facetPathName == Donut3DFacetPathName.EndLineOuter) {
            pt = new TextPath(donutSlice.getEndOuterLine());
        }
        if (pt != null) {
            pt.setTextPosition(this.textPosition);
            pt.setLockReverse(this.isLockReverse());
            pt.setAutoReverse(this.isAutoReverse());
            pt.setLabel(this.getLabel());
            pt.setTextColor(this.getLabelColor());
            pt.setLabelFont(this.getLabelFont());
            pt.setOffsetLeft(this.offsetLeft);
            pt.setOffsetRight(this.offsetRight);
            pt.setPathSide(this.pathSide);
            pt.setDivergence(this.divergence);
            if (this.fractions != null && this.colors != null && this.fractions.length == this.colors.length) {
                pt.setShader(this.fractions, this.colors);
            }
            pt.draw(g2d);
        }
    }

    public static enum Donut3DFacetPathName {
        StartLineTop("start"),
        OuterArcTop("outerArcTop"),
        InnerArcTop("innerArcTop"),
        OuterArcBottom("outerArcBottom"),
        InnerArcBottom("innerArcBottom"),
        EndLineTop("endLineTop"),
        StartLineOuter("startLineOuter"),
        EndLineOuter("endLineOuter");

        private String pathName;

        private Donut3DFacetPathName(String path) {
            this.pathName = path;
        }

        public String getPathName() {
            return this.pathName;
        }

        public static Donut3DFacetPathName parse(String path) {
            if (StartLineTop.getPathName().equalsIgnoreCase(path)) {
                return StartLineTop;
            }
            if (OuterArcTop.getPathName().equalsIgnoreCase(path)) {
                return OuterArcTop;
            }
            if (EndLineTop.getPathName().equalsIgnoreCase(path)) {
                return EndLineTop;
            }
            return OuterArcTop;
        }
    }
}

