/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.donut3d.painter.label;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.PluginPlatform;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DPlugin;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.Donut3DToolkit;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DBorderLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DRadialLabel;
import org.jensoft.core.plugin.donut3d.painter.paint.Donut3DDefaultPaint;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.Portfolio;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewDefaultBackground;

public class JavadocPortfolioDonut3D {
    @Portfolio(name="Donut3DRadialLabel")
    public static View getRadialLabelView() {
        View view = new View(0);
        Projection.Linear projection = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        projection.setName("compatible donut3D");
        view.registerProjection(projection);
        Donut3DPlugin donut3DPlugin = new Donut3DPlugin();
        projection.registerPlugin(donut3DPlugin);
        ViewDefaultBackground viewBackground = new ViewDefaultBackground();
        Shader sb = new Shader(new float[]{0.0f, 1.0f}, new Color[]{new Color(32, 39, 55), Color.BLACK});
        viewBackground.setShader(sb);
        viewBackground.setOutlineStroke(new BasicStroke(2.5f));
        view.setBackgroundPainter(viewBackground);
        Donut3D donut3d = Donut3DToolkit.createDonut3D("myDonut", 20.0, 60.0, 40.0, 60.0, 40.0);
        donut3DPlugin.addDonut(donut3d);
        Donut3DSlice s1 = Donut3DToolkit.createDonut3DSlice("s1", new Color(250, 250, 250), 45.0);
        Donut3DSlice s2 = Donut3DToolkit.createDonut3DSlice("s2", TangoPalette.BUTTER2, 5.0);
        Donut3DSlice s3 = Donut3DToolkit.createDonut3DSlice("s3", TangoPalette.CHAMELEON2, 30.0);
        Donut3DSlice s4 = Donut3DToolkit.createDonut3DSlice("s4", TangoPalette.SKYBLUE2, 20.0);
        Donut3DToolkit.pushSlices(donut3d, s1, s2, s3, s4);
        Font f = new Font("Dialog", 0, 12);
        float[] fractions = new float[]{0.0f, 0.3f, 0.7f, 1.0f};
        Color[] c = new Color[]{new Color(0, 0, 0, 20), new Color(0, 0, 0, 150), new Color(0, 0, 0, 150), new Color(0, 0, 0, 20)};
        Donut3DRadialLabel label1 = Donut3DToolkit.createRadialLabel("Symbian", RosePalette.COALBLACK, f, 30, 20, AbstractDonut3DSliceLabel.Style.Both);
        label1.setLabelColor(ColorPalette.WHITE);
        label1.setOutlineColor(RosePalette.REDWOOD);
        label1.setShader(fractions, c);
        s1.addSliceLabel(label1);
        Donut3DRadialLabel label2 = Donut3DToolkit.createRadialLabel("WiMo", RosePalette.COALBLACK, f, 30, 20, AbstractDonut3DSliceLabel.Style.Both);
        label2.setLabelColor(ColorPalette.WHITE);
        label2.setOutlineColor(RosePalette.LIME);
        label2.setShader(fractions, c);
        s2.addSliceLabel(label2);
        Donut3DRadialLabel label3 = Donut3DToolkit.createRadialLabel("iPhone", RosePalette.COALBLACK, f, 30, 20, AbstractDonut3DSliceLabel.Style.Both);
        label3.setLabelColor(ColorPalette.WHITE);
        label3.setOutlineColor(RosePalette.COBALT);
        label3.setShader(fractions, c);
        s3.addSliceLabel(label3);
        Donut3DRadialLabel label4 = Donut3DToolkit.createRadialLabel("Android", RosePalette.COALBLACK, f, 30, 20, AbstractDonut3DSliceLabel.Style.Both);
        label4.setLabelColor(ColorPalette.WHITE);
        label4.setOutlineColor(RosePalette.EMERALD);
        label4.setShader(fractions, c);
        s4.addSliceLabel(label4);
        return view;
    }

    @Portfolio(name="Donut3DBorderLabel")
    public static View getBorderLabelView() {
        View view = new View(0);
        Projection.Linear projection = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        projection.setName("compatible donut3D");
        view.registerProjection(projection);
        Donut3DPlugin donut3DPlugin = new Donut3DPlugin();
        projection.registerPlugin(donut3DPlugin);
        ViewDefaultBackground viewBackground = new ViewDefaultBackground();
        Shader sb = new Shader(new float[]{0.0f, 1.0f}, new Color[]{new Color(32, 39, 55), Color.BLACK});
        viewBackground.setShader(sb);
        viewBackground.setOutlineStroke(new BasicStroke(2.5f));
        view.setBackgroundPainter(viewBackground);
        Donut3D donut3d = Donut3DToolkit.createDonut3D("myDonut", 20.0, 60.0, 40.0, 80.0, 50.0);
        donut3DPlugin.addDonut(donut3d);
        Donut3DDefaultPaint p = new Donut3DDefaultPaint(150);
        donut3d.setDonut3DPaint(p);
        Donut3DSlice s1 = Donut3DToolkit.createDonut3DSlice("s1", new Color(250, 250, 250), 45.0);
        Donut3DSlice s2 = Donut3DToolkit.createDonut3DSlice("s2", Spectral.SPECTRAL_RED, 5.0);
        Donut3DSlice s3 = Donut3DToolkit.createDonut3DSlice("s3", TangoPalette.CHAMELEON2, 30.0);
        Donut3DSlice s4 = Donut3DToolkit.createDonut3DSlice("s4", TangoPalette.SKYBLUE2, 20.0);
        Donut3DToolkit.pushSlices(donut3d, s1, s2, s3, s4);
        float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colors = new Color[]{new Color(0, 0, 0, 100), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
        BasicStroke s = new BasicStroke(2.0f);
        Font f = new Font("Dialog", 0, 12);
        Donut3DBorderLabel label1 = Donut3DToolkit.createBorderLabel("Symbian", ColorPalette.WHITE, f, 50);
        label1.setStyle(AbstractDonut3DSliceLabel.Style.Both);
        label1.setOutlineStroke(s);
        label1.setShader(fractions, colors);
        label1.setOutlineColor(RosePalette.REDWOOD);
        label1.setOutlineRound(20);
        label1.setLinkColor(RosePalette.REDWOOD);
        label1.setLinkExtends(30);
        label1.setLinkStyle(Donut3DBorderLabel.LinkStyle.Quad);
        s1.addSliceLabel(label1);
        Donut3DBorderLabel label2 = Donut3DToolkit.createBorderLabel("WiMo", ColorPalette.WHITE, f, 50);
        label2.setStyle(AbstractDonut3DSliceLabel.Style.Both);
        label2.setOutlineStroke(s);
        label2.setShader(fractions, colors);
        label2.setOutlineColor(RosePalette.LIME);
        label2.setOutlineRound(20);
        label2.setLinkColor(RosePalette.LIME);
        label2.setLinkExtends(30);
        label2.setLinkStyle(Donut3DBorderLabel.LinkStyle.Quad);
        s2.addSliceLabel(label2);
        Donut3DBorderLabel label3 = Donut3DToolkit.createBorderLabel("android", ColorPalette.WHITE, f, 50);
        label3.setStyle(AbstractDonut3DSliceLabel.Style.Both);
        label3.setOutlineStroke(s);
        label3.setShader(fractions, colors);
        label3.setOutlineColor(RosePalette.COBALT);
        label3.setOutlineRound(20);
        label3.setLinkColor(RosePalette.COBALT);
        label3.setLinkExtends(30);
        label3.setLinkStyle(Donut3DBorderLabel.LinkStyle.Quad);
        s3.addSliceLabel(label3);
        Donut3DBorderLabel label4 = Donut3DToolkit.createBorderLabel("iPhone", ColorPalette.WHITE, f, 50);
        label4.setStyle(AbstractDonut3DSliceLabel.Style.Both);
        label4.setOutlineStroke(s);
        label4.setOutlineColor(RosePalette.EMERALD);
        label4.setShader(fractions, colors);
        label4.setOutlineRound(20);
        label4.setLinkColor(RosePalette.EMERALD);
        label3.setLinkExtends(30);
        label4.setLinkStyle(Donut3DBorderLabel.LinkStyle.Quad);
        s4.addSliceLabel(label4);
        return view;
    }

    public void render() {
        String packageName = this.getClass().getPackage().getName();
        String packagePath = packageName.replace('.', File.separatorChar);
        String docFilePath = System.getProperty("user.dir") + File.separator + "src" + File.separator + packagePath + File.separator + "doc-files";
        PluginPlatform.createPortfolio(packageName, docFilePath, 400, 280);
    }

    public static void main(String[] args) {
        JavadocPortfolioDonut3D docFilePortfolio = new JavadocPortfolioDonut3D();
        docFilePortfolio.render();
    }
}

