/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.glyphmetrics.AbstractMetricsPath;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.GlyphUtil;
import org.jensoft.core.glyphmetrics.Marker;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.plugin.function.source.FunctionNature;
import org.jensoft.core.plugin.function.source.SourceFunction;

public class MetricsPathFunction
extends AbstractMetricsPath {
    private List<GlyphMetric> glyphMetrics;
    private SourceFunction sourceFunction;
    private DecimalFormat decimalFormat = new DecimalFormat("##.00");
    boolean initialized = false;
    private List<PathSegment> pathSegments;
    private List<GlyphMetric> volatileMetrics = new ArrayList<GlyphMetric>();

    public MetricsPathFunction() {
        this.setProjectionNature(AbstractMetricsPath.ProjectionNature.USER);
        this.glyphMetrics = new ArrayList<GlyphMetric>();
        this.pathSegments = new ArrayList<PathSegment>();
    }

    public MetricsPathFunction(SourceFunction source) {
        this.sourceFunction = source;
        this.setProjectionNature(AbstractMetricsPath.ProjectionNature.USER);
        this.glyphMetrics = new ArrayList<GlyphMetric>();
        this.pathSegments = new ArrayList<PathSegment>();
    }

    public SourceFunction getSource() {
        return this.sourceFunction;
    }

    public void setSource(SourceFunction source) {
        this.sourceFunction = source;
    }

    public boolean isEmpty(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        while (!pi.isDone()) {
            double[] coordinates = new double[6];
            int type = pi.currentSegment(coordinates);
            if (type == 0) {
                return false;
            }
            pi.next();
        }
        return true;
    }

    public PathSegment getPathSegment(double userX) {
        for (PathSegment cs : this.pathSegments) {
            if (!cs.match(userX)) continue;
            return cs;
        }
        return null;
    }

    public double getLengthAtSegment(PathSegment curveSegment) {
        double length = 0.0;
        for (PathSegment cs : this.pathSegments) {
            length += cs.deviceLength();
            if (!cs.equals(curveSegment)) continue;
            return length;
        }
        return 0.0;
    }

    @Override
    protected GeneralPath createPathMetrics() {
        if (this.getProjection() == null) {
            throw new NullPointerException("Projection should have been to set before invoke solving geometry");
        }
        GeneralPath path = new GeneralPath();
        if (this.sourceFunction == null) {
            return path;
        }
        List<Point2D> entries = this.sourceFunction.getNature() == FunctionNature.XFunction ? this.sourceFunction.solveFunction(this.getProjection().getMinX(), this.getProjection().getMaxX()) : this.sourceFunction.solveFunction(this.getProjection().getMinY(), this.getProjection().getMaxY());
        ArrayList<Point2D> src = new ArrayList<Point2D>();
        src.addAll(entries);
        this.pathSegments.clear();
        for (int i = 0; i < src.size(); ++i) {
            Point2D sourceFunctionEntry = (Point2D)src.get(i);
            Point2D segmentDeviceEnd = this.getProjection().userToPixel(sourceFunctionEntry);
            if (i == 0) {
                path.moveTo(segmentDeviceEnd.getX(), segmentDeviceEnd.getY());
                continue;
            }
            Point2D segmentUserStart = (Point2D)src.get(i - 1);
            Point2D segmentDeviceStart = this.getProjection().userToPixel(segmentUserStart);
            PathSegment cs = new PathSegment(segmentUserStart, sourceFunctionEntry, segmentDeviceStart, segmentDeviceEnd);
            this.pathSegments.add(cs);
            path.lineTo(segmentDeviceEnd.getX(), segmentDeviceEnd.getY());
        }
        return path;
    }

    public void addMetrics(GlyphMetric metric) {
        this.volatileMetrics.add(metric);
    }

    public void removeMetrics(GlyphMetric metric) {
        this.volatileMetrics.remove(metric);
    }

    public void clearMetrics() {
        this.volatileMetrics.clear();
    }

    public Point2D getRadialPoint(double userValue, int radius, Side side) {
        double py;
        double px;
        this.getOrCreateGeometry();
        PathSegment cs = this.getPathSegment(userValue);
        Point2D userPoint = cs.getUserPoint(userValue);
        Point2D devicePoint = this.getProjection().userToPixel(userPoint);
        double delta = Point2D.distance(devicePoint.getX(), devicePoint.getY(), cs.getSegmentDeviceEnd().getX(), cs.getSegmentDeviceEnd().getY());
        double deviceLength = this.getLengthAtSegment(cs) - delta;
        Point2D p = this.getOrCreateGeometry().pointAtLength((float)deviceLength);
        float metricAngle = this.getOrCreateGeometry().angleAtLength((float)deviceLength);
        if (side == Side.SideRight) {
            px = p.getX() - (double)radius * Math.sin(metricAngle);
            py = p.getY() + (double)radius * Math.cos(metricAngle);
        } else {
            px = p.getX() + (double)radius * Math.sin(metricAngle);
            py = p.getY() - (double)radius * Math.cos(metricAngle);
        }
        return new Point2D.Double(px, py);
    }

    @Override
    public List<GlyphMetric> getMetrics() {
        this.glyphMetrics.clear();
        if (this.sourceFunction == null) {
            return this.glyphMetrics;
        }
        if (this.getFontRenderContext() == null) {
            throw new NullPointerException("FontRenderContext should be supplied");
        }
        if (this.getOrCreateGeometry().lengthOfPath() == 0.0f) {
            return this.glyphMetrics;
        }
        for (GlyphMetric vm : this.volatileMetrics) {
            GlyphGeometry metricGlyphGeometry;
            Point2D.Double dstWest;
            Point2D.Double srcWest;
            Point2D.Double dstEast;
            Point2D.Double srcEast;
            Point2D.Double dstSouth;
            Point2D.Double srcSouth;
            Point2D.Double dstNorth;
            Point2D.Double srcNorth;
            Shape glyphTransformed;
            float angle;
            Point2D glyphPoint;
            float px;
            int j;
            GlyphMetric m = new GlyphMetric();
            this.glyphMetrics.add(m);
            m.setValue(vm.getValue());
            PathSegment cs = this.getPathSegment(vm.getValue());
            if (cs == null) continue;
            Point2D userPoint = cs.getUserPoint(vm.getValue());
            Point2D devicePoint = this.getProjection().userToPixel(userPoint);
            double delta = Point2D.distance(devicePoint.getX(), devicePoint.getY(), cs.getSegmentDeviceEnd().getX(), cs.getSegmentDeviceEnd().getY());
            double deviceLength = this.getLengthAtSegment(cs) - delta;
            m.setLengthOnPath(deviceLength);
            m.setMetricPointRef(this.getOrCreateGeometry().pointAtLength((float)deviceLength));
            m.setMetricGlyphMarker(new Marker(this.getOrCreateGeometry().pointAtLength((float)deviceLength)));
            m.setMetricAngle(this.getOrCreateGeometry().angleAtLength((float)deviceLength));
            m.setStylePosition(vm.getStylePosition());
            m.setFont(vm.getFont());
            m.setDivergence(vm.getDivergence());
            if (vm.getMetricsLabel() != null) {
                m.setMetricsLabel(vm.getMetricsLabel());
            } else if (m.getFormat() != null) {
                m.setMetricsLabel(m.getFormat().format(userPoint.getY()));
            } else {
                try {
                    m.setMetricsLabel(this.decimalFormat.format(userPoint.getY()));
                }
                catch (Exception e) {
                    m.setMetricsLabel("");
                }
            }
            m.setMetricsNature(vm.getMetricsNature());
            m.setGlyphMetricDraw(vm.getGlyphMetricDraw());
            m.setGlyphMetricFill(vm.getGlyphMetricFill());
            m.setGlyphMetricEffect(vm.getGlyphMetricEffect());
            m.setGlyphMetricMarkerPainter(vm.getGlyphMetricMarkerPainter());
            m.setLockReverse(vm.isLockReverse());
            Font f = m.getFont();
            GlyphVector glyphVector = f.createGlyphVector(this.getFontRenderContext(), m.getMetricsLabel());
            if (m.getStylePosition() == StylePosition.Tangent) {
                AffineTransform af = new AffineTransform();
                float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
                float startLength = (float)deviceLength - gvWidth / 2.0f;
                float endLength = (float)deviceLength + gvWidth / 2.0f;
                Point2D pointStart = this.getOrCreateGeometry().pointAtLength(startLength);
                Point2D pointEnd = this.getOrCreateGeometry().pointAtLength(endLength);
                m.setPointStart(pointStart);
                m.setPointEnd(pointEnd);
                if (pointStart == null || pointEnd == null) continue;
                boolean needRevert = m.isLockReverse();
                if (this.isAutoReverseGlyph() && pointStart.getX() > pointEnd.getX()) {
                    needRevert = true;
                }
                for (j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                    Point2D p = glyphVector.getGlyphPosition(j);
                    px = (float)p.getX();
                    float py = (float)p.getY();
                    glyphPoint = !needRevert ? this.getOrCreateGeometry().pointAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j)) : this.getOrCreateGeometry().pointAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                    if (glyphPoint == null) continue;
                    m.addGlyphPoint(glyphPoint);
                    af.setToTranslation(glyphPoint.getX(), glyphPoint.getY());
                    angle = 0.0f;
                    angle = !needRevert ? this.getOrCreateGeometry().angleAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j)) : this.getOrCreateGeometry().angleAtLength(endLength - GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                    if (!needRevert) {
                        af.rotate(angle);
                    } else {
                        af.rotate((double)angle + Math.PI);
                    }
                    af.translate(-px, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0 - (double)m.getDivergence());
                    Shape glyph = glyphVector.getGlyphOutline(j);
                    glyphTransformed = af.createTransformedShape(glyph);
                    srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                    dstNorth = new Point2D.Double();
                    srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                    dstSouth = new Point2D.Double();
                    srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                    dstEast = new Point2D.Double();
                    srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                    dstWest = new Point2D.Double();
                    af.transform(srcNorth, dstNorth);
                    af.transform(srcSouth, dstSouth);
                    af.transform(srcEast, dstEast);
                    af.transform(srcWest, dstWest);
                    metricGlyphGeometry = new GlyphGeometry(glyphTransformed, dstNorth, dstSouth, dstWest, dstEast);
                    m.addMetricsGlyphGeometry(metricGlyphGeometry);
                }
            }
            if (m.getStylePosition() == StylePosition.Radial) {
                float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
                Point2D pStart = m.getRadialPoint(m.getDivergence());
                Point2D pEnd = m.getRadialPoint((int)((float)m.getDivergence() + gvWidth + 10.0f));
                if (pStart == null || pEnd == null) continue;
                Line2D.Double radialFragment = pStart.getX() > pEnd.getX() ? new Line2D.Double(pEnd.getX(), pEnd.getY(), pStart.getX(), pStart.getY()) : new Line2D.Double(pStart.getX(), pStart.getY(), pEnd.getX(), pEnd.getY());
                AffineTransform af = new AffineTransform();
                GeometryPath geometryRadialpath = new GeometryPath(radialFragment);
                for (int j2 = 0; j2 < glyphVector.getNumGlyphs(); ++j2) {
                    Point2D p = glyphVector.getGlyphPosition(j2);
                    float px2 = (float)p.getX();
                    float py = (float)p.getY();
                    Point2D glyphPoint2 = geometryRadialpath.pointAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j2));
                    if (glyphPoint2 == null) continue;
                    m.addGlyphPoint(glyphPoint2);
                    Shape glyph = glyphVector.getGlyphOutline(j2);
                    angle = geometryRadialpath.angleAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j2));
                    af.setToTranslation(glyphPoint2.getX(), glyphPoint2.getY());
                    af.rotate(angle);
                    af.translate(-px2, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0);
                    Shape glyphTransformed2 = af.createTransformedShape(glyph);
                    Point2D.Double srcNorth2 = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                    Point2D.Double dstNorth2 = new Point2D.Double();
                    Point2D.Double srcSouth2 = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                    Point2D.Double dstSouth2 = new Point2D.Double();
                    Point2D.Double srcEast2 = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                    Point2D.Double dstEast2 = new Point2D.Double();
                    Point2D.Double srcWest2 = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                    Point2D.Double dstWest2 = new Point2D.Double();
                    af.transform(srcNorth2, dstNorth2);
                    af.transform(srcSouth2, dstSouth2);
                    af.transform(srcEast2, dstEast2);
                    af.transform(srcWest2, dstWest2);
                    GlyphGeometry metricGlyphGeometry2 = new GlyphGeometry(glyphTransformed2, dstNorth2, dstSouth2, dstWest2, dstEast2);
                    m.addMetricsGlyphGeometry(metricGlyphGeometry2);
                }
            }
            if (m.getStylePosition() != StylePosition.Default) continue;
            float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
            Point2D pRadial = m.getRadialPoint(m.getDivergence());
            if (pRadial == null) continue;
            Point2D.Double pStart = new Point2D.Double(pRadial.getX() - (double)(gvWidth / 2.0f), pRadial.getY());
            Point2D.Double pEnd = new Point2D.Double(pRadial.getX() + (double)(gvWidth / 2.0f), pRadial.getY());
            Line2D.Double l = new Line2D.Double(((Point2D)pStart).getX(), ((Point2D)pStart).getY(), ((Point2D)pEnd).getX(), ((Point2D)pEnd).getY());
            AffineTransform af = new AffineTransform();
            GeometryPath geometryRadialpath = new GeometryPath(l);
            for (j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                Point2D p = glyphVector.getGlyphPosition(j);
                px = (float)p.getX();
                float py = (float)p.getY();
                glyphPoint = geometryRadialpath.pointAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                if (glyphPoint == null) continue;
                m.addGlyphPoint(glyphPoint);
                Shape glyph = glyphVector.getGlyphOutline(j);
                float angle2 = geometryRadialpath.angleAtLength(GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                af.setToTranslation(glyphPoint.getX(), glyphPoint.getY());
                af.rotate(angle2);
                af.translate(-px, -py);
                glyphTransformed = af.createTransformedShape(glyph);
                srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                dstNorth = new Point2D.Double();
                srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                dstSouth = new Point2D.Double();
                srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                dstEast = new Point2D.Double();
                srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                dstWest = new Point2D.Double();
                af.transform(srcNorth, dstNorth);
                af.transform(srcSouth, dstSouth);
                af.transform(srcEast, dstEast);
                af.transform(srcWest, dstWest);
                metricGlyphGeometry = new GlyphGeometry(glyphTransformed, dstNorth, dstSouth, dstWest, dstEast);
                m.addMetricsGlyphGeometry(metricGlyphGeometry);
            }
        }
        return this.glyphMetrics;
    }

    class PathSegment {
        private Point2D segmentUserStart;
        private Point2D segmentUserEnd;
        private Point2D segmentDeviceStart;
        private Point2D segmentDeviceEnd;

        public PathSegment(Point2D segmentUserStart, Point2D segmentUserEnd, Point2D segmentDeviceStart, Point2D segmentDeviceEnd) {
            this.segmentUserStart = segmentUserStart;
            this.segmentUserEnd = segmentUserEnd;
            this.segmentDeviceStart = segmentDeviceStart;
            this.segmentDeviceEnd = segmentDeviceEnd;
        }

        public Point2D getSegmentDeviceStart() {
            return this.segmentDeviceStart;
        }

        public void setSegmentDeviceStart(Point2D segmentStart) {
            this.segmentDeviceStart = segmentStart;
        }

        public Point2D getSegmentDeviceEnd() {
            return this.segmentDeviceEnd;
        }

        public void setSegmentDeviceEnd(Point2D segmentEnd) {
            this.segmentDeviceEnd = segmentEnd;
        }

        public boolean match(double value) {
            if (MetricsPathFunction.this.sourceFunction.getNature() == FunctionNature.XFunction) {
                return value >= this.segmentUserStart.getX() && value <= this.segmentUserEnd.getX();
            }
            return value >= this.segmentUserStart.getY() && value <= this.segmentUserEnd.getY();
        }

        public Point2D getUserPoint(double value) {
            if (MetricsPathFunction.this.sourceFunction.getNature() == FunctionNature.XFunction) {
                double userY = this.getCoefficient() * value + this.getConstant();
                return new Point2D.Double(value, userY);
            }
            double userX = this.getCoefficient() * value + this.getConstant();
            return new Point2D.Double(userX, value);
        }

        public Point2D getSegmentUserStart() {
            return this.segmentUserStart;
        }

        public void setSegmentUserStart(Point2D segmentUserStart) {
            this.segmentUserStart = segmentUserStart;
        }

        public Point2D getSegmentUserEnd() {
            return this.segmentUserEnd;
        }

        public void setSegmentUserEnd(Point2D segmentUserEnd) {
            this.segmentUserEnd = segmentUserEnd;
        }

        public double deviceLength() {
            return Point2D.distance(this.segmentDeviceStart.getX(), this.segmentDeviceStart.getY(), this.segmentDeviceEnd.getX(), this.segmentDeviceEnd.getY());
        }

        public double getCoefficient() {
            if (MetricsPathFunction.this.sourceFunction.getNature() == FunctionNature.XFunction) {
                return (this.segmentUserEnd.getY() - this.segmentUserStart.getY()) / (this.segmentUserEnd.getX() - this.segmentUserStart.getX());
            }
            return (this.segmentUserEnd.getX() - this.segmentUserStart.getX()) / (this.segmentUserEnd.getY() - this.segmentUserStart.getY());
        }

        public double getConstant() {
            if (MetricsPathFunction.this.sourceFunction.getNature() == FunctionNature.XFunction) {
                return this.segmentUserStart.getY() - this.getCoefficient() * this.segmentUserStart.getX();
            }
            return this.segmentUserStart.getX() - this.getCoefficient() * this.segmentUserStart.getY();
        }

        public String toString() {
            return "PathSegment [segmentUserStart=" + this.segmentUserStart + ", segmentUserEnd=" + this.segmentUserEnd + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathSegment other = (PathSegment)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.segmentUserEnd == null ? other.segmentUserEnd != null : !this.segmentUserEnd.equals(other.segmentUserEnd)) {
                return false;
            }
            return !(this.segmentUserStart == null ? other.segmentUserStart != null : !this.segmentUserStart.equals(other.segmentUserStart));
        }

        private MetricsPathFunction getOuterType() {
            return MetricsPathFunction.this;
        }
    }
}

