/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.analysis;

import java.io.Serializable;
import java.util.Arrays;
import org.jensoft.core.plugin.function.analysis.DifferentiableUnivariateRealFunction;
import org.jensoft.core.plugin.function.analysis.UnivariateRealFunction;

public class PolynomialFunction
implements DifferentiableUnivariateRealFunction,
Serializable {
    private static final long serialVersionUID = -7726511984200295583L;
    private final double[] coefficients;

    public PolynomialFunction(double[] c) {
        int n;
        if (n == 0) {
            throw new IllegalArgumentException("coefficients should be supplied");
        }
        for (n = c.length; n > 1 && c[n - 1] == 0.0; --n) {
        }
        this.coefficients = new double[n];
        System.arraycopy(c, 0, this.coefficients, 0, n);
    }

    @Override
    public double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    protected static double evaluate(double[] coefficients, double argument) {
        int n = coefficients.length;
        if (n == 0) {
            throw new IllegalArgumentException("coefficients should be supplied");
        }
        double result = coefficients[n - 1];
        for (int j = n - 2; j >= 0; --j) {
            result = argument * result + coefficients[j];
        }
        return result;
    }

    public PolynomialFunction add(PolynomialFunction p) {
        int lowLength = PolynomialFunction.min(this.coefficients.length, p.coefficients.length);
        int highLength = PolynomialFunction.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        for (int i = 0; i < lowLength; ++i) {
            newCoefficients[i] = this.coefficients[i] + p.coefficients[i];
        }
        System.arraycopy(this.coefficients.length < p.coefficients.length ? p.coefficients : this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction subtract(PolynomialFunction p) {
        int i;
        int lowLength = PolynomialFunction.min(this.coefficients.length, p.coefficients.length);
        int highLength = PolynomialFunction.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        for (i = 0; i < lowLength; ++i) {
            newCoefficients[i] = this.coefficients[i] - p.coefficients[i];
        }
        if (this.coefficients.length < p.coefficients.length) {
            for (i = lowLength; i < highLength; ++i) {
                newCoefficients[i] = -p.coefficients[i];
            }
        } else {
            System.arraycopy(this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction negate() {
        double[] newCoefficients = new double[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            newCoefficients[i] = -this.coefficients[i];
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction multiply(PolynomialFunction p) {
        double[] newCoefficients = new double[this.coefficients.length + p.coefficients.length - 1];
        for (int i = 0; i < newCoefficients.length; ++i) {
            newCoefficients[i] = 0.0;
            for (int j = PolynomialFunction.max(0, i + 1 - p.coefficients.length); j < PolynomialFunction.min(this.coefficients.length, i + 1); ++j) {
                int n = i;
                newCoefficients[n] = newCoefficients[n] + this.coefficients[j] * p.coefficients[i - j];
            }
        }
        return new PolynomialFunction(newCoefficients);
    }

    protected static double[] differentiate(double[] coefficients) {
        int n = coefficients.length;
        if (n == 0) {
            throw new IllegalArgumentException("coefficients should be supplied");
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] result = new double[n - 1];
        for (int i = n - 1; i > 0; --i) {
            result[i - 1] = (double)i * coefficients[i];
        }
        return result;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    @Override
    public UnivariateRealFunction derivative() {
        return this.polynomialDerivative();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.coefficients[0] == 0.0) {
            if (this.coefficients.length == 1) {
                return "0";
            }
        } else {
            s.append(Double.toString(this.coefficients[0]));
        }
        for (int i = 1; i < this.coefficients.length; ++i) {
            if (this.coefficients[i] == 0.0) continue;
            if (s.length() > 0) {
                if (this.coefficients[i] < 0.0) {
                    s.append(" - ");
                } else {
                    s.append(" + ");
                }
            } else if (this.coefficients[i] < 0.0) {
                s.append("-");
            }
            double absAi = PolynomialFunction.abs(this.coefficients[i]);
            if (absAi - 1.0 != 0.0) {
                s.append(Double.toString(absAi));
                s.append(' ');
            }
            s.append("x");
            if (i <= 1) continue;
            s.append('^');
            s.append(Integer.toString(i));
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolynomialFunction)) {
            return false;
        }
        PolynomialFunction other = (PolynomialFunction)obj;
        return Arrays.equals(this.coefficients, other.coefficients);
    }

    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long min(long a, long b) {
        return a <= b ? a : b;
    }

    public static float min(float a, float b) {
        if (a > b) {
            return b;
        }
        if (a < b) {
            return a;
        }
        if (a != b) {
            return Float.NaN;
        }
        int bits = Float.floatToRawIntBits(a);
        if (bits == Integer.MIN_VALUE) {
            return a;
        }
        return b;
    }

    public static double min(double a, double b) {
        if (a > b) {
            return b;
        }
        if (a < b) {
            return a;
        }
        if (a != b) {
            return Double.NaN;
        }
        long bits = Double.doubleToRawLongBits(a);
        if (bits == Long.MIN_VALUE) {
            return a;
        }
        return b;
    }

    public static int max(int a, int b) {
        return a <= b ? b : a;
    }

    public static long max(long a, long b) {
        return a <= b ? b : a;
    }

    public static float max(float a, float b) {
        if (a > b) {
            return a;
        }
        if (a < b) {
            return b;
        }
        if (a != b) {
            return Float.NaN;
        }
        int bits = Float.floatToRawIntBits(a);
        if (bits == Integer.MIN_VALUE) {
            return b;
        }
        return a;
    }

    public static double max(double a, double b) {
        if (a > b) {
            return a;
        }
        if (a < b) {
            return b;
        }
        if (a != b) {
            return Double.NaN;
        }
        long bits = Double.doubleToRawLongBits(a);
        if (bits == Long.MIN_VALUE) {
            return b;
        }
        return a;
    }

    public static int abs(int x) {
        return x < 0 ? -x : x;
    }

    public static long abs(long x) {
        return x < 0L ? -x : x;
    }

    public static float abs(float x) {
        return x < 0.0f ? -x : (x == 0.0f ? 0.0f : x);
    }

    public static double abs(double x) {
        return x < 0.0 ? -x : (x == 0.0 ? 0.0 : x);
    }
}

