/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.area.painter.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.plugin.function.area.Area;
import org.jensoft.core.plugin.function.area.painter.draw.AbstractAreaDraw;

public class AreaDefaultDraw
extends AbstractAreaDraw {
    private Color curveColor;
    private Stroke curveStroke = new BasicStroke();
    private Color baseColor;
    private Stroke baseStroke = new BasicStroke();

    public AreaDefaultDraw() {
    }

    public AreaDefaultDraw(Color outlineColor) {
        this.curveColor = outlineColor;
    }

    public AreaDefaultDraw(Color outlineColor, Stroke outlineStroke) {
        this.curveColor = outlineColor;
        this.curveStroke = outlineStroke;
    }

    public AreaDefaultDraw(Color curveColor, Color baseColor) {
        this.curveColor = curveColor;
        this.baseColor = baseColor;
    }

    public AreaDefaultDraw(Color curveColor, Stroke curveStroke, Color baseColor, Stroke baseStroke) {
        this.curveColor = curveColor;
        this.curveStroke = curveStroke;
        this.baseColor = baseColor;
        this.baseStroke = baseStroke;
    }

    public Color getCurveColor() {
        return this.curveColor;
    }

    public void setCurveColor(Color curveColor) {
        this.curveColor = curveColor;
    }

    public Stroke getCurveStroke() {
        return this.curveStroke;
    }

    public void setCurveStroke(Stroke curveStroke) {
        this.curveStroke = curveStroke;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor;
    }

    public Stroke getBaseStroke() {
        return this.baseStroke;
    }

    public void setBaseStroke(Stroke baseStroke) {
        this.baseStroke = baseStroke;
    }

    @Override
    public void paintAreaDraw(Graphics2D g2d, Area areaCurve) {
        if (areaCurve.getPathFunction() == null || areaCurve.getPathFunction().getOrCreateGeometry() == null || areaCurve.getPathFunction().getOrCreateGeometry().getPath() == null) {
            return;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        if (this.getCurveColor() != null) {
            g2d.setColor(this.getCurveColor());
        } else if (areaCurve.getThemeColor() != null) {
            g2d.setColor(areaCurve.getThemeColor());
        } else if (areaCurve.getHost().getProjection().getThemeColor() != null) {
            g2d.setColor(areaCurve.getHost().getProjection().getThemeColor());
        }
        if (this.getCurveStroke() != null) {
            g2d.setStroke(this.getCurveStroke());
        }
        g2d.draw(areaCurve.getPathFunction().getOrCreateGeometry().getPath());
        if (this.getBaseColor() != null) {
            g2d.setColor(this.getBaseColor());
        } else if (areaCurve.getThemeColor() != null) {
            g2d.setColor(areaCurve.getThemeColor());
        } else if (areaCurve.getHost().getProjection().getThemeColor() != null) {
            g2d.setColor(areaCurve.getHost().getProjection().getThemeColor());
        }
        if (this.getBaseStroke() != null) {
            g2d.setStroke(this.getBaseStroke());
        }
        g2d.draw(areaCurve.getBaseLine());
    }
}

