/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.area.painter.fill;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.function.area.Area;
import org.jensoft.core.plugin.function.area.painter.fill.AbstractAreaFill;
import org.jensoft.core.plugin.function.source.FunctionNature;

public class AreaGradientFill
extends AbstractAreaFill {
    private Color color1;
    private Color color2;
    private float[] shadeFractions;
    private Color[] shadeColors;

    public AreaGradientFill() {
    }

    public AreaGradientFill(Color color1, Color color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    public AreaGradientFill(float[] shadeFractions, Color[] shadeColors) {
        this.shadeFractions = shadeFractions;
        this.shadeColors = shadeColors;
    }

    public AreaGradientFill(Shader shader) {
        this.shadeFractions = shader.getFractions();
        this.shadeColors = shader.getColors();
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }

    public float[] getShadeFractions() {
        return this.shadeFractions;
    }

    public Color[] getShadeColors() {
        return this.shadeColors;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        if (shader.getFractions().length != shader.getColors().length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = shader.getFractions();
        this.shadeColors = shader.getColors();
    }

    @Override
    public final void paintAreaFill(Graphics2D g2d, Area area) {
        java.awt.geom.Area shape = area.getArea();
        if (shape == null) {
            return;
        }
        Rectangle2D rect = shape.getBounds2D();
        LinearGradientPaint gradient = null;
        if (this.color1 != null && this.color2 == null) {
            this.color2 = this.color1;
        }
        if (this.color1 != null && this.color2 != null && this.shadeFractions == null) {
            float[] f = new float[]{0.0f, 1.0f};
            Color[] c = new Color[]{this.color1, this.color2};
            gradient = area.getSourceFunction().getNature() == FunctionNature.XFunction ? new LinearGradientPaint(new Point2D.Double(rect.getCenterX(), rect.getMinY()), new Point2D.Double(rect.getCenterX(), rect.getMaxY()), f, c) : new LinearGradientPaint(new Point2D.Double(rect.getMaxX(), rect.getCenterY()), new Point2D.Double(rect.getMinX(), rect.getCenterY()), f, c);
        } else if (this.shadeFractions != null && this.shadeColors != null && this.shadeFractions.length == this.shadeColors.length) {
            gradient = area.getSourceFunction().getNature() == FunctionNature.XFunction ? new LinearGradientPaint(new Point2D.Double(rect.getCenterX(), rect.getMinY()), new Point2D.Double(rect.getCenterX(), rect.getMaxY()), this.shadeFractions, this.shadeColors) : new LinearGradientPaint(new Point2D.Double(rect.getMaxX(), rect.getCenterY()), new Point2D.Double(rect.getMinX(), rect.getCenterY()), this.shadeFractions, this.shadeColors);
        } else {
            float[] f = new float[]{0.0f, 1.0f};
            Color[] c = new Color[]{area.getThemeColor(), ColorPalette.alpha(area.getThemeColor(), 80)};
            if (area.getSourceFunction().getNature() == FunctionNature.XFunction) {
                Point2D.Double end;
                Point2D.Double start = new Point2D.Double(rect.getCenterX(), rect.getMinY());
                if (!start.equals(end = new Point2D.Double(rect.getCenterX(), rect.getMaxY()))) {
                    gradient = new LinearGradientPaint(start, end, f, c);
                }
            } else {
                Point2D.Double end;
                Point2D.Double start = new Point2D.Double(rect.getMaxX(), rect.getCenterY());
                if (!start.equals(end = new Point2D.Double(rect.getMinX(), rect.getCenterY()))) {
                    gradient = new LinearGradientPaint(start, end, f, c);
                }
            }
        }
        if (gradient != null) {
            g2d.setPaint(gradient);
            g2d.fill(area.getArea());
        }
    }
}

