/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.scatter.morphe;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import org.jensoft.core.plugin.function.scatter.morphe.ScatterMorphe;

public class QStarMorphe
extends ScatterMorphe {
    private double internalRadius;
    private double externalRadius;
    private double branchCount;
    double startAngleDegree = 60.0;

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public QStarMorphe(double internalRadius, double externalRadius, double branchCount) {
        this.internalRadius = internalRadius;
        this.externalRadius = externalRadius;
        this.branchCount = branchCount;
    }

    public double getInternalRadius() {
        return this.internalRadius;
    }

    public void setInternalRadius(double internalRadius) {
        this.internalRadius = internalRadius;
    }

    public double getExternalRadius() {
        return this.externalRadius;
    }

    public void setExternalRadius(double externalRadius) {
        this.externalRadius = externalRadius;
    }

    public double getBranchCount() {
        return this.branchCount;
    }

    public void setBranchCount(double branchCount) {
        this.branchCount = branchCount;
    }

    @Override
    public Shape getMorphe() {
        GeneralPath morphe = new GeneralPath();
        double angleStar = 360.0 / this.branchCount;
        double centerX = this.externalRadius;
        double centerY = this.externalRadius;
        int i = 0;
        while ((double)i < this.branchCount) {
            double pXExternal = centerX + this.externalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pYExternal = centerY - this.externalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pXInternal = centerX + this.internalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
            double pYInternal = centerY - this.internalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
            double pXExternal2 = centerX + this.externalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
            double pYExternal2 = centerY - this.externalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
            QuadCurve2D.Double l = new QuadCurve2D.Double(pXExternal, pYExternal, pXInternal, pYInternal, pXExternal2, pYExternal2);
            morphe.append(l, true);
            ++i;
        }
        morphe.closePath();
        return morphe;
    }
}

