/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.scatter.morphe;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.jensoft.core.plugin.function.scatter.morphe.ScatterMorphe;

public class StarMorphe
extends ScatterMorphe {
    private int internalRadius;
    private int externalRadius;
    private int branchCount;
    double startAngleDegree = 60.0;

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public StarMorphe(int internalRadius, int externalRadius, int branchCount) {
        this.internalRadius = internalRadius;
        this.externalRadius = externalRadius;
        this.branchCount = branchCount;
    }

    public double getInternalRadius() {
        return this.internalRadius;
    }

    public void setInternalRadius(int internalRadius) {
        this.internalRadius = internalRadius;
    }

    public double getExternalRadius() {
        return this.externalRadius;
    }

    public void setExternalRadius(int externalRadius) {
        this.externalRadius = externalRadius;
    }

    public double getBranchCount() {
        return this.branchCount;
    }

    public void setBranchCount(int branchCount) {
        this.branchCount = branchCount;
    }

    @Override
    public Shape getMorphe() {
        GeneralPath morphe = new GeneralPath();
        double angleStar = 360.0 / (double)this.branchCount;
        double centerX = this.externalRadius;
        double centerY = this.externalRadius;
        for (int i = 0; i < this.branchCount; ++i) {
            double pXExternal = centerX + (double)this.externalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pYExternal = centerY - (double)this.externalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pXInternal = centerX + (double)this.internalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
            double pYInternal = centerY - (double)this.internalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
            Line2D.Double l = new Line2D.Double(pXExternal, pYExternal, pXInternal, pYInternal);
            morphe.append(l, true);
        }
        morphe.closePath();
        return morphe;
    }
}

