/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.source;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.function.source.AbstractSourceFunction;
import org.jensoft.core.plugin.function.source.FunctionNature;

public class MathSourceFunction
extends AbstractSourceFunction {
    private double delta;
    private MathFunction mathFunction;

    public MathSourceFunction(MathFunction mathFunction, double delta) {
        this.mathFunction = mathFunction;
        this.delta = delta;
    }

    public MathSourceFunction(MathFunction mathFunction, double delta, FunctionNature nature) {
        super(nature);
        this.mathFunction = mathFunction;
        this.delta = delta;
    }

    @Override
    public List<Point2D> solveFunction(double start, double end) {
        ArrayList<Point2D> newFunction = new ArrayList<Point2D>();
        for (double d = start; d <= end; d += this.delta) {
            newFunction.add(this.evaluate(d));
        }
        return newFunction;
    }

    @Override
    public Point2D evaluate(double value) {
        if (FunctionNature.XFunction == this.getNature()) {
            if (MathFunction.cos == this.mathFunction) {
                return new Point2D.Double(value, Math.cos(value));
            }
            return new Point2D.Double(value, Math.cos(value));
        }
        if (MathFunction.cos == this.mathFunction) {
            return new Point2D.Double(Math.cos(value), value);
        }
        return new Point2D.Double(Math.cos(value), value);
    }

    public static enum MathFunction {
        cos,
        cosh,
        acos,
        sin,
        sinh,
        asin,
        tan,
        tanh,
        atan,
        abs,
        log,
        log10,
        sqrt,
        cbrt,
        exp;

    }
}

