/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.source;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jensoft.core.plugin.function.analysis.AnalysisException;
import org.jensoft.core.plugin.function.analysis.SimpleRegression;
import org.jensoft.core.plugin.function.analysis.SplineInterpolator;
import org.jensoft.core.plugin.function.analysis.UnivariateRealFunction;
import org.jensoft.core.plugin.function.source.AbstractSourceFunction;
import org.jensoft.core.plugin.function.source.FunctionNature;

public abstract class UserSourceFunction
extends AbstractSourceFunction {
    public UserSourceFunction() {
    }

    public UserSourceFunction(FunctionNature nature) {
        super(nature);
    }

    public static List<Point2D> createPointsFromArray(double[] xValues, double[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException(" x and y  array values length does not match");
        }
        ArrayList<Point2D> source = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            source.add(new Point2D.Double(xValues[i], yValues[i]));
        }
        return source;
    }

    public static List<Point2D> createPointsFromArray(Double[] xValues, Double[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException(" x and y  array values length does not match");
        }
        ArrayList<Point2D> source = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            source.add(new Point2D.Double(xValues[i], yValues[i]));
        }
        return source;
    }

    public static List<Point2D> createPointsFromArray(Date[] xValues, double[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException(" x and y  array values length does not match");
        }
        ArrayList<Point2D> source = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            source.add(new Point2D.Double(new Long(xValues[i].getTime()).doubleValue(), yValues[i]));
        }
        return source;
    }

    public static List<Point2D> createPointsFromArray(Date[] xValues, Double[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException(" x and y  array values length does not match");
        }
        ArrayList<Point2D> source = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            source.add(new Point2D.Double(new Long(xValues[i].getTime()).doubleValue(), yValues[i]));
        }
        return source;
    }

    public static List<Point2D> createPointsFromArray(Double[] xValues, Date[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException(" x and y  array values length does not match");
        }
        ArrayList<Point2D> source = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            source.add(new Point2D.Double(xValues[i], new Long(yValues[i].getTime()).doubleValue()));
        }
        return source;
    }

    public static List<Point2D> createPointsFromArray(double[] xValues, Date[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException(" x and y  array values length does not match");
        }
        ArrayList<Point2D> source = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            source.add(new Point2D.Double(xValues[i], new Long(yValues[i].getTime()).doubleValue()));
        }
        return source;
    }

    public static class RegressionSource
    extends LineSource {
        private SimpleRegression evaluateFunction = null;
        private double delta;

        public RegressionSource(Date[] xValues, double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public RegressionSource(Date[] xValues, Double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public RegressionSource(Date[] xValues, double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public RegressionSource(Date[] xValues, Double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public RegressionSource(double[] xValues, Date[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public RegressionSource(Double[] xValues, Date[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public RegressionSource(double[] xValues, Date[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public RegressionSource(Double[] xValues, Date[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public RegressionSource(double[] xValues, double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public RegressionSource(Double[] xValues, Double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public RegressionSource(double[] xValues, double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public RegressionSource(Double[] xValues, Double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public RegressionSource(List<Point2D> source, FunctionNature nature, double delta) {
            super(source, nature);
            this.delta = delta;
        }

        @Override
        public void setSource(List<Point2D> source) {
            super.setSource(source);
            this.evaluateFunction = null;
        }

        @Override
        public List<Point2D> solveFunction(double start, double end) {
            if (this.evaluateFunction == null) {
                this.createInterpolateFunction();
            }
            if (this.evaluateFunction == null) {
                return this.getSource();
            }
            ArrayList<Point2D> newFunction = new ArrayList<Point2D>();
            Point2D pd2Min = this.getSource().get(0);
            Point2D pd2Max = this.getSource().get(this.getSource().size() - 1);
            if (this.getNature() == FunctionNature.XFunction) {
                for (double x = pd2Min.getX(); x <= pd2Max.getX(); x += this.delta) {
                    newFunction.add(new Point2D.Double(x, this.evaluateFunction.predict(x)));
                }
            } else {
                for (double y = pd2Min.getY(); y <= pd2Max.getY(); y += this.delta) {
                    newFunction.add(new Point2D.Double(this.evaluateFunction.predict(y), y));
                }
            }
            return newFunction;
        }

        @Override
        public Point2D evaluate(double value) {
            if (this.evaluateFunction == null) {
                this.createInterpolateFunction();
            }
            Point2D.Double evaluatePoint = null;
            try {
                evaluatePoint = this.getNature() == FunctionNature.XFunction ? new Point2D.Double(value, this.evaluateFunction.predict(value)) : new Point2D.Double(this.evaluateFunction.predict(value), value);
            }
            catch (Exception e) {
                // empty catch block
            }
            return evaluatePoint;
        }

        public void createInterpolateFunction() {
            this.evaluateFunction = new SimpleRegression();
            List<Point2D> source = this.getSource();
            for (int i = 0; i < source.size(); ++i) {
                Point2D p2d = source.get(i);
                this.evaluateFunction.addData(p2d.getX(), p2d.getY());
            }
        }
    }

    public static class SplineSource
    extends LineSource {
        private UnivariateRealFunction evaluateFunction = null;
        private double delta;

        public SplineSource(Date[] xValues, double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public SplineSource(Date[] xValues, Double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public SplineSource(Date[] xValues, double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public SplineSource(Date[] xValues, Double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public SplineSource(double[] xValues, Date[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public SplineSource(Double[] xValues, Date[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public SplineSource(double[] xValues, Date[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public SplineSource(Double[] xValues, Date[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public SplineSource(double[] xValues, double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public SplineSource(Double[] xValues, Double[] yValues, FunctionNature nature, double delta) {
            super(xValues, yValues, nature);
            this.delta = delta;
        }

        public SplineSource(double[] xValues, double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public SplineSource(Double[] xValues, Double[] yValues, double delta) {
            super(xValues, yValues);
            this.delta = delta;
        }

        public SplineSource(List<Point2D> source, FunctionNature nature, double delta) {
            super(source, nature);
            this.delta = delta;
        }

        public SplineSource(List<Point2D> source, double delta) {
            super(source);
            this.delta = delta;
        }

        @Override
        public void setSource(List<Point2D> source) {
            super.setSource(source);
            this.evaluateFunction = null;
        }

        @Override
        public Point2D evaluate(double value) {
            if (this.evaluateFunction == null) {
                this.createInterpolateFunction();
            }
            Point2D.Double evaluatePoint = null;
            try {
                evaluatePoint = this.getNature() == FunctionNature.XFunction ? new Point2D.Double(value, this.evaluateFunction.value(value)) : new Point2D.Double(this.evaluateFunction.value(value), value);
            }
            catch (AnalysisException e) {
                // empty catch block
            }
            return evaluatePoint;
        }

        @Override
        public List<Point2D> solveFunction(double start, double end) {
            this.sortFunction();
            ArrayList<Point2D> interpolateSource = new ArrayList<Point2D>();
            List<Point2D> superSource = this.getSource();
            if (this.evaluateFunction == null) {
                this.createInterpolateFunction();
            }
            if (this.evaluateFunction == null) {
                return this.getSource();
            }
            Point2D pd2Min = superSource.get(0);
            Point2D pd2Max = superSource.get(superSource.size() - 1);
            if (this.getNature() == FunctionNature.XFunction) {
                for (double x = pd2Min.getX(); x <= pd2Max.getX(); x += this.delta) {
                    try {
                        if (!(x > pd2Min.getX()) || !(x < pd2Max.getX())) continue;
                        interpolateSource.add(new Point2D.Double(x, this.evaluateFunction.value(x)));
                        continue;
                    }
                    catch (AnalysisException e) {
                        return this.getSource();
                    }
                }
            } else {
                for (double y = pd2Min.getY(); y <= pd2Max.getY(); y += this.delta) {
                    try {
                        if (!(y > pd2Min.getY()) || !(y < pd2Max.getY())) continue;
                        interpolateSource.add(new Point2D.Double(this.evaluateFunction.value(y), y));
                        continue;
                    }
                    catch (AnalysisException e) {
                        return this.getSource();
                    }
                }
            }
            return interpolateSource;
        }

        private void createInterpolateFunction() {
            try {
                List<Point2D> suserSource = this.getSource();
                int len = suserSource.size();
                double[] xValues = new double[len];
                double[] yValues = new double[len];
                for (int i = 0; i < suserSource.size(); ++i) {
                    Point2D p2dUser = suserSource.get(i);
                    xValues[i] = p2dUser.getX();
                    yValues[i] = p2dUser.getY();
                }
                SplineInterpolator interpolator = new SplineInterpolator();
                this.evaluateFunction = this.getNature() == FunctionNature.XFunction ? interpolator.interpolate(xValues, yValues) : interpolator.interpolate(yValues, xValues);
            }
            catch (AnalysisException analysisException) {
                // empty catch block
            }
        }
    }

    public static class LineSource
    extends UserSourceFunction {
        private List<Point2D> source;
        private ValueComparator valueComparator = new ValueComparator();

        public LineSource(List<Point2D> source) {
            this.source = source;
            this.sortFunction();
        }

        public LineSource(double[] xValues, double[] yValues) {
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Date[] xValues, double[] yValues) {
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(double[] xValues, Date[] yValues) {
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Double[] xValues, Double[] yValues) {
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Date[] xValues, Double[] yValues) {
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Double[] xValues, Date[] yValues) {
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(List<Point2D> source, FunctionNature nature) {
            super(nature);
            this.source = source;
            this.sortFunction();
        }

        public LineSource(double[] xValues, double[] yValues, FunctionNature nature) {
            super(nature);
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Date[] xValues, double[] yValues, FunctionNature nature) {
            super(nature);
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(double[] xValues, Date[] yValues, FunctionNature nature) {
            super(nature);
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Double[] xValues, Double[] yValues, FunctionNature nature) {
            super(nature);
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Date[] xValues, Double[] yValues, FunctionNature nature) {
            super(nature);
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public LineSource(Double[] xValues, Date[] yValues, FunctionNature nature) {
            super(nature);
            this.source = LineSource.createPointsFromArray(xValues, yValues);
            this.sortFunction();
        }

        public void setSource(List<Point2D> source) {
            this.source = source;
            this.clearCurrentFunction();
            this.sortFunction();
        }

        public List<Point2D> getSource() {
            return this.source;
        }

        @Override
        public List<Point2D> solveFunction(double start, double end) {
            Point2D next;
            Point2D previous;
            ArrayList<Point2D> newFunction = new ArrayList<Point2D>();
            List<Point2D> source = this.getSource();
            if (FunctionNature.XFunction == this.getNature()) {
                for (Point2D p : source) {
                    if (!(p.getX() >= start) || !(p.getX() <= end)) continue;
                    newFunction.add(p);
                }
            } else {
                for (Point2D p : source) {
                    if (!(p.getY() >= start) || !(p.getY() <= end)) continue;
                    newFunction.add(p);
                }
            }
            if (newFunction.size() >= 1) {
                if (FunctionNature.XFunction == this.getNature()) {
                    previous = this.previous(((Point2D)newFunction.get(0)).getX());
                    next = this.next(((Point2D)newFunction.get(newFunction.size() - 1)).getX());
                } else {
                    previous = this.previous(((Point2D)newFunction.get(0)).getY());
                    next = this.next(((Point2D)newFunction.get(newFunction.size() - 1)).getY());
                }
                if (previous != null && !previous.equals(newFunction.get(0))) {
                    newFunction.add(0, previous);
                }
                if (next != null && !next.equals(newFunction.get(newFunction.size() - 1))) {
                    newFunction.add(next);
                }
            } else {
                previous = this.previous(start);
                next = this.next(end);
                if (previous != null) {
                    newFunction.add(0, previous);
                }
                if (next != null) {
                    newFunction.add(next);
                }
            }
            return newFunction;
        }

        private Point2D next(double value) {
            List<Point2D> functionPoints = this.getSource();
            for (int i = 0; i < functionPoints.size(); ++i) {
                Point2D p = functionPoints.get(i);
                if (!(FunctionNature.XFunction == this.getNature() ? p.getX() > value : p.getY() > value)) continue;
                return p;
            }
            return null;
        }

        private Point2D previous(double value) {
            List<Point2D> functionPoints = this.getSource();
            for (int i = functionPoints.size() - 1; i >= 0; --i) {
                Point2D p = functionPoints.get(i);
                if (!(FunctionNature.XFunction == this.getNature() ? p.getX() < value : p.getY() < value)) continue;
                return p;
            }
            return null;
        }

        @Override
        public Point2D evaluate(double value) {
            Point2D previous = this.previous(value);
            Point2D next = this.next(value);
            if (previous != null && next != null) {
                double coefficient = 0.0;
                double constant = 0.0;
                if (this.getNature() == FunctionNature.XFunction) {
                    coefficient = (next.getY() - previous.getY()) / (next.getX() - previous.getX());
                    constant = previous.getY() - coefficient * previous.getX();
                    return new Point2D.Double(value, coefficient * value + constant);
                }
                coefficient = (next.getX() - previous.getX()) / (next.getY() - previous.getY());
                constant = previous.getX() - coefficient * previous.getY();
                return new Point2D.Double(coefficient * value + constant, value);
            }
            return null;
        }

        public void sortFunction() {
            if (this.source != null) {
                Collections.sort(this.source, this.valueComparator);
            }
        }

        class ValueComparator
        implements Comparator<Point2D> {
            @Override
            public int compare(Point2D p2d1, Point2D p2d2) {
                if (FunctionNature.XFunction == LineSource.this.getNature()) {
                    if (p2d1.getX() > p2d2.getX()) {
                        return 1;
                    }
                    if (p2d1.getX() < p2d2.getX()) {
                        return -1;
                    }
                    return 0;
                }
                if (p2d1.getY() > p2d2.getY()) {
                    return 1;
                }
                if (p2d1.getY() < p2d2.getY()) {
                    return -1;
                }
                return 0;
            }
        }
    }
}

