/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.tools.peaktracker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.PluginListener;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.plugin.function.tools.peaktracker.PeakTrackerEvent;
import org.jensoft.core.plugin.function.tools.peaktracker.PeakTrackerListener;
import org.jensoft.core.plugin.function.tools.peaktracker.PeakTrackerPlugin;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;

public class PeakTrackerDeviceContext
extends ContextEntry<PeakTrackerPlugin> {
    private JMenu rootMenu;
    private JMenuItem trackerLocker;
    private JMenu serieSelecterMenu;
    private Map<SourceFunction, JMenuItem> serieSelectersMap;
    private List<JMenuItem> serieSelecters;
    private ImageIcon trackerrootIcon = SharedIcon.getCommon(Common.PEAK);
    private ImageIcon lockIcon = SharedIcon.getCommon(Common.LOCK);
    private ImageIcon unlockIcon = SharedIcon.getCommon(Common.UNLOCK);
    private ImageIcon checkIcon = SharedIcon.getCommon(Common.ITEM);
    private ContextSourceTrackerListener listener = new ContextSourceTrackerListener();

    public PeakTrackerDeviceContext() {
        this.serieSelecters = new ArrayList<JMenuItem>();
        this.serieSelectersMap = new HashMap<SourceFunction, JMenuItem>();
    }

    @Override
    public void buildContext() {
        if (this.getHost() == null) {
            return;
        }
        ((PeakTrackerPlugin)this.getHost()).removePeakTrackerListener(this.listener);
        ((PeakTrackerPlugin)this.getHost()).addPeakTrackerListener(this.listener);
        this.serieSelecters.clear();
        this.serieSelectersMap.clear();
        this.rootMenu = new JMenu("Peak Tracker");
        this.rootMenu.setIcon(this.trackerrootIcon);
        this.trackerLocker = new JMenuItem("Lock");
        this.rootMenu.add(this.trackerLocker);
        if (((PeakTrackerPlugin)this.getHost()).isLockSelected()) {
            this.trackerLocker.setIcon(this.lockIcon);
            this.trackerLocker.setText("unlock");
        } else {
            this.trackerLocker.setIcon(this.unlockIcon);
            this.trackerLocker.setText("lock");
        }
        this.trackerLocker.addActionListener(((PeakTrackerPlugin)this.getHost()).getPeakTrackerLockUnlockAction());
        ((PeakTrackerPlugin)this.getHost()).addPluginListener(new PluginListener(){

            public void pluginUnlockSelected(PluginEvent pluginEvent) {
                PeakTrackerDeviceContext.this.trackerLocker.setText("lock");
                PeakTrackerDeviceContext.this.trackerLocker.setIcon(PeakTrackerDeviceContext.this.unlockIcon);
            }

            public void pluginSelected(PluginEvent pluginEvent) {
                PeakTrackerDeviceContext.this.trackerLocker.setText("unlock");
                PeakTrackerDeviceContext.this.trackerLocker.setIcon(PeakTrackerDeviceContext.this.lockIcon);
            }
        });
        this.serieSelecterMenu = new JMenu("Series");
        List<SourceFunction> series = ((PeakTrackerPlugin)this.getHost()).getSources();
        int count = 1;
        for (final SourceFunction iSerie2D : series) {
            String name = iSerie2D.getName();
            if (name == null) {
                name = "serie-" + count;
                iSerie2D.setName(name);
            }
            JMenuItem serieSelecter = new JMenuItem(name);
            this.serieSelecterMenu.add(serieSelecter);
            this.serieSelectersMap.put(iSerie2D, serieSelecter);
            this.serieSelecters.add(serieSelecter);
            serieSelecter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((PeakTrackerPlugin)PeakTrackerDeviceContext.this.getHost()).isTracked(iSerie2D)) {
                        ((PeakTrackerPlugin)PeakTrackerDeviceContext.this.getHost()).untrackSource(iSerie2D);
                    } else {
                        ((PeakTrackerPlugin)PeakTrackerDeviceContext.this.getHost()).trackSource(iSerie2D);
                    }
                    ((PeakTrackerPlugin)PeakTrackerDeviceContext.this.getHost()).getProjection().getView().repaintDevice();
                }
            });
            ++count;
        }
        this.rootMenu.add(this.serieSelecterMenu);
        this.setGroup("Tracker");
        this.setItem(this.rootMenu);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof PeakTrackerPlugin;
    }

    class ContextSourceTrackerListener
    implements PeakTrackerListener {
        ContextSourceTrackerListener() {
        }

        @Override
        public void peakTracked(PeakTrackerEvent event) {
            JMenuItem item = (JMenuItem)PeakTrackerDeviceContext.this.serieSelectersMap.get(event.getSourceFunction());
            if (((PeakTrackerPlugin)PeakTrackerDeviceContext.this.getHost()).isTracked(event.getSourceFunction())) {
                item.setIcon(PeakTrackerDeviceContext.this.checkIcon);
            } else {
                item.setIcon(null);
            }
        }

        @Override
        public void sourceRegistered(PeakTrackerEvent event) {
        }
    }
}

