/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.tools.sourcetracker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.PluginListener;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.plugin.function.tools.sourcetracker.SourceTrackerEvent;
import org.jensoft.core.plugin.function.tools.sourcetracker.SourceTrackerListener;
import org.jensoft.core.plugin.function.tools.sourcetracker.SourceTrackerPlugin;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;

public class SourceTrackerDeviceContext
extends ContextEntry<SourceTrackerPlugin> {
    private JMenu rootMenu;
    private JMenuItem trackerLocker;
    private JMenu serieSelecterMenu;
    private Map<SourceFunction, JMenuItem> sourceSelectersMap;
    private List<JMenuItem> sourceSelecters;
    private ImageIcon trackerrootIcon = SharedIcon.getCommon(Common.TAG_LABEL);
    private ImageIcon lockIcon = SharedIcon.getCommon(Common.LOCK);
    private ImageIcon unlockIcon = SharedIcon.getCommon(Common.UNLOCK);
    private ContextSourceTrackerListener listener = new ContextSourceTrackerListener();

    public SourceTrackerDeviceContext() {
        this.sourceSelecters = new ArrayList<JMenuItem>();
        this.sourceSelectersMap = new HashMap<SourceFunction, JMenuItem>();
    }

    @Override
    public void buildContext() {
        if (this.getHost() == null) {
            return;
        }
        ((SourceTrackerPlugin)this.getHost()).removeSourceTrackerListener(this.listener);
        ((SourceTrackerPlugin)this.getHost()).addSourceTrackerListener(this.listener);
        this.sourceSelecters.clear();
        this.sourceSelectersMap.clear();
        this.rootMenu = new JMenu("Source Tracker");
        this.rootMenu.setIcon(this.trackerrootIcon);
        this.trackerLocker = new JMenuItem("Lock");
        this.rootMenu.add(this.trackerLocker);
        if (((SourceTrackerPlugin)this.getHost()).isLockSelected()) {
            this.trackerLocker.setIcon(this.lockIcon);
            this.trackerLocker.setText("unlock");
        } else {
            this.trackerLocker.setIcon(this.unlockIcon);
            this.trackerLocker.setText("lock");
        }
        this.trackerLocker.addActionListener(((SourceTrackerPlugin)this.getHost()).getSerieTrackerLockUnlockAction());
        ((SourceTrackerPlugin)this.getHost()).addPluginListener(new PluginListener(){

            public void pluginUnlockSelected(PluginEvent pluginEvent) {
                SourceTrackerDeviceContext.this.trackerLocker.setText("lock");
                SourceTrackerDeviceContext.this.trackerLocker.setIcon(SourceTrackerDeviceContext.this.unlockIcon);
            }

            public void pluginSelected(PluginEvent pluginEvent) {
                SourceTrackerDeviceContext.this.trackerLocker.setText("unlock");
                SourceTrackerDeviceContext.this.trackerLocker.setIcon(SourceTrackerDeviceContext.this.lockIcon);
            }
        });
        this.serieSelecterMenu = new JMenu("Sources");
        List<SourceFunction> sourceList = ((SourceTrackerPlugin)this.getHost()).getSources();
        int count = 1;
        for (final SourceFunction source : sourceList) {
            String name = source.getName();
            if (name == null) {
                name = "src-" + count;
                source.setName(name);
            }
            JMenuItem serieSelecter = new JMenuItem(name);
            this.serieSelecterMenu.add(serieSelecter);
            this.sourceSelectersMap.put(source, serieSelecter);
            this.sourceSelecters.add(serieSelecter);
            serieSelecter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((SourceTrackerPlugin)SourceTrackerDeviceContext.this.getHost()).trackSource(source);
                }
            });
            ++count;
            ((SourceTrackerPlugin)this.getHost()).trackSource(source);
        }
        this.rootMenu.add(this.serieSelecterMenu);
        this.setGroup("Tracker");
        this.setItem(this.rootMenu);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof SourceTrackerPlugin;
    }

    class ContextSourceTrackerListener
    implements SourceTrackerListener {
        ContextSourceTrackerListener() {
        }

        @Override
        public void sourceTracked(SourceTrackerEvent event) {
            for (JMenuItem item : SourceTrackerDeviceContext.this.sourceSelecters) {
                item.setIcon(SourceTrackerDeviceContext.this.unlockIcon);
            }
            JMenuItem item = (JMenuItem)SourceTrackerDeviceContext.this.sourceSelectersMap.get(event.getSourceFunction());
            item.setIcon(SourceTrackerDeviceContext.this.lockIcon);
        }

        @Override
        public void sourceRegistered(SourceTrackerEvent event) {
        }

        @Override
        public void currentTrack(SourceTrackerEvent event) {
        }
    }
}

