/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.tools.sourcetracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.GlyphMetricsNature;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricFill;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;
import org.jensoft.core.glyphmetrics.painter.fill.GlyphFill;
import org.jensoft.core.glyphmetrics.painter.marker.DefaultMarker;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.function.MetricsPathFunction;
import org.jensoft.core.plugin.function.source.FunctionNature;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.plugin.function.tools.sourcetracker.SourceTrackerEvent;
import org.jensoft.core.plugin.function.tools.sourcetracker.SourceTrackerListener;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class SourceTrackerPlugin
extends AbstractPlugin
implements AbstractPlugin.OnMoveListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnDragListener,
AbstractPlugin.OnReleaseListener {
    private SourceFunction trackedSource;
    private Point2D currentTrackDevice;
    private Point2D currentTrackUser;
    private MetricsPathFunction metricsPathFunction;
    private List<SourceFunction> sources;
    private EventListenerList trackerListenerList;
    private StylePosition defaultStylePosition = StylePosition.Default;
    private int divergence = 20;
    private GlyphMetricFill glyphMetricsFill = new GlyphFill(Spectral.SPECTRAL_RED, Color.DARK_GRAY);
    private GlyphMetricMarkerPainter glyphMarker = new DefaultMarker(NanoChromatique.RED);
    private Font defaultGlyphFont = new Font("Dialog", 0, 12);

    public SourceTrackerPlugin() {
        this.sources = new ArrayList<SourceFunction>();
        this.metricsPathFunction = new MetricsPathFunction();
        this.trackerListenerList = new EventListenerList();
        this.setOnMoveListener(this);
        this.setOnPressListener(this);
        this.setOnDragListener(this);
        this.setOnReleaseListener(this);
        this.setSelectable(true);
        this.setPriority(10000);
    }

    public void addSourceTrackerListener(SourceTrackerListener listener) {
        this.trackerListenerList.add(SourceTrackerListener.class, listener);
    }

    public void removeSourceTrackerListener(SourceTrackerListener listener) {
        this.trackerListenerList.remove(SourceTrackerListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSourceTracked() {
        Object[] listeners;
        Object[] objectArray = listeners = this.trackerListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != SourceTrackerListener.class) continue;
                ((SourceTrackerListener)listeners[i + 1]).sourceTracked(new SourceTrackerEvent(this.trackedSource));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSourceRegistered(SourceFunction source) {
        Object[] listeners;
        Object[] objectArray = listeners = this.trackerListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != SourceTrackerListener.class) continue;
                ((SourceTrackerListener)listeners[i + 1]).sourceRegistered(new SourceTrackerEvent(source));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCurrentTrack() {
        Object[] listeners;
        Object[] objectArray = listeners = this.trackerListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != SourceTrackerListener.class) continue;
                ((SourceTrackerListener)listeners[i + 1]).currentTrack(new SourceTrackerEvent(this.trackedSource));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public List<SourceFunction> getSources() {
        return this.sources;
    }

    public void setSources(List<SourceFunction> series) {
        this.sources = series;
    }

    public SourceFunction getTrackedSource() {
        return this.trackedSource;
    }

    public void registerSourceFunction(SourceFunction source) {
        if (!this.sources.contains(source)) {
            this.sources.add(source);
            this.fireSourceRegistered(source);
        }
    }

    public void trackSource(SourceFunction source) {
        this.registerSourceFunction(source);
        this.trackedSource = source;
        this.metricsPathFunction.setSource(this.trackedSource);
        this.metricsPathFunction.setSolveGeometryRequest(true);
        this.fireSourceTracked();
    }

    public SourceTrackerLockUnlockAction getSerieTrackerLockUnlockAction() {
        return new SourceTrackerLockUnlockAction();
    }

    private void addMetrics(GlyphMetric metric) {
        if (this.trackedSource == null) {
            return;
        }
        if (this.trackedSource.getNature() == FunctionNature.XFunction) {
            this.metricsPathFunction.addMetrics(metric);
        } else {
            this.metricsPathFunction.addMetrics(metric);
        }
    }

    public GlyphMetricFill getGlyphMetricsFill() {
        return this.glyphMetricsFill;
    }

    public void setGlyphMetricsFill(GlyphMetricFill glyphMetricsFill) {
        this.glyphMetricsFill = glyphMetricsFill;
    }

    public GlyphMetricMarkerPainter getGlyphMarker() {
        return this.glyphMarker;
    }

    public void setGlyphMarker(GlyphMetricMarkerPainter glyphMarker) {
        this.glyphMarker = glyphMarker;
    }

    private void clearMetrics() {
        this.metricsPathFunction.clearMetrics();
    }

    public Point2D getCurrentTrackDevice() {
        return this.currentTrackDevice;
    }

    public Point2D getCurrentTrackUser() {
        return this.currentTrackUser;
    }

    private void processMetrics(MouseEvent me) {
        this.metricsPathFunction.setSolveGeometryRequest(true);
        int currentX = me.getX();
        int currentY = me.getY();
        Projection w2d = this.getProjection();
        this.currentTrackDevice = new Point2D.Double(currentX, currentY);
        this.currentTrackUser = w2d.pixelToUser(this.currentTrackDevice);
        this.clearMetrics();
        GlyphMetric metric = null;
        if (this.trackedSource.getNature() == FunctionNature.XFunction) {
            Point2D result = this.trackedSource.evaluate(this.currentTrackUser.getX());
            if (result != null) {
                metric = new GlyphMetric();
                metric.setValue(this.currentTrackUser.getX());
                metric.setStylePosition(this.defaultStylePosition);
                metric.setMetricsNature(GlyphMetricsNature.Median);
                metric.setMetricsLabel(result.getY() + "");
                metric.setDivergence(this.divergence);
                metric.setGlyphMetricFill(this.glyphMetricsFill);
                metric.setGlyphMetricMarkerPainter(this.glyphMarker);
                metric.setFont(this.defaultGlyphFont);
            }
        } else {
            Point2D result = this.trackedSource.evaluate(this.currentTrackUser.getY());
            if (result != null) {
                metric = new GlyphMetric();
                metric.setValue(this.currentTrackUser.getY());
                metric.setStylePosition(this.defaultStylePosition);
                metric.setMetricsNature(GlyphMetricsNature.Median);
                metric.setMetricsLabel(result.getX() + "");
                metric.setDivergence(this.divergence);
                metric.setGlyphMetricFill(this.glyphMetricsFill);
                metric.setGlyphMetricMarkerPainter(this.glyphMarker);
                metric.setFont(this.defaultGlyphFont);
            }
        }
        try {
            if (metric != null) {
                this.addMetrics(metric);
                this.fireCurrentTrack();
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.getProjection().getDevice2D().repaintDevice();
    }

    @Override
    public void onDrag(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        this.processMetrics(me);
    }

    @Override
    public void onPress(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        this.processMetrics(me);
    }

    @Override
    public void onMove(MouseEvent me) {
    }

    @Override
    public void onRelease(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        this.clearMetrics();
        this.getProjection().getDevice2D().repaintDevice();
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        this.metricsPathFunction.setProjection(this.getProjection());
        this.metricsPathFunction.setFontRenderContext(g2d.getFontRenderContext());
        this.metricsPathFunction.setSolveGeometryRequest(true);
        List<GlyphMetric> metrics = this.metricsPathFunction.getMetrics();
        for (GlyphMetric glyphMetric : metrics) {
            if (glyphMetric.getGlyphMetricMarkerPainter() != null) {
                glyphMetric.getGlyphMetricMarkerPainter().paintGlyphMetric(g2d, glyphMetric);
            }
            if (glyphMetric.getGlyphMetricFill() != null) {
                glyphMetric.getGlyphMetricFill().paintGlyphMetric(g2d, glyphMetric);
            }
            if (glyphMetric.getGlyphMetricDraw() == null) continue;
            glyphMetric.getGlyphMetricDraw().paintGlyphMetric(g2d, glyphMetric);
        }
    }

    class SourceTrackerLockUnlockAction
    implements ActionListener {
        SourceTrackerLockUnlockAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SourceTrackerPlugin.this.isLockSelected()) {
                        SourceTrackerPlugin.this.unlockSelected();
                    } else {
                        SourceTrackerPlugin.this.lockSelected();
                    }
                }
            });
        }
    }
}

