/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge;

import java.awt.Graphics2D;
import org.jensoft.core.graphics.AlphaInterpolation;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.Fractional;
import org.jensoft.core.graphics.Interpolation;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.gauge.core.GaugeBackground;
import org.jensoft.core.plugin.gauge.core.GaugeBody;
import org.jensoft.core.plugin.gauge.core.GaugeGlass;
import org.jensoft.core.plugin.gauge.core.GaugePart;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.projection.ProjectionEvent;
import org.jensoft.core.projection.ProjectionListener;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class RadialGaugePlugin
extends AbstractPlugin {
    private RadialGauge gauge;

    public RadialGaugePlugin(RadialGauge gauge) {
        this.gauge = gauge;
        this.setInterpolation(Interpolation.Bicubic);
        this.setAlphaInterpolation(AlphaInterpolation.Quality);
        this.setAntialiasing(Antialiasing.On);
        this.setFractionalMetrics(Fractional.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setDithering(Dithering.On);
    }

    private void invalidateParts() {
        if (this.gauge.getEnvelop() != null) {
            this.gauge.getEnvelop().invalidate();
        }
        for (GaugeGlass glass : this.gauge.getGlasses()) {
            glass.invalidate();
        }
        for (GaugeBody body : this.gauge.getBodies()) {
            body.invalidate();
        }
        for (GaugeBackground background : this.gauge.getBackgrounds()) {
            background.invalidate();
        }
    }

    @Override
    public void onProjectionRegister() {
        super.onProjectionRegister();
        this.getProjection().addProjectionListener(new ProjectionListener(){

            @Override
            public void projectionUnlockActive(ProjectionEvent w2dEvent) {
            }

            @Override
            public void projectionResized(ProjectionEvent w2dEvent) {
                RadialGaugePlugin.this.invalidateParts();
            }

            @Override
            public void projectionLockActive(ProjectionEvent w2dEvent) {
            }

            @Override
            public void projectionBoundChanged(ProjectionEvent w2dEvent) {
                RadialGaugePlugin.this.invalidateParts();
            }
        });
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        this.gauge.setProjection(this.getProjection());
        this.gauge.setHost(this);
        if (this.gauge.getEnvelop() != null) {
            this.gauge.getEnvelop().paintPart(g2d, this.gauge);
        }
        if (this.gauge.getBackgrounds() != null) {
            for (GaugePart gaugePart : this.gauge.getBackgrounds()) {
                gaugePart.paintPart(g2d, this.gauge);
            }
        }
        if (this.gauge.getGlasses() != null) {
            for (GaugePart gaugePart : this.gauge.getGlasses()) {
                gaugePart.paintPart(g2d, this.gauge);
            }
        }
        if (this.gauge.getBodies() != null) {
            for (GaugePart gaugePart : this.gauge.getBodies()) {
                gaugePart.paintPart(g2d, this.gauge);
            }
        }
    }
}

