/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.compass;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.gauge.core.GaugeBackground;
import org.jensoft.core.plugin.gauge.core.RadialGauge;

public class GaugeCompassBackground
extends GaugeBackground {
    private int centerX;
    private int centerY;
    private Paint paint = new Color(0, 0, 0, 40);
    private Color outlineColor = Color.WHITE;
    private Shape baseShape;
    private Shape internalShape;
    private Shape externalShape;
    private double baseRadius = 80.0;
    private double deltaMajorBaseRadius = 35.0;
    private double deltaMedianBaseRadius = 20.0;
    private double deltaMinorBaseRadius = 10.0;
    private double deltaMiliBaseRadius = 1.0;
    private Vector<CompassCapTicker> caps = new Vector();
    int delta1 = 40;

    public GaugeCompassBackground(int centerX, int centerY, int baseRadius) {
        CompassCapTicker needlenorth;
        int i;
        this.centerX = centerX;
        this.centerY = centerY;
        this.baseRadius = baseRadius;
        for (i = 0; i <= 360; i += 30) {
            needlenorth = new CompassCapTicker(i);
            needlenorth.setNature(CompassCapTicker.MAJOR);
            this.addNeedle(needlenorth);
        }
        for (i = 0; i <= 360; i += 10) {
            needlenorth = new CompassCapTicker(i);
            needlenorth.setNature(CompassCapTicker.MEDIAN);
            this.addNeedle(needlenorth);
        }
        for (i = 0; i <= 360; i += 5) {
            needlenorth = new CompassCapTicker(i);
            needlenorth.setNature(CompassCapTicker.MINOR);
            this.addNeedle(needlenorth);
        }
        for (double i2 = 0.0; i2 <= 360.0; i2 += 2.5) {
            CompassCapTicker needlenorth2 = new CompassCapTicker(i2);
            needlenorth2.setNature(CompassCapTicker.MILI);
            this.addNeedle(needlenorth2);
        }
    }

    public void addNeedle(CompassCapTicker needle) {
        if (!this.isAlreadyRegister(needle)) {
            this.caps.add(needle);
        }
    }

    private boolean isAlreadyRegister(CompassCapTicker cap) {
        for (CompassCapTicker n : this.caps) {
            if (n.getTheta() != cap.getTheta()) continue;
            return true;
        }
        return false;
    }

    public CompassCapTicker getNeedle(int index) {
        return this.caps.get(index);
    }

    public void builCompass() {
        Ellipse2D.Double ellipseArea1 = new Ellipse2D.Double((double)this.centerX - this.baseRadius, (double)this.centerY - this.baseRadius, 2.0 * this.baseRadius, 2.0 * this.baseRadius);
        Ellipse2D.Double ellipseArea2 = new Ellipse2D.Double((double)this.centerX - this.baseRadius - this.deltaMajorBaseRadius, (double)this.centerY - this.baseRadius - this.deltaMajorBaseRadius, 2.0 * (this.baseRadius + this.deltaMajorBaseRadius), 2.0 * (this.baseRadius + this.deltaMajorBaseRadius));
        Area area1 = new Area(ellipseArea1);
        this.internalShape = area1;
        Area area2 = new Area(ellipseArea2);
        this.externalShape = area2;
        area2.subtract(area1);
        this.baseShape = area2;
        this.buildNeedles();
    }

    public int countNeedle() {
        return this.caps.size();
    }

    private void buildNeedles() {
        for (int i = 0; i < this.caps.size(); ++i) {
            CompassCapTicker n = this.caps.get(i);
            double cornerExternalX = (double)this.centerX - (this.baseRadius + this.deltaMajorBaseRadius + (double)this.delta1);
            double cornerExternalY = (double)this.centerY - (this.baseRadius + this.deltaMajorBaseRadius + (double)this.delta1);
            Arc2D.Double needleArc = new Arc2D.Double(cornerExternalX, cornerExternalY, 2.0 * (this.baseRadius + this.deltaMajorBaseRadius + (double)this.delta1), 2.0 * (this.baseRadius + this.deltaMajorBaseRadius + (double)this.delta1), n.getTheta() + (double)n.getAlphaProjection(), -2 * n.getAlphaProjection(), 0);
            n.setNeedleArc(needleArc);
            double Xbase = (double)this.centerX + new Double(this.baseRadius) * Math.cos(Math.toRadians(n.getTheta()));
            double Ybase = (double)this.centerY - new Double(this.baseRadius) * Math.sin(Math.toRadians(n.getTheta()));
            n.setRefPoint(new Point2D.Double(Xbase, Ybase));
            double deltaRadius = 0.0;
            if (n.getNature() == CompassCapTicker.MAJOR) {
                deltaRadius = this.deltaMajorBaseRadius;
            }
            if (n.getNature() == CompassCapTicker.MEDIAN) {
                deltaRadius = this.deltaMedianBaseRadius;
            }
            if (n.getNature() == CompassCapTicker.MINOR) {
                deltaRadius = this.deltaMinorBaseRadius;
            }
            if (n.getNature() == CompassCapTicker.MILI) {
                deltaRadius = this.deltaMiliBaseRadius;
            }
            double XDelta = (double)this.centerX + new Double(this.baseRadius + deltaRadius) * Math.cos(Math.toRadians(n.getTheta()));
            double YDelta = (double)this.centerY - new Double(this.baseRadius + deltaRadius) * Math.sin(Math.toRadians(n.getTheta()));
            Line2D.Double l = new Line2D.Double(Xbase, Ybase, XDelta, YDelta);
            n.setNeedlePath(l);
            Line2D.Double lBaseLine = new Line2D.Double(Xbase, Ybase, this.centerX, this.centerY);
            n.setBaseLine(lBaseLine);
        }
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public Shape getInternalShape() {
        return this.internalShape;
    }

    public Shape getExternalShape() {
        return this.externalShape;
    }

    public Shape getBaseShape() {
        return this.baseShape;
    }

    public void setBaseShape(Shape baseShape) {
        this.baseShape = baseShape;
    }

    public Vector<CompassCapTicker> getNeedles() {
        return this.caps;
    }

    public void setNeedles(Vector<CompassCapTicker> needles) {
        this.caps = needles;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public double getBaseRadius() {
        return this.baseRadius;
    }

    public void setBaseRadius(double baseRadius) {
        this.baseRadius = baseRadius;
    }

    @Override
    public void paintBackground(Graphics2D g2d, RadialGauge radialGauge) {
        double centerX = radialGauge.getCenterDevice().getX();
        double centerY = radialGauge.getCenterDevice().getY();
        int radius = radialGauge.getRadius() - 10;
        this.setCenterX((int)centerX);
        this.setCenterY((int)centerY);
        this.setBaseRadius(radius - 30);
        this.builCompass();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Vector<CompassCapTicker> needles = this.getNeedles();
        g2d.setColor(radialGauge.getProjection().getThemeColor().darker());
        g2d.setStroke(new BasicStroke(1.0f));
        Color blue = new Color(68, 155, 180);
        for (CompassCapTicker n : needles) {
            Line2D needlePath = n.getNeedlePath();
            if (n.getNature() == CompassCapTicker.MAJOR) {
                g2d.setStroke(new BasicStroke(1.5f, 0, 1));
                g2d.setColor(blue);
            }
            if (n.getNature() == CompassCapTicker.MEDIAN) {
                g2d.setStroke(new BasicStroke(1.5f, 0, 1));
                g2d.setColor(ColorPalette.brighter(TangoPalette.CHAMELEON1, 0.8f));
            }
            if (n.getNature() == CompassCapTicker.MINOR) {
                g2d.setStroke(new BasicStroke(1.0f, 0, 1));
                g2d.setColor(TangoPalette.CHAMELEON3);
            }
            if (n.getNature() == CompassCapTicker.MILI) {
                g2d.setColor(TangoPalette.CHAMELEON3);
                g2d.setStroke(new BasicStroke(2.0f, 0, 2));
            }
            g2d.draw(needlePath);
        }
    }

    public static class CompassCapTicker {
        private String name;
        private double theta = 0.0;
        private Paint paint = new Color(0, 0, 0, 150);
        private Color colorTheme = Color.WHITE;
        private int alphaProjection = 20;
        private boolean lockNeedle = false;
        private boolean lockRollover = false;
        private boolean lockPressed = false;
        private Arc2D needleArc;
        private Line2D needlePath;
        private Line2D baseLine;
        private Point2D refPoint;
        public static int MAJOR = 0;
        public static int MEDIAN = 1;
        public static int MINOR = 2;
        public static int MILI = 3;
        private int nature = MAJOR;

        public CompassCapTicker() {
        }

        public Point2D getRefPoint() {
            return this.refPoint;
        }

        public void setRefPoint(Point2D refPoint) {
            this.refPoint = refPoint;
        }

        public int getAlphaProjection() {
            return this.alphaProjection;
        }

        public void setAlphaProjection(int alphaProjection) {
            this.alphaProjection = alphaProjection;
        }

        public Arc2D getNeedleArc() {
            return this.needleArc;
        }

        public void setNeedleArc(Arc2D needleArc) {
            this.needleArc = needleArc;
        }

        public int getNature() {
            return this.nature;
        }

        public void setNature(int nature) {
            this.nature = nature;
        }

        public Line2D getBaseLine() {
            return this.baseLine;
        }

        public void setBaseLine(Line2D baseLine) {
            this.baseLine = baseLine;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean contains(Point2D p2d) {
            return this.needlePath.contains(p2d);
        }

        public CompassCapTicker(double theta) {
            this.theta = theta;
        }

        public CompassCapTicker(int alphaProjection, double theta) {
            this.alphaProjection = alphaProjection;
            this.theta = theta;
        }

        public double getTheta() {
            return this.theta;
        }

        public void setTheta(double theta) {
            this.theta = theta;
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public Color getColorTheme() {
            return this.colorTheme;
        }

        public void setColorTheme(Color colorTheme) {
            this.colorTheme = colorTheme;
        }

        public Line2D getNeedlePath() {
            return this.needlePath;
        }

        public void setNeedlePath(Line2D needlePath) {
            this.needlePath = needlePath;
        }

        public void lockNeedle() {
            this.lockNeedle = true;
        }

        public void unlockNeedle() {
            this.lockNeedle = false;
        }

        public boolean isLockNeedle() {
            return this.lockNeedle;
        }

        public void lockRollover() {
            this.lockRollover = true;
        }

        public void unlockRollover() {
            this.lockRollover = false;
        }

        public boolean isLockRollover() {
            return this.lockRollover;
        }

        public void lockPressed() {
            this.lockPressed = true;
        }

        public void unlockPressed() {
            this.lockPressed = false;
        }

        public boolean isLockPressed() {
            return this.lockPressed;
        }
    }
}

