/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.gauge.core.GaugeMetricsPath;
import org.jensoft.core.plugin.gauge.core.GaugePart;
import org.jensoft.core.plugin.gauge.core.GaugePartBuffer;
import org.jensoft.core.plugin.gauge.core.GaugeTextPath;
import org.jensoft.core.plugin.gauge.core.RadialGauge;

public class GaugeBody
extends GaugePart {
    private List<GaugeMetricsPath> gaugeMetricsPaths = new ArrayList<GaugeMetricsPath>();
    private List<GaugeTextPath> gaugeTextPaths = new ArrayList<GaugeTextPath>();

    public void registerGaugeMetricsPath(GaugeMetricsPath pathMetrics) {
        pathMetrics.setBody(this);
        this.gaugeMetricsPaths.add(pathMetrics);
    }

    public List<GaugeMetricsPath> getMetricsPaths() {
        return this.gaugeMetricsPaths;
    }

    public void setGaugeMetricsPath(List<GaugeMetricsPath> gaugePathMetrics) {
        for (GaugeMetricsPath path : gaugePathMetrics) {
            this.registerGaugeMetricsPath(path);
        }
    }

    public void registerGaugeTextPath(GaugeTextPath textPath) {
        textPath.setBody(this);
        this.gaugeTextPaths.add(textPath);
    }

    public List<GaugeTextPath> getTextPaths() {
        return this.gaugeTextPaths;
    }

    public void setGaugeTextPaths(List<GaugeTextPath> gaugeTextPaths) {
        for (GaugeTextPath path : gaugeTextPaths) {
            this.registerGaugeTextPath(path);
        }
    }

    private void paintPart(Graphics2D g2d, GaugePartBuffer buffer) {
        if (buffer != null && buffer.getBuffer() != null) {
            g2d.drawImage(buffer.getBuffer(), (int)buffer.getX(), (int)buffer.getY(), (int)buffer.getWidth(), (int)buffer.getHeight(), null);
        }
    }

    @Override
    public void invalidate() {
        this.setPartBuffer(null);
        for (GaugeMetricsPath gaugeMetricsPath : this.getMetricsPaths()) {
            gaugeMetricsPath.setPartBuffer(null);
        }
        for (GaugeTextPath gaugeTextPath : this.getTextPaths()) {
            gaugeTextPath.setPartBuffer(null);
        }
    }

    @Override
    public final void paintPart(Graphics2D g2d, RadialGauge radialGauge) {
        for (GaugeMetricsPath gaugeMetricsPath : this.getMetricsPaths()) {
            if (gaugeMetricsPath.getPartBuffer() == null) {
                gaugeMetricsPath.setProjection(this.getGauge().getProjection());
                gaugeMetricsPath.resetPath();
                Shape s = gaugeMetricsPath.getPathBinder().bindPath(radialGauge);
                if (s != null) {
                    gaugeMetricsPath.append(gaugeMetricsPath.getPathBinder().bindPath(radialGauge));
                    gaugeMetricsPath.createPartBuffer(g2d);
                }
            }
            this.paintPart(g2d, gaugeMetricsPath.getPartBuffer());
            if (!gaugeMetricsPath.getPathBinder().isDebug()) continue;
            gaugeMetricsPath.getPathBinder().debug(g2d, radialGauge);
        }
        for (GaugeTextPath gaugeTextPath : this.getTextPaths()) {
            if (gaugeTextPath.getPartBuffer() == null) {
                gaugeTextPath.setPath(gaugeTextPath.getPathBinder().bindPath(radialGauge));
                gaugeTextPath.createPartBuffer(g2d);
            }
            this.paintPart(g2d, gaugeTextPath.getPartBuffer());
        }
        for (GaugeMetricsPath gaugeMetricsPath : this.getMetricsPaths()) {
            if (gaugeMetricsPath.getGaugeNeedlePainter() == null) continue;
            gaugeMetricsPath.getGaugeNeedlePainter().paintNeedle(g2d, gaugeMetricsPath);
        }
    }
}

