/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.jensoft.core.device.PartBuffer;
import org.jensoft.core.drawable.screw.Posidrive;
import org.jensoft.core.drawable.screw.Split;
import org.jensoft.core.drawable.screw.Torx;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.GaugePart;
import org.jensoft.core.plugin.gauge.core.GaugePartBuffer;
import org.jensoft.core.plugin.gauge.core.RadialGauge;

public abstract class GaugeEnvelope
extends GaugePart {
    @Override
    public void invalidate() {
        this.setPartBuffer(null);
    }

    protected abstract void paintEnvelope(Graphics2D var1, RadialGauge var2);

    @Override
    public final void paintPart(Graphics2D g2d, RadialGauge radialGauge) {
        this.paintEnvelope(g2d, radialGauge);
    }

    public static class Cisero
    extends GaugeEnvelope {
        private double extendsRatio = 3.0;
        private double alpha = 10.0;

        public Cisero() {
        }

        public Cisero(double extendsRatio) {
            this.extendsRatio = extendsRatio;
        }

        public double getExtendsRatio() {
            return this.extendsRatio;
        }

        public void setExtendsRatio(double extendsRatio) {
            this.extendsRatio = extendsRatio;
        }

        public double getAlpha() {
            return this.alpha;
        }

        public void setAlpha(double alpha) {
            this.alpha = alpha;
        }

        private Shape createFragment(double theta, double alpha, double internalRadius, double externalRadius, RadialGauge radialGauge) {
            GeneralPath path = new GeneralPath();
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            int radius = radialGauge.getRadius();
            Point2D.Double p1 = new Point2D.Double(centerX + internalRadius * Math.cos(Math.toRadians(theta - alpha - alpha / 2.0)), centerY - internalRadius * Math.sin(Math.toRadians(theta - alpha - alpha / 2.0)));
            Point2D.Double p2 = new Point2D.Double(centerX + externalRadius * Math.cos(Math.toRadians(theta - alpha / 2.0)), centerY - externalRadius * Math.sin(Math.toRadians(theta - alpha / 2.0)));
            Point2D.Double p3 = new Point2D.Double(centerX + externalRadius * Math.cos(Math.toRadians(theta + alpha / 2.0)), centerY - externalRadius * Math.sin(Math.toRadians(theta + alpha / 2.0)));
            Point2D.Double p4 = new Point2D.Double(centerX + internalRadius * Math.cos(Math.toRadians(theta + alpha + alpha / 2.0)), centerY - internalRadius * Math.sin(Math.toRadians(theta + alpha + alpha / 2.0)));
            Point2D.Double pc1 = new Point2D.Double(centerX + internalRadius * Math.cos(Math.toRadians(theta - alpha)), centerY - internalRadius * Math.sin(Math.toRadians(theta - alpha)));
            Point2D.Double pc2 = new Point2D.Double(centerX + externalRadius * Math.cos(Math.toRadians(theta - alpha)), centerY - externalRadius * Math.sin(Math.toRadians(theta - alpha)));
            Point2D.Double pc3 = new Point2D.Double(centerX + externalRadius * Math.cos(Math.toRadians(theta + alpha)), centerY - externalRadius * Math.sin(Math.toRadians(theta + alpha)));
            Point2D.Double pc4 = new Point2D.Double(centerX + internalRadius * Math.cos(Math.toRadians(theta + alpha)), centerY - internalRadius * Math.sin(Math.toRadians(theta + alpha)));
            path.moveTo(((Point2D)p1).getX(), ((Point2D)p1).getY());
            path.curveTo(((Point2D)pc1).getX(), ((Point2D)pc1).getY(), ((Point2D)pc2).getX(), ((Point2D)pc2).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY());
            Arc2D.Double arc1 = new Arc2D.Double(centerX - externalRadius, centerY - externalRadius, 2.0 * externalRadius, 2.0 * externalRadius, theta - alpha / 2.0, alpha, 0);
            path.append(arc1, true);
            path.curveTo(((Point2D)pc3).getX(), ((Point2D)pc3).getY(), ((Point2D)pc4).getX(), ((Point2D)pc4).getY(), ((Point2D)p4).getX(), ((Point2D)p4).getY());
            return path;
        }

        private Shape createArcFragment(double theta1, double theta2, double alpha, double internalRadius, double externalRadius, RadialGauge radialGauge) {
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            Arc2D.Double a = new Arc2D.Double(centerX - internalRadius, centerY - internalRadius, 2.0 * internalRadius, 2.0 * internalRadius, theta1 + alpha + alpha / 2.0, theta2 - theta1 - 3.0 * alpha, 0);
            return a;
        }

        @Override
        public void paintEnvelope(Graphics2D g2d, RadialGauge radialGauge) {
            GaugePartBuffer part = this.getPartBuffer();
            if (part == null) {
                double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
                double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
                int deltaExternal = (int)((double)radialGauge.getRadius() / this.extendsRatio);
                int radiusExternal = radialGauge.getRadius() + deltaExternal;
                part = new GaugePartBuffer(radialGauge);
                this.setPartBuffer(part);
                Graphics2D g2dPart = part.getGraphics();
                g2dPart.setRenderingHints(g2d.getRenderingHints());
                Ellipse2D.Double eExternal = new Ellipse2D.Double(centerX - (double)radiusExternal, centerY - (double)radiusExternal, 2 * radiusExternal, 2 * radiusExternal);
                Point2D.Double start = new Point2D.Double(centerX, centerY - (double)radiusExternal);
                Point2D.Double end = new Point2D.Double(centerX, centerY + (double)radiusExternal);
                float[] dist = new float[]{0.0f, 0.5f, 1.0f};
                Color[] colors = new Color[]{Color.DARK_GRAY, Color.LIGHT_GRAY, Color.BLACK};
                LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
                g2dPart.setPaint(p);
                g2dPart.fill(eExternal);
                int epsilonPixel = 2;
                int baseRadius = radialGauge.getRadius() + deltaExternal / 2;
                int extendsRadius = radialGauge.getRadius() + deltaExternal - epsilonPixel;
                Shape s0 = this.createFragment(30.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape s1 = this.createFragment(90.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape s2 = this.createFragment(150.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape s3 = this.createFragment(210.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape s4 = this.createFragment(270.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape s5 = this.createFragment(330.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape a0 = this.createArcFragment(-30.0, 30.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape a1 = this.createArcFragment(30.0, 90.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape a2 = this.createArcFragment(90.0, 150.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape a3 = this.createArcFragment(150.0, 210.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape a4 = this.createArcFragment(210.0, 270.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                Shape a5 = this.createArcFragment(270.0, 330.0, this.alpha, baseRadius, extendsRadius, radialGauge);
                GeneralPath path1 = new GeneralPath();
                path1.append(s0, false);
                path1.append(a1, true);
                path1.append(s1, true);
                path1.append(a2, true);
                path1.append(s2, true);
                path1.append(a3, true);
                path1.append(s3, true);
                path1.append(a4, true);
                path1.append(s4, true);
                path1.append(a5, true);
                path1.append(s5, true);
                path1.append(a0, true);
                g2dPart.setColor(Color.WHITE);
                path1.closePath();
                Area area1 = new Area(path1);
                int radiusBase = radialGauge.getRadius() + epsilonPixel;
                Area area2 = new Area(new Ellipse2D.Double(centerX - (double)radiusBase, centerY - (double)radiusBase, 2 * radiusBase, 2 * radiusBase));
                area1.subtract(area2);
                Point2D.Double center = new Point2D.Double(centerX, centerY);
                float radiusGradient = extendsRadius;
                float[] dist3 = new float[]{0.0f, 1.0f};
                Color[] colors3 = new Color[]{Color.GRAY, Color.DARK_GRAY};
                RadialGradientPaint p3 = new RadialGradientPaint(center, radiusGradient, dist3, colors3);
                Point2D.Double start4 = new Point2D.Double(centerX, centerY - (double)extendsRadius);
                Point2D.Double end4 = new Point2D.Double(centerX, centerY + (double)extendsRadius);
                float[] dist4 = new float[]{0.0f, 0.5f, 1.0f};
                Color[] colors4 = new Color[]{Color.BLACK, Color.GRAY, Color.BLACK};
                LinearGradientPaint p4 = new LinearGradientPaint(start4, end4, dist4, colors4);
                g2dPart.setPaint(p4);
                g2dPart.fill(area1);
                g2dPart.setStroke(new BasicStroke(1.0f));
                g2dPart.setColor(NanoChromatique.GREEN);
                PartBuffer envelopPart2 = new PartBuffer(centerX - (double)radiusExternal, centerY - (double)radiusExternal, 2 * radiusExternal, 2 * radiusExternal);
                Graphics2D g2dPart2 = envelopPart2.getBuffer().createGraphics();
                g2dPart2.setRenderingHints(g2d.getRenderingHints());
                g2dPart2.translate(-centerX + (double)radiusExternal, -centerY + (double)radiusExternal);
                g2dPart2.setStroke(new BasicStroke(1.2f));
                g2dPart.setColor(NanoChromatique.BLACK);
                g2dPart.draw(path1);
                float[] blur = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
                float[] sharpen = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f};
                Kernel kernel = new Kernel(3, 3, blur);
                ConvolveOp op = new ConvolveOp(kernel, 1, null);
                BufferedImage imgBlurr = op.filter(envelopPart2.getBuffer(), null);
                double splitRadius = (new Double(deltaExternal) - 2.0 * new Double(epsilonPixel)) / 2.8;
                double x = centerX + (double)baseRadius * Math.cos(Math.toRadians(90.0));
                double y = centerY - (double)baseRadius * Math.sin(Math.toRadians(90.0));
                Split s = new Split(x, y, splitRadius, 90.0);
                s.draw(g2dPart);
                x = centerX + (double)baseRadius * Math.cos(Math.toRadians(30.0));
                y = centerY - (double)baseRadius * Math.sin(Math.toRadians(30.0));
                s = new Split(x, y, splitRadius, 30.0);
                s.draw(g2dPart);
                x = centerX + (double)baseRadius * Math.cos(Math.toRadians(150.0));
                y = centerY - (double)baseRadius * Math.sin(Math.toRadians(150.0));
                s = new Split(x, y, splitRadius, 150.0);
                s.draw(g2dPart);
                x = centerX + (double)baseRadius * Math.cos(Math.toRadians(210.0));
                y = centerY - (double)baseRadius * Math.sin(Math.toRadians(210.0));
                s = new Split(x, y, splitRadius, 210.0);
                s.draw(g2dPart);
                x = centerX + (double)baseRadius * Math.cos(Math.toRadians(330.0));
                y = centerY - (double)baseRadius * Math.sin(Math.toRadians(330.0));
                s = new Split(x, y, splitRadius, 330.0);
                s.draw(g2dPart);
                x = centerX + (double)baseRadius * Math.cos(Math.toRadians(270.0));
                y = centerY - (double)baseRadius * Math.sin(Math.toRadians(270.0));
                s = new Split(x, y, splitRadius, 270.0);
                s.draw(g2dPart);
                g2dPart.dispose();
            }
            g2d.drawImage(part.getBuffer(), (int)part.getX(), (int)part.getY(), (int)part.getWidth(), (int)part.getHeight(), null);
        }
    }

    public static class Classic
    extends GaugeEnvelope {
        @Override
        public void paintEnvelope(Graphics2D g2d, RadialGauge radialGauge) {
            int radiusExternal;
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            int radius = radialGauge.getRadius();
            int deltaInternal = 4;
            int deltaExternal = 40;
            int radiusInternal = radius + deltaInternal;
            radius = radiusExternal = radius + deltaExternal;
            if (this.getPartBuffer() == null) {
                GaugePartBuffer envelopPart = new GaugePartBuffer(radialGauge);
                this.setPartBuffer(new GaugePartBuffer(radialGauge));
                Graphics2D g2dPart = envelopPart.getGraphics();
                g2dPart.setRenderingHints(g2d.getRenderingHints());
                Ellipse2D.Double eInternal = new Ellipse2D.Double(centerX - (double)radiusInternal, centerY - (double)radiusInternal, 2 * radiusInternal, 2 * radiusInternal);
                Ellipse2D.Double eExternal = new Ellipse2D.Double(centerX - (double)radiusExternal, centerY - (double)radiusExternal, 2 * radiusExternal, 2 * radiusExternal);
                Point2D.Double start = new Point2D.Double(centerX, centerY - (double)radius);
                Point2D.Double end = new Point2D.Double(centerX, centerY + (double)radius);
                float[] dist = new float[]{0.0f, 0.5f, 1.0f};
                Color[] colors = new Color[]{Color.DARK_GRAY, Color.LIGHT_GRAY, Color.BLACK};
                LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
                g2dPart.setPaint(p);
                g2dPart.fill(eExternal);
                Point2D.Double start2 = new Point2D.Double(centerX, centerY - (double)radius);
                Point2D.Double end2 = new Point2D.Double(centerX, centerY + (double)radius);
                float[] dist2 = new float[]{0.0f, 1.0f};
                Color[] colors2 = new Color[]{Color.BLACK, Color.WHITE};
                LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, dist2, colors2);
                g2dPart.setPaint(p2);
                g2dPart.fill(eInternal);
                int deltaInternal2 = 0;
                int deltaExternal2 = 4;
                int radiusInternal2 = radiusInternal + deltaInternal2;
                int radiusExternal2 = radiusExternal - deltaExternal2;
                Ellipse2D.Double eInternal2 = new Ellipse2D.Double(centerX - (double)radiusInternal2, centerY - (double)radiusInternal2, 2 * radiusInternal2, 2 * radiusInternal2);
                Ellipse2D.Double eExternal2 = new Ellipse2D.Double(centerX - (double)radiusExternal2, centerY - (double)radiusExternal2, 2 * radiusExternal2, 2 * radiusExternal2);
                Area aI = new Area(eInternal2);
                Area aE = new Area(eExternal2);
                aE.subtract(aI);
                g2dPart.setColor(Color.RED);
                double p1IX = centerX + (double)radiusInternal2 * Math.cos(Math.toRadians(-10.0));
                double p1IY = centerY - (double)radiusInternal2 * Math.sin(Math.toRadians(-10.0));
                double p1EX = centerX + (double)radiusExternal2 * Math.cos(Math.toRadians(-10.0));
                double p1EY = centerY - (double)radiusExternal2 * Math.sin(Math.toRadians(-10.0));
                double p2IX = centerX + (double)radiusInternal2 * Math.cos(Math.toRadians(190.0));
                double p2IY = centerY - (double)radiusInternal2 * Math.sin(Math.toRadians(190.0));
                double p2EX = centerX + (double)radiusExternal2 * Math.cos(Math.toRadians(190.0));
                double p2EY = centerY - (double)radiusExternal2 * Math.sin(Math.toRadians(190.0));
                Arc2D.Double a1 = new Arc2D.Double(centerX - (double)radiusInternal2, centerY - (double)radiusInternal2, 2 * radiusInternal2, 2 * radiusInternal2, -10.0, 200.0, 0);
                Arc2D.Double a2 = new Arc2D.Double(centerX - (double)radiusExternal2, centerY - (double)radiusExternal2, 2 * radiusExternal2, 2 * radiusExternal2, 190.0, -200.0, 0);
                GeneralPath path = new GeneralPath();
                path.append(a1, false);
                path.lineTo(p2IX, p2IY);
                path.append(a2, true);
                path.closePath();
                Point2D.Double start3 = new Point2D.Double(centerX, centerY - (double)radiusExternal2);
                Point2D.Double end3 = new Point2D.Double(centerX, centerY + (double)radiusExternal2);
                float[] dist3 = new float[]{0.0f, 1.0f};
                Color[] colors3 = new Color[]{Color.WHITE, Color.BLACK.brighter()};
                LinearGradientPaint p3 = new LinearGradientPaint(start3, end3, dist3, colors3);
                g2dPart.setPaint(p3);
                g2dPart.fill(aE);
                Point2D.Double start4 = new Point2D.Double(centerX, centerY - (double)radiusExternal2);
                Point2D.Double end4 = new Point2D.Double(centerX, centerY);
                float[] dist4 = new float[]{0.0f, 1.0f};
                Color[] colors4 = new Color[]{Color.LIGHT_GRAY, Color.DARK_GRAY};
                LinearGradientPaint p4 = new LinearGradientPaint(start4, end4, dist4, colors4);
                g2dPart.setPaint(p4);
                g2dPart.fill(path);
                int deltaRadius = radiusExternal2 - radiusInternal2;
                double starPositionRadius = radiusInternal2 + deltaRadius / 2;
                g2dPart.setPaint(null);
                double pxstar1 = centerX + starPositionRadius * Math.cos(Math.toRadians(90.0));
                double pystar1 = centerY - starPositionRadius * Math.sin(Math.toRadians(90.0));
                Torx t1 = new Torx(pxstar1, pystar1, 12.0);
                t1.draw(g2dPart);
                double pxstar2 = centerX + starPositionRadius * Math.cos(Math.toRadians(225.0));
                double pystar2 = centerY - starPositionRadius * Math.sin(Math.toRadians(225.0));
                Torx t2 = new Torx(pxstar2, pystar2, 12.0);
                t2.draw(g2dPart);
                double pxstar3 = centerX + starPositionRadius * Math.cos(Math.toRadians(-45.0));
                double pystar3 = centerY - starPositionRadius * Math.sin(Math.toRadians(-45.0));
                Torx t3 = new Torx(pxstar3, pystar3, 12.0);
                t3.draw(g2dPart);
                double pxstar4 = centerX + starPositionRadius * Math.cos(Math.toRadians(45.0));
                double pystar4 = centerY - starPositionRadius * Math.sin(Math.toRadians(45.0));
                Torx c4 = new Torx(pxstar4, pystar4, 12.0);
                c4.draw(g2dPart);
                double pxstar5 = centerX + starPositionRadius * Math.cos(Math.toRadians(135.0));
                double pystar5 = centerY - starPositionRadius * Math.sin(Math.toRadians(135.0));
                Torx f5 = new Torx(pxstar5, pystar5, 12.0);
                f5.draw(g2dPart);
                double pxstar6 = centerX + starPositionRadius * Math.cos(Math.toRadians(270.0));
                double pystar6 = centerY - starPositionRadius * Math.sin(Math.toRadians(270.0));
                Torx b6 = new Torx(pxstar6, pystar6, 12.0);
                b6.draw(g2dPart);
                double pxstar7 = centerX + starPositionRadius * Math.cos(Math.toRadians(0.0));
                double pystar7 = centerY - starPositionRadius * Math.sin(Math.toRadians(0.0));
                Posidrive b7 = new Posidrive(pxstar7, pystar7, 12.0);
                b7.draw(g2dPart);
                double pxstar8 = centerX + starPositionRadius * Math.cos(Math.toRadians(180.0));
                double pystar8 = centerY - starPositionRadius * Math.sin(Math.toRadians(180.0));
                Torx b8 = new Torx(pxstar8, pystar8, 12.0);
                b8.draw(g2dPart);
            }
            g2d.drawImage(this.getPartBuffer().getBuffer(), (int)this.getPartBuffer().getX(), (int)this.getPartBuffer().getY(), (int)this.getPartBuffer().getWidth(), (int)this.getPartBuffer().getHeight(), null);
        }
    }
}

