/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core;

import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.AbstractMetricsPath;
import org.jensoft.core.glyphmetrics.GeneralMetricsPath;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.plugin.gauge.core.GaugeBody;
import org.jensoft.core.plugin.gauge.core.GaugePartBuffer;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.AnchorBinder;
import org.jensoft.core.plugin.gauge.core.binder.PathBinder;
import org.jensoft.core.plugin.gauge.core.needle.GaugeNeedlePainter;

public class GaugeMetricsPath
extends GeneralMetricsPath {
    private double currentValue;
    private AnchorBinder needleBaseAnchorBinder;
    private AnchorBinder needleValueAnchorBinder;
    private GaugeBody body;
    private GaugePartBuffer partBuffer;
    private PathBinder pathBinder;
    private GaugeNeedlePainter gaugeNeedlePainter;

    public GaugeMetricsPath() {
        this.setProjectionNature(AbstractMetricsPath.ProjectionNature.DEVICE);
    }

    public GaugeNeedlePainter getGaugeNeedlePainter() {
        return this.gaugeNeedlePainter;
    }

    public void setGaugeNeedlePainter(GaugeNeedlePainter gaugeNeedlePainter) {
        this.gaugeNeedlePainter = gaugeNeedlePainter;
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(double currentValue) {
        if (currentValue < this.getMin() || currentValue > this.getMax()) {
            throw new IllegalArgumentException("metrics of of range. " + currentValue + " is outside [min,max] path range. ");
        }
        this.currentValue = currentValue;
    }

    public PathBinder getPathBinder() {
        return this.pathBinder;
    }

    public void setPathBinder(PathBinder pathBinder) {
        pathBinder.setMetricsPath(this);
        this.pathBinder = pathBinder;
    }

    public AnchorBinder getNeedleBaseAnchorBinder() {
        return this.needleBaseAnchorBinder;
    }

    public void setNeedleBaseAnchorBinder(AnchorBinder needleAnchorBinder) {
        needleAnchorBinder.setMetricsPath(this);
        this.needleBaseAnchorBinder = needleAnchorBinder;
    }

    public AnchorBinder getNeedleValueAnchorBinder() {
        return this.needleValueAnchorBinder;
    }

    public void setNeedleValueAnchorBinder(AnchorBinder needleValueAnchorBinder) {
        needleValueAnchorBinder.setMetricsPath(this);
        this.needleValueAnchorBinder = needleValueAnchorBinder;
    }

    public GaugeBody getBody() {
        return this.body;
    }

    public void setBody(GaugeBody body) {
        this.body = body;
    }

    public void setPartBuffer(GaugePartBuffer partBuffer) {
        this.partBuffer = partBuffer;
    }

    public GaugePartBuffer getPartBuffer() {
        return this.partBuffer;
    }

    public void invalidate() {
        this.setPartBuffer(null);
    }

    public void createPartBuffer(Graphics2D g2d) {
        this.partBuffer = new GaugePartBuffer(this.getBody().getGauge());
        Graphics2D g2dPart = this.partBuffer.getGraphics();
        g2dPart.setRenderingHints(g2d.getRenderingHints());
        this.setFontRenderContext(g2d.getFontRenderContext());
        this.setSolveGeometryRequest(true);
        if (this.getPathPainter() != null) {
            this.getPathPainter().paintPath(g2dPart, this);
        }
        List<GlyphMetric> metrics = this.getMetrics();
        for (GlyphMetric m : metrics) {
            if (m.getGlyphMetricMarkerPainter() != null) {
                m.getGlyphMetricMarkerPainter().paintGlyphMetric(g2dPart, m);
            }
            if (m.getGlyphMetricFill() != null) {
                m.getGlyphMetricFill().paintGlyphMetric(g2dPart, m);
            }
            if (m.getGlyphMetricDraw() != null) {
                m.getGlyphMetricDraw().paintGlyphMetric(g2dPart, m);
            }
            if (m.getGlyphMetricEffect() == null) continue;
            m.getGlyphMetricEffect().paintGlyphMetric(g2dPart, m);
        }
    }

    public static interface ArcBinder {
        public Arc2D bindArc(RadialGauge var1);
    }
}

