/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core.binder.anchor;

import java.awt.geom.Point2D;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.AnchorBinder;

public class AnchorBaseBinder
extends AnchorBinder {
    private int radius;
    private float angleDegree;

    public AnchorBaseBinder() {
        this.radius = 0;
        this.angleDegree = 0.0f;
    }

    public AnchorBaseBinder(int radius, float angleDegree) {
        this.radius = radius;
        this.angleDegree = angleDegree;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public float getAngleDegree() {
        return this.angleDegree;
    }

    public void setAngleDegree(float angleDegree) {
        this.angleDegree = angleDegree;
    }

    @Override
    public Point2D bindAnchor(RadialGauge gauge) {
        double anchorX = gauge.getCenterDevice().getX() + (double)this.radius * Math.cos(Math.toRadians(this.angleDegree));
        double anchorY = gauge.getCenterDevice().getY() - (double)this.radius * Math.sin(Math.toRadians(this.angleDegree));
        return new Point2D.Double(anchorX, anchorY);
    }
}

