/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core.binder.path;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.path.AbstractPathAutoBinder;

public class PathCubicAutoBinder
extends AbstractPathAutoBinder {
    private CubicCurve2D intersectionCubicCurve;
    private double controlOffsetRadius = 10.0;
    private double controlOffsetAngleDegree = 10.0;

    public PathCubicAutoBinder(int radius, int polarRadius, float polarDegree) {
        super(radius, polarRadius, polarDegree);
    }

    public PathCubicAutoBinder(int radius, int polarRadius, float polarDegree, AbstractPathAutoBinder.Direction direction) {
        super(radius, polarRadius, polarDegree, direction);
    }

    public CubicCurve2D getIntersectionCubicCurve() {
        return this.intersectionCubicCurve;
    }

    public void setIntersectionCubicCurve(CubicCurve2D intersectionCubicCurve) {
        this.intersectionCubicCurve = intersectionCubicCurve;
    }

    public double getControlOffsetRadius() {
        return this.controlOffsetRadius;
    }

    public void setControlOffsetRadius(double controlOffsetRadius) {
        if (controlOffsetRadius < 0.0) {
            throw new IllegalArgumentException("control offset radius must be positive");
        }
        this.controlOffsetRadius = controlOffsetRadius;
    }

    public double getControlOffsetAngleDegree() {
        return this.controlOffsetAngleDegree;
    }

    public void setControlOffsetAngleDegree(double controlOffsetAngleDegree) {
        if (controlOffsetAngleDegree < 0.0) {
            throw new IllegalArgumentException("control offset angle must be positive");
        }
        this.controlOffsetAngleDegree = controlOffsetAngleDegree;
    }

    private CubicCurve2D createCubicStart2End() {
        return new CubicCurve2D.Double(this.intersectionPointStart.getX(), this.intersectionPointStart.getY(), this.getControlPoint1().getX(), this.getControlPoint1().getY(), this.getControlPoint2().getX(), this.getControlPoint2().getY(), this.intersectionPointEnd.getX(), this.intersectionPointEnd.getY());
    }

    private CubicCurve2D createCubicEnd2Start() {
        return new CubicCurve2D.Double(this.intersectionPointEnd.getX(), this.intersectionPointEnd.getY(), this.getControlPoint1().getX(), this.getControlPoint1().getY(), this.getControlPoint2().getX(), this.getControlPoint2().getY(), this.intersectionPointStart.getX(), this.intersectionPointStart.getY());
    }

    @Override
    public Shape createPath() {
        if (this.intersectionPointStart == null || this.intersectionPointEnd == null) {
            return null;
        }
        if (this.polarDegree >= 0.0f && this.polarDegree < 180.0f) {
            if (this.direction == AbstractPathAutoBinder.Direction.AntiClockwise) {
                this.intersectionCubicCurve = this.createCubicStart2End();
            } else if (this.direction == AbstractPathAutoBinder.Direction.Clockwise) {
                this.intersectionCubicCurve = this.createCubicEnd2Start();
            }
        } else if (this.polarDegree >= 180.0f && this.polarDegree < 360.0f) {
            if (this.direction == AbstractPathAutoBinder.Direction.AntiClockwise) {
                this.intersectionCubicCurve = this.createCubicEnd2Start();
            } else if (this.direction == AbstractPathAutoBinder.Direction.Clockwise) {
                this.intersectionCubicCurve = this.createCubicStart2End();
            }
        }
        return this.intersectionCubicCurve;
    }

    private Point2D getControlPoint1() {
        if (this.direction == AbstractPathAutoBinder.Direction.Clockwise) {
            double x = this.x1 + ((double)this.radius + this.controlOffsetRadius) * Math.cos(Math.toRadians(this.polarDegree) + Math.PI + Math.toRadians(this.controlOffsetAngleDegree));
            double y = this.y1 - ((double)this.radius + this.controlOffsetRadius) * Math.sin(Math.toRadians(this.polarDegree) + Math.PI + Math.toRadians(this.controlOffsetAngleDegree));
            return new Point2D.Double(x, y);
        }
        double x = this.x1 + ((double)this.radius + this.controlOffsetRadius) * Math.cos(Math.toRadians(this.polarDegree) + Math.PI - Math.toRadians(this.controlOffsetAngleDegree));
        double y = this.y1 - ((double)this.radius + this.controlOffsetRadius) * Math.sin(Math.toRadians(this.polarDegree) + Math.PI - Math.toRadians(this.controlOffsetAngleDegree));
        return new Point2D.Double(x, y);
    }

    private Point2D getControlPoint2() {
        if (this.direction == AbstractPathAutoBinder.Direction.Clockwise) {
            double x = this.x1 + ((double)this.radius + this.controlOffsetRadius) * Math.cos(Math.toRadians(this.polarDegree) + Math.PI - Math.toRadians(this.controlOffsetAngleDegree));
            double y = this.y1 - ((double)this.radius + this.controlOffsetRadius) * Math.sin(Math.toRadians(this.polarDegree) + Math.PI - Math.toRadians(this.controlOffsetAngleDegree));
            return new Point2D.Double(x, y);
        }
        double x = this.x1 + ((double)this.radius + this.controlOffsetRadius) * Math.cos(Math.toRadians(this.polarDegree) + Math.PI + Math.toRadians(this.controlOffsetAngleDegree));
        double y = this.y1 - ((double)this.radius + this.controlOffsetRadius) * Math.sin(Math.toRadians(this.polarDegree) + Math.PI + Math.toRadians(this.controlOffsetAngleDegree));
        return new Point2D.Double(x, y);
    }

    @Override
    public void debug(Graphics2D g2d, RadialGauge gauge) {
        super.debug(g2d, gauge);
        g2d.setColor(NanoChromatique.BLUE);
        g2d.draw(new Ellipse2D.Double(this.getControlPoint1().getX() - 2.0, this.getControlPoint1().getY() - 2.0, 4.0, 4.0));
        g2d.drawString("C1", (int)this.getControlPoint1().getX(), (int)this.getControlPoint1().getY());
        g2d.setColor(NanoChromatique.RED);
        g2d.draw(new Ellipse2D.Double(this.getControlPoint2().getX() - 2.0, this.getControlPoint2().getY() - 2.0, 4.0, 4.0));
        g2d.drawString("C2", (int)this.getControlPoint2().getX(), (int)this.getControlPoint2().getY());
        g2d.setColor(new Alpha(NanoChromatique.GREEN, 80));
        g2d.draw(new Ellipse2D.Double(this.x1 - (this.r1 + this.controlOffsetRadius), this.y1 - (this.r1 + this.controlOffsetRadius), 2.0 * (this.r1 + this.controlOffsetRadius), 2.0 * (this.r1 + this.controlOffsetRadius)));
    }
}

