/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core.needle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.GaugeMetricsPath;
import org.jensoft.core.plugin.gauge.core.needle.GaugeNeedlePainter;

public class GaugeNeedleClassicWatchSecond
extends GaugeNeedlePainter {
    private Color baseColor = NanoChromatique.RED;
    private int towardOffset = 6;
    private int baseCircleRadius = 3;
    private Color baseCircleColor = NanoChromatique.RED;

    public GaugeNeedleClassicWatchSecond() {
    }

    public GaugeNeedleClassicWatchSecond(Color baseColor) {
        this.baseColor = baseColor;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor;
    }

    public int getTowardOffset() {
        return this.towardOffset;
    }

    public void setTowardOffset(int towardOffset) {
        this.towardOffset = towardOffset;
    }

    public int getBaseCircleRadius() {
        return this.baseCircleRadius;
    }

    public void setBaseCircleRadius(int baseCircleRadius) {
        this.baseCircleRadius = baseCircleRadius;
    }

    public Color getBaseCircleColor() {
        return this.baseCircleColor;
    }

    public void setBaseCircleColor(Color baseCircleColor) {
        this.baseCircleColor = baseCircleColor;
    }

    @Override
    public void paintNeedle(Graphics2D g2d, GaugeMetricsPath gaugeMetricsPath) {
        Point2D needleBase = gaugeMetricsPath.getNeedleBaseAnchorBinder().bindAnchor(gaugeMetricsPath.getBody().getGauge());
        Point2D needleValue = gaugeMetricsPath.getNeedleValueAnchorBinder().bindAnchor(gaugeMetricsPath.getBody().getGauge());
        Line2D.Double needleLineBase = new Line2D.Double(needleBase, needleValue);
        GeometryPath geomPath1 = new GeometryPath(needleLineBase);
        double centerX = needleBase.getX();
        double centerY = needleBase.getY();
        double px = centerX + (double)this.towardOffset * Math.sin((double)geomPath1.angleAtLength(0.0f) + 4.71238898038469);
        double py = centerY - (double)this.towardOffset * Math.cos((double)geomPath1.angleAtLength(0.0f) + 4.71238898038469);
        Line2D.Double needleLineBaseExtends = new Line2D.Double(px, py, needleValue.getX(), needleValue.getY());
        g2d.setColor(this.baseColor);
        g2d.setStroke(new BasicStroke(2.2f));
        g2d.draw(needleLineBaseExtends);
        g2d.setColor(this.baseCircleColor);
        Ellipse2D.Double e = new Ellipse2D.Double(centerX - (double)this.baseCircleRadius, centerY - (double)this.baseCircleRadius, 2 * this.baseCircleRadius, 2 * this.baseCircleRadius);
        g2d.fill(e);
    }
}

