/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core.timing;

import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.gauge.core.timing.TimingListener;

public class TimingEngine {
    private long duration;
    private long resolution;
    private Engine engine;
    private Timing timing;
    private long startTime;
    private boolean infinite = false;
    private List<TimingListener> timingsListeners = new ArrayList<TimingListener>();
    private boolean armedCycle = true;

    public long getResolution() {
        return this.resolution;
    }

    public void setResolution(long resolution) {
        this.resolution = resolution;
    }

    public static void main(String[] args) {
        TimingEngine te = new TimingEngine(10000L);
        te.setResolution(1000L);
        te.addTimingListener(new TimingListener(){

            @Override
            public void timingEvent(float fraction) {
                System.out.println("timing event fraction +" + fraction);
            }

            @Override
            public void stopCycle() {
                System.out.println("stop cycle");
            }

            @Override
            public void startCycle() {
                System.out.println("start cycle");
            }

            @Override
            public void engineStop() {
                System.out.println("engine stop");
            }

            @Override
            public void engineStart() {
                System.out.println("engine start");
            }
        });
        te.startEngine();
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        te.stopEngine();
    }

    public TimingEngine(long duration) {
        this.duration = duration;
    }

    public void startEngine() {
        this.engine = new Engine();
        this.engine.start();
    }

    public void stopEngine() {
        this.engine.interrupt();
    }

    public void addTimingListener(TimingListener listener) {
        this.timingsListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineStop() {
        List<TimingListener> list = this.timingsListeners;
        synchronized (list) {
            for (TimingListener l : this.timingsListeners) {
                l.engineStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineStart() {
        List<TimingListener> list = this.timingsListeners;
        synchronized (list) {
            for (TimingListener l : this.timingsListeners) {
                l.engineStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTimingEvent(float fraction) {
        List<TimingListener> list = this.timingsListeners;
        synchronized (list) {
            for (TimingListener l : this.timingsListeners) {
                l.timingEvent(fraction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStopCycle() {
        List<TimingListener> list = this.timingsListeners;
        synchronized (list) {
            this.armedCycle = true;
            for (TimingListener l : this.timingsListeners) {
                l.stopCycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartCycle() {
        List<TimingListener> list = this.timingsListeners;
        synchronized (list) {
            this.armedCycle = false;
            for (TimingListener l : this.timingsListeners) {
                l.startCycle();
            }
        }
    }

    class Timing
    extends Thread {
        private Engine e;

        public Timing(Engine e) {
            this.e = e;
        }

        @Override
        public void run() {
            while (!Timing.interrupted()) {
                try {
                    if (TimingEngine.this.armedCycle) {
                        TimingEngine.this.fireStartCycle();
                    }
                    Timing.sleep(TimingEngine.this.resolution);
                    long t = System.currentTimeMillis();
                    double delta = new Double(t) - new Double(TimingEngine.this.startTime);
                    double fraction = new Double(delta) / new Double(TimingEngine.this.duration);
                    if (fraction >= 1.0) {
                        TimingEngine.this.fireTimingEvent((float)fraction);
                        TimingEngine.this.fireStopCycle();
                        fraction = 0.0;
                        TimingEngine.this.startTime = t;
                        continue;
                    }
                    TimingEngine.this.fireTimingEvent((float)fraction);
                }
                catch (InterruptedException e) {
                    long t = System.currentTimeMillis();
                    double delta = new Double(t) - new Double(TimingEngine.this.startTime);
                    double fraction = new Double(delta) / new Double(TimingEngine.this.duration);
                    if (fraction > 1.0) {
                        TimingEngine.this.fireTimingEvent(1.0f);
                    } else {
                        TimingEngine.this.fireTimingEvent((float)fraction);
                    }
                    TimingEngine.this.fireStopCycle();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    class Engine
    extends Thread {
        @Override
        public void run() {
            TimingEngine.this.fireEngineStart();
            boolean einterupt = false;
            try {
                TimingEngine.this.startTime = System.currentTimeMillis();
                TimingEngine.this.timing = new Timing(this);
                TimingEngine.this.timing.start();
                if (TimingEngine.this.infinite) {
                    while (true) {
                        Engine.sleep(TimingEngine.this.duration);
                    }
                }
                Engine.sleep(TimingEngine.this.duration);
                throw new InterruptedException("TimingEngine interrupt");
            }
            catch (InterruptedException e) {
                TimingEngine.this.timing.interrupt();
                einterupt = true;
                TimingEngine.this.fireEngineStop();
                if (einterupt) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
        }
    }
}

