/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.watch;

import java.awt.Color;
import java.awt.Font;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.glyphmetrics.painter.fill.GlyphFill;
import org.jensoft.core.glyphmetrics.painter.marker.DefaultMarker;
import org.jensoft.core.glyphmetrics.painter.marker.RectangleMarker;
import org.jensoft.core.glyphmetrics.painter.marker.RoundMarker;
import org.jensoft.core.glyphmetrics.painter.marker.TicTacMarker;
import org.jensoft.core.palette.InputFonts;
import org.jensoft.core.palette.TexturePalette;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.GaugeBackground;
import org.jensoft.core.plugin.gauge.core.GaugeBody;
import org.jensoft.core.plugin.gauge.core.GaugeEnvelope;
import org.jensoft.core.plugin.gauge.core.GaugeGlass;
import org.jensoft.core.plugin.gauge.core.GaugeMetricsPath;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.anchor.AnchorBaseBinder;
import org.jensoft.core.plugin.gauge.core.binder.anchor.AnchorValueBinder;
import org.jensoft.core.plugin.gauge.core.binder.path.PathArcManualBinder;
import org.jensoft.core.plugin.gauge.core.needle.GaugeNeedleClassicWatchHour;
import org.jensoft.core.plugin.gauge.core.needle.GaugeNeedleClassicWatchMinute;
import org.jensoft.core.plugin.gauge.core.needle.GaugeNeedleClassicWatchSecond;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectFrame;

public class Watch
extends RadialGauge {
    private GaugeBody body;
    private static int gaugeRadius = 90;
    private static int centerUserX = 0;
    private static int centerUserY = 0;
    private GaugeMetricsPath hourMetricsManager;
    private GaugeMetricsPath minuteMetricsManager;
    private GaugeMetricsPath secondMetricsManager;
    private GaugeMetricsPath miniMetricsManager;

    public Watch() {
        super(centerUserX, centerUserY, gaugeRadius);
        GaugeEnvelope.Cisero cisero = new GaugeEnvelope.Cisero();
        this.setEnvelop(cisero);
        GaugeBackground.Circular.Texture bg = new GaugeBackground.Circular.Texture(TexturePalette.getSquareCarbonFiber());
        this.addBackground(bg);
        GaugeGlass.GlassIncubator g3 = new GaugeGlass.GlassIncubator();
        GaugeGlass.Donut2DGlass g5 = new GaugeGlass.Donut2DGlass();
        GaugeGlass.JenSoftAPILabel g6 = new GaugeGlass.JenSoftAPILabel();
        GaugeGlass.GlassCubicEffect gCubic = new GaugeGlass.GlassCubicEffect(CubicEffectFrame.Wave6);
        gCubic.setIncidenceAngleDegree(60);
        this.addGlass((GaugeGlass)gCubic);
        this.createWatch();
        this.hourMetricsManager.setCurrentValue(2.0);
        this.minuteMetricsManager.setCurrentValue(30.0);
        this.secondMetricsManager.setCurrentValue(38.0);
    }

    private void createWatch() {
        this.body = new GaugeBody();
        this.addBody(this.body);
        PathArcManualBinder pathBinder = new PathArcManualBinder(gaugeRadius - 10, 90.0f, -360.0f);
        AnchorBaseBinder needleBase = new AnchorBaseBinder();
        AnchorValueBinder needleHourAnchor = new AnchorValueBinder(50, Side.SideRight);
        AnchorValueBinder needleMinuteAnchor = new AnchorValueBinder(20, Side.SideRight);
        AnchorValueBinder needleSecondAnchor = new AnchorValueBinder(20, Side.SideRight);
        this.hourMetricsManager = new GaugeMetricsPath();
        this.hourMetricsManager.setRange(0.0, 12.0);
        this.hourMetricsManager.setPathBinder(pathBinder);
        this.hourMetricsManager.setNeedleBaseAnchorBinder(needleBase);
        this.hourMetricsManager.setNeedleValueAnchorBinder(needleHourAnchor);
        this.hourMetricsManager.setGaugeNeedlePainter(new GaugeNeedleClassicWatchHour());
        this.minuteMetricsManager = new GaugeMetricsPath();
        this.minuteMetricsManager.setRange(0.0, 60.0);
        this.minuteMetricsManager.setPathBinder(pathBinder);
        this.minuteMetricsManager.setNeedleBaseAnchorBinder(needleBase);
        this.minuteMetricsManager.setNeedleValueAnchorBinder(needleMinuteAnchor);
        this.minuteMetricsManager.setGaugeNeedlePainter(new GaugeNeedleClassicWatchMinute());
        this.secondMetricsManager = new GaugeMetricsPath();
        this.secondMetricsManager.setRange(0.0, 60.0);
        this.secondMetricsManager.setPathBinder(pathBinder);
        this.secondMetricsManager.setNeedleBaseAnchorBinder(needleBase);
        this.secondMetricsManager.setNeedleValueAnchorBinder(needleSecondAnchor);
        this.secondMetricsManager.setGaugeNeedlePainter(new GaugeNeedleClassicWatchSecond(NanoChromatique.ORANGE));
        this.body.registerGaugeMetricsPath(this.hourMetricsManager);
        this.body.registerGaugeMetricsPath(this.minuteMetricsManager);
        this.body.registerGaugeMetricsPath(this.secondMetricsManager);
        this.createMainTicks();
        this.createMainMetrics();
        this.createMiniGauge();
    }

    private void createMiniGauge() {
        GaugeBackground.Circular.RadialGradient bg = new GaugeBackground.Circular.RadialGradient(gaugeRadius / 6, (int)((double)gaugeRadius / 2.3), 145.0f);
        this.addBackground(bg);
        this.miniMetricsManager = new GaugeMetricsPath();
        this.miniMetricsManager.setRange(0.0, 24.0);
        this.miniMetricsManager.setPathBinder(new PathArcManualBinder(gaugeRadius / 6, 0.0f, 360.0f, (int)((double)gaugeRadius / 2.3), 145.0f));
        AnchorBaseBinder needleMiniBaseAnchor = new AnchorBaseBinder((int)((double)gaugeRadius / 2.3), 145.0f);
        this.miniMetricsManager.setNeedleBaseAnchorBinder(needleMiniBaseAnchor);
        AnchorValueBinder needleMiniValueAnchor = new AnchorValueBinder(5, Side.SideLeft);
        this.miniMetricsManager.setNeedleValueAnchorBinder(needleMiniValueAnchor);
        this.miniMetricsManager.setGaugeNeedlePainter(new GaugeNeedleClassicWatchSecond(Color.WHITE));
        Font f = new Font("Dialog", 0, 8);
        GlyphMetric metric = new GlyphMetric();
        metric.setValue(0.0);
        metric.setGlyphMetricFill(new GlyphFill(Color.WHITE, NanoChromatique.RED.brighter()));
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("12");
        metric.setDivergence(-5);
        metric.setFont(f);
        this.miniMetricsManager.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(6.0);
        metric.setGlyphMetricFill(new GlyphFill(Color.WHITE, NanoChromatique.YELLOW.brighter()));
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("24");
        metric.setDivergence(-5);
        metric.setFont(f);
        this.miniMetricsManager.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(12.0);
        metric.setGlyphMetricFill(new GlyphFill(Color.GRAY, NanoChromatique.BLUE.brighter()));
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("18");
        metric.setDivergence(-5);
        metric.setFont(f);
        this.miniMetricsManager.addMetric(metric);
        this.body.registerGaugeMetricsPath(this.miniMetricsManager);
    }

    private void createMainTicks() {
        int i;
        RoundMarker rm = new RoundMarker(NanoChromatique.ORANGE, NanoChromatique.WHITE, 4);
        GlyphFill gf = new GlyphFill(Color.WHITE, NanoChromatique.BLUE);
        RectangleMarker rectangle = new RectangleMarker(NanoChromatique.ORANGE.brighter(), Color.WHITE, 3, 8);
        Font f = InputFonts.getFont(InputFonts.ELEMENT, 16.0f);
        for (i = 0; i < 12; ++i) {
            GlyphMetric metric = new GlyphMetric();
            metric.setValue(i);
            metric.setStylePosition(StylePosition.Default);
            metric.setMetricsLabel(i + "");
            metric.setFont(f);
            metric.setDivergence(12);
            if (i == 0 || i == 3 || i == 6 || i == 9) continue;
            metric.setGlyphMetricFill(gf);
            metric.setGlyphMetricMarkerPainter(rectangle);
            this.hourMetricsManager.addMetric(metric);
        }
        for (i = 0; i < 60; i += 5) {
            for (int j = i + 1; j < i + 5; ++j) {
                GlyphMetric metric = new GlyphMetric();
                metric.setValue(j);
                metric.setGlyphMetricMarkerPainter(new DefaultMarker(NanoChromatique.ORANGE.brighter(), 2));
                this.minuteMetricsManager.addMetric(metric);
            }
        }
    }

    private void createMainMetrics() {
        GlyphFill gf = new GlyphFill(Color.WHITE, NanoChromatique.BLUE.darker());
        TicTacMarker ttm = new TicTacMarker(NanoChromatique.RED);
        ttm.setSize(3);
        ttm.setDivergence(3);
        Font f = InputFonts.getFont(InputFonts.ELEMENT, 36.0f);
        GlyphMetric metric = new GlyphMetric();
        metric.setValue(0.0);
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("12");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(gf);
        metric.setFont(f);
        this.hourMetricsManager.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(3.0);
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("3");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(gf);
        metric.setFont(f);
        this.hourMetricsManager.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(6.0);
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("6");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(gf);
        metric.setFont(f);
        this.hourMetricsManager.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(9.0);
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("9");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(gf);
        metric.setFont(f);
        this.hourMetricsManager.addMetric(metric);
    }
}

