/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public class Grid {
    private GridOrientation gridOrientation;
    private double gridUserValue;
    private double gridDeviceValue;
    private Stroke gridStroke;
    private Stroke GRID_STROK_DEFAULT = new BasicStroke();
    private Color gridColor;
    private String annotation;
    private float annotationFraction = 0.1f;

    public Grid() {
    }

    public Grid(GridOrientation gridOrientation) {
        this.gridOrientation = gridOrientation;
    }

    public float getAnnotationFraction() {
        return this.annotationFraction;
    }

    public void setAnnotationFraction(float annotationFraction) {
        this.annotationFraction = annotationFraction;
    }

    public GridOrientation getGridOrientation() {
        return this.gridOrientation;
    }

    public void setGridOrientation(GridOrientation gridOrientation) {
        this.gridOrientation = gridOrientation;
    }

    public double getGridUserValue() {
        return this.gridUserValue;
    }

    public void setGridUserValue(double gridUserValue) {
        this.gridUserValue = gridUserValue;
    }

    public double getGridDeviceValue() {
        return this.gridDeviceValue;
    }

    public void setGridDeviceValue(double gridValue) {
        this.gridDeviceValue = gridValue;
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Stroke getStroke() {
        if (this.gridStroke == null) {
            return this.GRID_STROK_DEFAULT;
        }
        return this.gridStroke;
    }

    public void setGridStroke(Stroke stroke) {
        this.gridStroke = stroke;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Grid other = (Grid)obj;
        if (this.gridOrientation != other.gridOrientation) {
            return false;
        }
        return Double.doubleToLongBits(this.gridDeviceValue) == Double.doubleToLongBits(other.gridDeviceValue);
    }

    public static enum GridOrientation {
        Vertical("vertical"),
        Horizontal("horizontal");

        private String gridOrientation;

        private GridOrientation(String orientation) {
            this.gridOrientation = orientation;
        }

        public String getGridOrientation() {
            return this.gridOrientation;
        }

        public static GridOrientation parse(String orientation) {
            if (Vertical.getGridOrientation().equalsIgnoreCase(orientation)) {
                return Vertical;
            }
            if (Horizontal.getGridOrientation().equalsIgnoreCase(orientation)) {
                return Horizontal;
            }
            return null;
        }
    }
}

