/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.AbstractGridManager;
import org.jensoft.core.plugin.grid.manager.CompoundGridManager;
import org.jensoft.core.plugin.grid.manager.FlowGridManager;
import org.jensoft.core.plugin.grid.manager.FreeGridManager;
import org.jensoft.core.plugin.grid.manager.GridManager;
import org.jensoft.core.plugin.grid.manager.ModeledGridManager;
import org.jensoft.core.plugin.grid.manager.MultiplierGridManager;
import org.jensoft.core.plugin.grid.manager.StaticGridManager;
import org.jensoft.core.plugin.grid.painter.AbstractGridPainter;
import org.jensoft.core.plugin.grid.painter.GridDefaultPainter;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public abstract class GridPlugin<M extends AbstractGridManager>
extends AbstractPlugin {
    private M gridManager;
    private AbstractGridPainter gridPainter = new GridDefaultPainter();

    public GridPlugin() {
        this.setName(GridPlugin.class.getCanonicalName());
        this.setTextAntialising(TextAntialiasing.On);
    }

    @Override
    public final void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        this.paintGrids(view, g2d);
    }

    public GridPlugin(M manager) {
        this.setName(GridPlugin.class.getCanonicalName());
        this.gridManager = manager;
        this.gridPainter = new GridDefaultPainter();
        this.setTextAntialising(TextAntialiasing.On);
    }

    public AbstractGridPainter getGridPainter() {
        return this.gridPainter;
    }

    protected void paintGrids(View v2d, Graphics2D g2d) {
        if (this.gridManager == null) {
            return;
        }
        ((AbstractGridManager)this.gridManager).setProjection(this.getProjection());
        this.gridPainter.setLayoutManager((GridManager)this.gridManager);
        this.gridPainter.paintGrids(g2d, this.gridManager.getGrids());
    }

    public M getGridManager() {
        return this.gridManager;
    }

    public void setGridManager(M gridManager) {
        this.gridManager = gridManager;
    }

    public void setGridOrientation(Grid.GridOrientation gridOrientation) {
        ((AbstractGridManager)this.getGridManager()).setGridOrientation(gridOrientation);
    }

    public Grid.GridOrientation getGridOrientation() {
        return ((AbstractGridManager)this.getGridManager()).getGridOrientation();
    }

    public void setGridColor(Color color) {
        ((AbstractGridManager)this.getGridManager()).setGridColor(color);
    }

    public Color getGridColor() {
        return ((AbstractGridManager)this.getGridManager()).getGridColor();
    }

    public void setGridStroke(Stroke stroke) {
        ((AbstractGridManager)this.getGridManager()).setGridStroke(stroke);
    }

    public Stroke getGridStroke() {
        return ((AbstractGridManager)this.getGridManager()).getGridStroke();
    }

    public static class MultiplierGrid
    extends GridPlugin<MultiplierGridManager> {
        public MultiplierGrid(double ref, double multiplier, Grid.GridOrientation gridOrientation) {
            super(new MultiplierGridManager(gridOrientation, ref, multiplier));
        }

        public void setRef(double ref) {
            ((MultiplierGridManager)this.getGridManager()).setRef(ref);
        }

        public void setMultiplier(double interval) {
            ((MultiplierGridManager)this.getGridManager()).setMultiplier(interval);
        }

        public double getRef() {
            return ((MultiplierGridManager)this.getGridManager()).getRef();
        }

        public double getMultiplier() {
            return ((MultiplierGridManager)this.getGridManager()).getMultiplier();
        }

        public static class V
        extends MultiplierGrid {
            public V(double ref, double multiplier) {
                super(ref, multiplier, Grid.GridOrientation.Vertical);
            }
        }

        public static class H
        extends MultiplierGrid {
            public H(double ref, double multiplier) {
                super(ref, multiplier, Grid.GridOrientation.Horizontal);
            }
        }
    }

    public static class FlowGrid
    extends GridPlugin<FlowGridManager> {
        public FlowGrid(double startGrid, double endGrid, double interval, Grid.GridOrientation gridOrientation) {
            super(new FlowGridManager(gridOrientation, startGrid, endGrid, interval));
        }

        @Override
        public FlowGridManager getGridManager() {
            return (FlowGridManager)super.getGridManager();
        }

        public void setFlowStart(double flowStart) {
            this.getGridManager().setFlowStart(flowStart);
        }

        public void setFlowEnd(double flowEnd) {
            this.getGridManager().setFlowStart(flowEnd);
        }

        public void setFlowInterval(double flowInterval) {
            this.getGridManager().setFlowInterval(flowInterval);
        }

        public double getFlowStart() {
            return this.getGridManager().getFlowStart();
        }

        public double getFlowEnd() {
            return this.getGridManager().getFlowEnd();
        }

        public double getFlowInterval() {
            return this.getGridManager().getFlowInterval();
        }

        public static class V
        extends FlowGrid {
            public V(double startGrid, double endGrid, double interval) {
                super(startGrid, endGrid, interval, Grid.GridOrientation.Vertical);
            }
        }

        public static class H
        extends FlowGrid {
            public H(double startGrid, double endGrid, double interval) {
                super(startGrid, endGrid, interval, Grid.GridOrientation.Horizontal);
            }
        }
    }

    public static class FreeGrid
    extends GridPlugin<FreeGridManager> {
        public FreeGrid(Grid.GridOrientation gridOrientation) {
            super(new FreeGridManager(gridOrientation));
        }

        public void addGrid(Grid grid) {
            FreeGridManager manager = (FreeGridManager)this.getGridManager();
            manager.addGrid(grid);
        }

        public void addGrid(double grid) {
            ((FreeGridManager)this.getGridManager()).addGrid(grid);
        }

        public void addGrid(double grid, Color gridColor) {
            ((FreeGridManager)this.getGridManager()).addGrid(grid, gridColor);
        }

        public void addGrid(double grid, String annotation, Color gridColor, float fractionAnnotation) {
            ((FreeGridManager)this.getGridManager()).addGrid(grid, annotation, gridColor, fractionAnnotation);
        }

        public static class V
        extends FreeGrid {
            public V() {
                super(Grid.GridOrientation.Vertical);
            }
        }

        public static class H
        extends FreeGrid {
            public H() {
                super(Grid.GridOrientation.Horizontal);
            }
        }
    }

    public static class ModeledGrid
    extends GridPlugin<ModeledGridManager> {
        public ModeledGrid(Grid.GridOrientation gridOrientation) {
            super(new ModeledGridManager(gridOrientation));
        }

        public void registerGridModel(ModeledGridManager.GridModel model) {
            ((ModeledGridManager)this.getGridManager()).registerGridModel(model);
        }

        public void registerGridModels(List<ModeledGridManager.GridModel> models) {
            ((ModeledGridManager)this.getGridManager()).registerGridModels(models);
        }

        public void registerGridModels(ModeledGridManager.GridModel ... models) {
            ((ModeledGridManager)this.getGridManager()).registerGridModels(models);
        }

        public void registerGridModels(ModeledGridManager.GridModelCollections gridModelCollections) {
            ((ModeledGridManager)this.getGridManager()).registerGridModels(gridModelCollections);
        }

        @Override
        protected void paintGrids(View v2d, Graphics2D g2d) {
            if (this.getGridManager() == null) {
                return;
            }
            ((ModeledGridManager)this.getGridManager()).setProjection(this.getProjection());
            List<ModeledGridManager.GridModel> models = ((ModeledGridManager)this.getGridManager()).getSequenceGrid();
            for (ModeledGridManager.GridModel gridModel : models) {
                List<Grid> grids = gridModel.generateGrids();
                this.getGridPainter().setLayoutManager((GridManager)this.getGridManager());
                this.getGridPainter().paintGrids(g2d, grids);
            }
        }

        public static class V
        extends ModeledGrid {
            public V() {
                super(Grid.GridOrientation.Vertical);
            }
        }

        public static class H
        extends ModeledGrid {
            public H() {
                super(Grid.GridOrientation.Horizontal);
            }
        }
    }

    public static class StaticGrid
    extends GridPlugin<StaticGridManager> {
        public StaticGrid(Grid.GridOrientation gridOrientation, int gridCount) {
            super(new StaticGridManager(gridOrientation, gridCount));
        }

        public void setGridCount(int gridCount) {
            ((StaticGridManager)this.getGridManager()).setGridCount(gridCount);
        }

        public void getGridCount() {
            ((StaticGridManager)this.getGridManager()).getGridCount();
        }

        public static class V
        extends StaticGrid {
            public V(int gridCount) {
                super(Grid.GridOrientation.Vertical, gridCount);
            }
        }

        public static class H
        extends StaticGrid {
            public H(int gridCount) {
                super(Grid.GridOrientation.Horizontal, gridCount);
            }
        }
    }

    public static class CompoundGrid
    extends GridPlugin<CompoundGridManager> {
        public CompoundGrid(Grid.GridOrientation gridOrientation) {
            super(new CompoundGridManager(gridOrientation));
        }

        public void addManager(GridManager ... gmanagers) {
            ((CompoundGridManager)this.getGridManager()).addManagers(gmanagers);
        }

        public static class V
        extends CompoundGrid {
            public V(int gridCount) {
                super(Grid.GridOrientation.Vertical);
            }
        }

        public static class H
        extends CompoundGrid {
            public H(int gridCount) {
                super(Grid.GridOrientation.Horizontal);
            }
        }
    }
}

