/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid.manager;

import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.AbstractGridManager;
import org.jensoft.core.plugin.grid.manager.GridManager;
import org.jensoft.core.projection.Projection;

public class CompoundGridManager
extends AbstractGridManager {
    private List<GridManager> managers;
    private List<Grid> compoundgrids;

    public CompoundGridManager(Grid.GridOrientation gridOrientation) {
        super(gridOrientation);
        this.compoundgrids = new ArrayList<Grid>();
    }

    public void addManagers(GridManager ... gmanagers) {
        for (int i = 0; i < gmanagers.length; ++i) {
            this.managers.add(gmanagers[i]);
        }
    }

    public List<GridManager> getManagers() {
        return this.managers;
    }

    public void setManagers(List<GridManager> managers) {
        this.managers = managers;
    }

    public CompoundGridManager(Grid.GridOrientation gridOrientation, GridManager ... managers) {
        super(gridOrientation);
        for (int i = 0; i < managers.length; ++i) {
            this.managers.add(managers[i]);
        }
        this.compoundgrids = new ArrayList<Grid>();
    }

    @Override
    public List<Grid> getGrids() {
        int i;
        this.compoundgrids.clear();
        for (i = 0; i < this.managers.size(); ++i) {
            this.managers.get(i).setGridOrientation(super.getGridOrientation());
            this.managers.get(i).setGridStroke(super.getGridStroke());
            this.managers.get(i).setGridColor(super.getGridColor());
        }
        for (i = 0; i < this.managers.size(); ++i) {
            this.compoundgrids.addAll(this.managers.get(i).getGrids());
        }
        return this.compoundgrids;
    }

    @Override
    public void setProjection(Projection projection) {
        super.setProjection(projection);
        for (int i = 0; i < this.managers.size(); ++i) {
            this.managers.get(i).setProjection(projection);
        }
    }

    @Override
    public void setGridOrientation(Grid.GridOrientation gridOrientation) {
        super.setGridOrientation(gridOrientation);
        for (int i = 0; i < this.managers.size(); ++i) {
            this.managers.get(i).setGridOrientation(gridOrientation);
        }
    }

    @Override
    public void setGridColor(Color c) {
        super.setGridColor(c);
        for (int i = 0; i < this.managers.size(); ++i) {
            this.managers.get(i).setGridColor(c);
        }
    }

    @Override
    public void setGridStroke(Stroke s) {
        super.setGridStroke(s);
        for (int i = 0; i < this.managers.size(); ++i) {
            this.managers.get(i).setGridStroke(s);
        }
    }
}

