/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.AbstractGridManager;
import org.jensoft.core.plugin.grid.manager.GridManager;

public class FlowGridManager
extends AbstractGridManager {
    private double flowInterval = 0.0;
    private double flowStart = 0.0;
    private double flowEnd = 0.0;
    private List<Grid> deviceGrids = new ArrayList<Grid>();

    public FlowGridManager(Grid.GridOrientation gridOrientation, double startGrid, double endGrid, double gridInterval) {
        super(gridOrientation);
        this.flowStart = startGrid;
        this.flowEnd = endGrid;
        this.flowInterval = gridInterval;
    }

    public double getFlowInterval() {
        return this.flowInterval;
    }

    public void setFlowInterval(double flowInterval) {
        this.flowInterval = flowInterval;
    }

    public double getFlowStart() {
        return this.flowStart;
    }

    public void setFlowStart(double flowStart) {
        this.flowStart = flowStart;
    }

    public double getFlowEnd() {
        return this.flowEnd;
    }

    public void setFlowEnd(double flowEnd) {
        this.flowEnd = flowEnd;
    }

    @Override
    public List<Grid> getGrids() {
        this.deviceGrids.clear();
        double interval = this.flowEnd - this.flowStart;
        int gridNumber = (int)(interval / this.flowInterval);
        if (gridNumber > 0) {
            for (int i = 0; i <= gridNumber; ++i) {
                Grid grid;
                Point2D p2ddevice;
                Point2D.Double p2dUser;
                double g = this.flowStart + (double)i * this.flowInterval;
                if (this.getGridOrientation() == Grid.GridOrientation.Vertical) {
                    p2dUser = new Point2D.Double(g, 0.0);
                    p2ddevice = this.getProjection().userToPixel(p2dUser);
                    grid = new Grid(Grid.GridOrientation.Vertical);
                    grid.setGridDeviceValue(p2ddevice.getX());
                    if (this.getGridColor() != null) {
                        grid.setGridColor(this.getGridColor());
                    } else {
                        grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                    }
                    if (this.getGridStroke() != null) {
                        grid.setGridStroke(this.getGridStroke());
                    } else {
                        grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                    }
                    this.deviceGrids.add(grid);
                    continue;
                }
                if (this.getGridOrientation() != Grid.GridOrientation.Horizontal) continue;
                p2dUser = new Point2D.Double(0.0, g);
                p2ddevice = this.getProjection().userToPixel(p2dUser);
                grid = new Grid(Grid.GridOrientation.Horizontal);
                grid.setGridDeviceValue(p2ddevice.getY());
                if (this.getGridColor() != null) {
                    grid.setGridColor(this.getGridColor());
                } else {
                    grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                }
                if (this.getGridStroke() != null) {
                    grid.setGridStroke(this.getGridStroke());
                } else {
                    grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                }
                this.deviceGrids.add(grid);
            }
        }
        return this.deviceGrids;
    }
}

