/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid.manager;

import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.AbstractGridManager;
import org.jensoft.core.plugin.grid.manager.GridManager;

public class FreeGridManager
extends AbstractGridManager {
    private List<Grid> grids = new ArrayList<Grid>();
    List<Grid> deviceGrids = new Vector<Grid>();

    public FreeGridManager(Grid.GridOrientation gridOrientation) {
        super(gridOrientation);
    }

    public void addGrid(Grid grid) {
        this.grids.add(grid);
    }

    public void addGrid(double grid) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setAnnotationFraction(0.1f);
        this.grids.add(g);
    }

    public void addGrid(double grid, Color gridColor) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setAnnotationFraction(0.1f);
        g.setGridColor(gridColor);
        this.grids.add(g);
    }

    public void addGrid(double grid, String annotation) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setAnnotationFraction(0.1f);
        g.setAnnotation(annotation);
        this.grids.add(g);
    }

    public void addGrid(double grid, String annotation, Color gridColor) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setAnnotationFraction(0.1f);
        g.setAnnotation(annotation);
        g.setGridColor(gridColor);
        this.grids.add(g);
    }

    public void addGrid(double grid, String annotation, Color gridColor, Stroke gridStroke) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setAnnotationFraction(0.1f);
        g.setAnnotation(annotation);
        g.setGridColor(gridColor);
        g.setGridStroke(gridStroke);
        this.grids.add(g);
    }

    public void addGrid(double grid, String annotation, Color gridColor, Stroke gridStroke, float fractionAnnotation) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setAnnotationFraction(fractionAnnotation);
        g.setAnnotation(annotation);
        g.setGridColor(gridColor);
        g.setGridStroke(gridStroke);
        this.grids.add(g);
    }

    public void addGrid(double grid, String annotation, float fractionAnnotation) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setAnnotationFraction(fractionAnnotation);
        g.setAnnotation(annotation);
        this.grids.add(g);
    }

    public void addGrid(double grid, String annotation, Color gridColor, float fractionAnnotation) {
        Grid g = new Grid();
        g.setGridUserValue(grid);
        g.setGridColor(gridColor);
        g.setAnnotationFraction(fractionAnnotation);
        g.setAnnotation(annotation);
        this.grids.add(g);
    }

    @Override
    public List<Grid> getGrids() {
        block19: {
            block18: {
                this.deviceGrids.clear();
                if (this.getGridOrientation() != Grid.GridOrientation.Vertical) break block18;
                for (int i = 0; i < this.grids.size(); ++i) {
                    Grid gt = this.grids.get(i);
                    double dx = gt.getGridUserValue();
                    Point2D.Double p2dUser = new Point2D.Double(dx, 0.0);
                    Point2D p2ddevice = this.getProjection().userToPixel(p2dUser);
                    Grid grid = new Grid(Grid.GridOrientation.Vertical);
                    grid.setGridDeviceValue(p2ddevice.getX());
                    if (gt.getGridColor() != null) {
                        grid.setGridColor(gt.getGridColor());
                    } else if (this.getGridColor() != null) {
                        grid.setGridColor(this.getGridColor());
                    } else {
                        grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                    }
                    if (gt.getGridStroke() != null) {
                        grid.setGridStroke(gt.getGridStroke());
                    } else if (this.getGridStroke() != null) {
                        grid.setGridStroke(this.getGridStroke());
                    } else {
                        grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                    }
                    grid.setAnnotationFraction(gt.getAnnotationFraction());
                    grid.setAnnotation(gt.getAnnotation());
                    this.deviceGrids.add(grid);
                }
                break block19;
            }
            if (this.getGridOrientation() != Grid.GridOrientation.Horizontal) break block19;
            for (int i = 0; i < this.grids.size(); ++i) {
                Grid gt = this.grids.get(i);
                double dy = gt.getGridUserValue();
                Point2D.Double p2dUser = new Point2D.Double(0.0, dy);
                Point2D p2ddevice = this.getProjection().userToPixel(p2dUser);
                Grid grid = new Grid(Grid.GridOrientation.Horizontal);
                grid.setGridDeviceValue(p2ddevice.getY());
                if (gt.getGridColor() != null) {
                    grid.setGridColor(gt.getGridColor());
                } else if (this.getGridColor() != null) {
                    grid.setGridColor(this.getGridColor());
                } else {
                    grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                }
                if (gt.getGridStroke() != null) {
                    grid.setGridStroke(gt.getGridStroke());
                } else if (this.getGridStroke() != null) {
                    grid.setGridStroke(this.getGridStroke());
                } else {
                    grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                }
                grid.setAnnotationFraction(gt.getAnnotationFraction());
                grid.setAnnotation(gt.getAnnotation());
                this.deviceGrids.add(grid);
            }
        }
        return this.deviceGrids;
    }
}

