/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid.painter;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.List;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.GridManager;
import org.jensoft.core.plugin.grid.painter.AbstractGridPainter;

public class GridDefaultPainter
extends AbstractGridPainter {
    @Override
    public void paintGrids(Graphics2D g2d, List<Grid> grids) {
        Line2D.Double grid2DShape;
        double gd;
        Grid grid;
        int i;
        GridManager manager = this.getLayoutManager();
        if (manager == null) {
            return;
        }
        if (manager.getGridOrientation() == Grid.GridOrientation.Vertical) {
            for (i = 0; i < grids.size(); ++i) {
                grid = grids.get(i);
                gd = grid.getGridDeviceValue();
                g2d.setStroke(grid.getStroke());
                if (grid.getGridColor() != null) {
                    g2d.setPaint(grid.getGridColor());
                } else {
                    g2d.setColor(this.getLayoutManager().getProjection().getThemeColor());
                }
                grid2DShape = new Line2D.Double(gd, this.getLayoutManager().getProjection().getDevice2D().getOriginY(), gd, this.getLayoutManager().getProjection().getDevice2D().getDeviceHeight() + this.getLayoutManager().getProjection().getDevice2D().getOriginY());
                g2d.draw(grid2DShape);
                if (grid.getAnnotation() == null) continue;
                g2d.drawString(grid.getAnnotation(), (float)((int)gd + 2), (float)this.getLayoutManager().getProjection().getDevice2D().getDeviceHeight() * grid.getAnnotationFraction());
            }
        }
        if (manager.getGridOrientation() == Grid.GridOrientation.Horizontal) {
            for (i = 0; i < grids.size(); ++i) {
                grid = grids.get(i);
                gd = grid.getGridDeviceValue();
                g2d.setStroke(grid.getStroke());
                if (grid.getGridColor() != null) {
                    g2d.setPaint(grid.getGridColor());
                } else {
                    g2d.setColor(this.getLayoutManager().getProjection().getThemeColor());
                }
                grid2DShape = new Line2D.Double(this.getLayoutManager().getProjection().getDevice2D().getOriginX(), gd, this.getLayoutManager().getProjection().getDevice2D().getDeviceWidth() + this.getLayoutManager().getProjection().getDevice2D().getOriginX(), gd);
                g2d.draw(grid2DShape);
                if (grid.getAnnotation() == null) continue;
                g2d.drawString(grid.getAnnotation(), (float)this.getLayoutManager().getProjection().getDevice2D().getDeviceWidth() * grid.getAnnotationFraction(), (float)((int)gd - 2));
            }
        }
    }
}

