/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.data;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.legend.data.painter.AbstractDataItemSymbolPainter;
import org.jensoft.core.plugin.legend.data.painter.AbstractDataLegendBackgroundPainter;
import org.jensoft.core.plugin.legend.data.painter.DefaultDataLegendBackgroundPainter;
import org.jensoft.core.plugin.legend.data.painter.LineSymbolPainter;
import org.jensoft.core.view.ViewPart;

public class DataLegend {
    private List<Item> items;
    private AbstractDataLegendBackgroundPainter backgroundPainter = new DefaultDataLegendBackgroundPainter();
    private Font font;
    private Orientation orientation = Orientation.Column;
    private int markerTextInterval = 5;
    private ViewPart part = ViewPart.Device;
    private int marginX = 30;
    private int marginY = 30;
    private int paddingTop;
    private int paddingBottom;
    private int paddingLeft;
    private int paddingRight;
    private int symbolBoundWidth = 20;
    private int deltaWrapLine = 5;

    public DataLegend() {
        this.items = new ArrayList<Item>();
    }

    public DataLegend(ViewPart part) {
        this();
        this.part = part;
    }

    public DataLegend(Orientation orientation, ViewPart part) {
        this(part);
        this.orientation = orientation;
    }

    public AbstractDataLegendBackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void setBackgroundPainter(AbstractDataLegendBackgroundPainter backgroundPainter) {
        this.backgroundPainter = backgroundPainter;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPadding(int padding) {
        this.paddingTop = padding;
        this.paddingBottom = padding;
        this.paddingLeft = padding;
        this.paddingRight = padding;
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public int getSymbolBoundWidth() {
        return this.symbolBoundWidth;
    }

    public void setSymbolBoundWidth(int symbolBoundWidth) {
        this.symbolBoundWidth = symbolBoundWidth;
    }

    public int getDeltaWrapLine() {
        return this.deltaWrapLine;
    }

    public void setDeltaWrapLine(int deltaWrapLine) {
        this.deltaWrapLine = deltaWrapLine;
    }

    public int getMarkerTextInterval() {
        return this.markerTextInterval;
    }

    public void setMarkerTextInterval(int markerTextInterval) {
        this.markerTextInterval = markerTextInterval;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public ViewPart getPart() {
        return this.part;
    }

    public void setPart(ViewPart part) {
        this.part = part;
    }

    public int getMarginX() {
        return this.marginX;
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
    }

    public static class Item {
        private Color color;
        private Color textColor;
        private String text;
        private AbstractDataItemSymbolPainter symbolPainter = new LineSymbolPainter();

        public Item(Color color, String text) {
            this.color = color;
            this.text = text;
        }

        public Item(Color color, String text, Color textColor) {
            this(color, text);
            this.textColor = textColor;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color textColor) {
            this.textColor = textColor;
        }

        public AbstractDataItemSymbolPainter getSymbolPainter() {
            return this.symbolPainter;
        }

        public void setSymbolPainter(AbstractDataItemSymbolPainter symbolPainter) {
            this.symbolPainter = symbolPainter;
        }
    }

    public static enum Orientation {
        Row,
        Column;

    }
}

