/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.title.painter.fil;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.plugin.legend.title.TitleLegend;
import org.jensoft.core.plugin.legend.title.painter.AbstractTitleLegendFill;

public class TitleLegendGradientFill
extends AbstractTitleLegendFill {
    private Color startColor;
    private Color endColor;

    public TitleLegendGradientFill() {
    }

    public TitleLegendGradientFill(Color startColor, Color endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
    }

    @Override
    protected void paintLegendFill(Graphics2D g2d, TitleLegend legend) {
        if (legend.getFont() != null) {
            g2d.setFont(legend.getFont());
        }
        g2d.setColor(legend.getThemeColor());
        List<GlyphGeometry> legendGlyphs = legend.getLegendGlyphs();
        for (GlyphGeometry legendGlyph : legendGlyphs) {
            LinearGradientPaint pg;
            Color[] colors;
            float[] dist;
            Point2D.Double end;
            Point2D.Double start = new Point2D.Double(legendGlyph.getNorthTransform().getX(), legendGlyph.getNorthTransform().getY());
            if (start.equals(end = new Point2D.Double(legendGlyph.getSouthTransform().getX(), legendGlyph.getSouthTransform().getY()))) continue;
            if (this.startColor != null && this.endColor != null) {
                dist = new float[]{0.0f, 1.0f};
                colors = new Color[]{this.startColor, this.endColor};
                pg = new LinearGradientPaint(start, end, dist, colors);
                g2d.setPaint(pg);
                g2d.fill(legendGlyph.getGlyphShape());
                continue;
            }
            if (legend.getThemeColor() != null) {
                dist = new float[]{0.0f, 1.0f};
                colors = new Color[]{legend.getThemeColor().brighter(), legend.getThemeColor().darker()};
                pg = new LinearGradientPaint(start, end, dist, colors);
                g2d.setPaint(pg);
                g2d.fill(legendGlyph.getGlyphShape());
                continue;
            }
            dist = new float[]{0.0f, 1.0f};
            colors = new Color[]{legend.getHost().getProjection().getThemeColor().brighter(), legend.getHost().getProjection().getThemeColor().darker()};
            pg = new LinearGradientPaint(start, end, dist, colors);
            g2d.setPaint(pg);
            g2d.fill(legendGlyph.getGlyphShape());
        }
    }
}

