/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol;

import java.awt.Polygon;
import java.awt.geom.GeneralPath;

public class LineSymbolWidgetGeometry {
    private int centerX;
    private int centerY;
    private int radius;
    private double fragmentRadius;
    private GeneralPath controlShape;
    private Polygon northSensibleShape;
    private Polygon eastSensibleShape;
    private Polygon southSensibleShape;
    private Polygon westSensibleShape;
    private boolean lockNorth = false;
    private boolean lockEast = false;
    private boolean lockSouth = false;
    private boolean lockWest = false;

    public LineSymbolWidgetGeometry(int centerX, int centerY, int radius) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
        this.fragmentRadius = new Double(radius) / 2.8;
    }

    public void unlockAllSensibleShape() {
        this.lockNorth = false;
        this.lockEast = false;
        this.lockSouth = false;
        this.lockWest = false;
    }

    public void buildNorthSouth() {
        this.controlShape = new GeneralPath();
        this.controlShape.moveTo((double)this.centerX - this.fragmentRadius, (double)this.centerY - this.fragmentRadius);
        this.controlShape.lineTo((double)this.centerX - this.fragmentRadius, (double)this.centerY - 2.0 * this.fragmentRadius);
        this.controlShape.curveTo((double)this.centerX - this.fragmentRadius, (double)(this.centerY - this.radius), (double)this.centerX + this.fragmentRadius, (double)(this.centerY - this.radius), (double)this.centerX + this.fragmentRadius, (double)this.centerY - 2.0 * this.fragmentRadius);
        this.controlShape.lineTo((double)this.centerX + this.fragmentRadius, (double)this.centerY - this.fragmentRadius);
        this.controlShape.lineTo((double)this.centerX + this.fragmentRadius, (double)this.centerY + 2.0 * this.fragmentRadius);
        this.controlShape.curveTo((double)this.centerX + this.fragmentRadius, (double)(this.centerY + this.radius), (double)this.centerX - this.fragmentRadius, (double)(this.centerY + this.radius), (double)this.centerX - this.fragmentRadius, (double)this.centerY + 2.0 * this.fragmentRadius);
        this.controlShape.lineTo((double)this.centerX - this.fragmentRadius, (double)this.centerY + this.fragmentRadius);
        this.controlShape.closePath();
        int deltaSensible = (int)(this.fragmentRadius / 1.8);
        this.northSensibleShape = new Polygon();
        this.northSensibleShape.addPoint(this.centerX - deltaSensible, this.centerY - this.radius / 2);
        this.northSensibleShape.addPoint(this.centerX + deltaSensible, this.centerY - this.radius / 2);
        this.northSensibleShape.addPoint(this.centerX, this.centerY - 5 * this.radius / 6);
        this.southSensibleShape = new Polygon();
        this.southSensibleShape.addPoint(this.centerX - deltaSensible, this.centerY + this.radius / 2);
        this.southSensibleShape.addPoint(this.centerX + deltaSensible, this.centerY + this.radius / 2);
        this.southSensibleShape.addPoint(this.centerX, this.centerY + 5 * this.radius / 6);
    }

    public void buildEastWest() {
        this.controlShape = new GeneralPath();
        this.controlShape.lineTo((double)this.centerX + 2.0 * this.fragmentRadius, (double)this.centerY - this.fragmentRadius);
        this.controlShape.curveTo((double)(this.centerX + this.radius), (double)this.centerY - this.fragmentRadius, (double)(this.centerX + this.radius), (double)this.centerY + this.fragmentRadius, (double)this.centerX + 2.0 * this.fragmentRadius, (double)this.centerY + this.fragmentRadius);
        this.controlShape.lineTo((double)this.centerX + this.fragmentRadius, (double)this.centerY + this.fragmentRadius);
        this.controlShape.lineTo((double)this.centerX - 2.0 * this.fragmentRadius, (double)this.centerY + this.fragmentRadius);
        this.controlShape.curveTo((double)(this.centerX - this.radius), (double)this.centerY + this.fragmentRadius, (double)(this.centerX - this.radius), (double)this.centerY - this.fragmentRadius, (double)this.centerX - 2.0 * this.fragmentRadius, (double)this.centerY - this.fragmentRadius);
        this.controlShape.closePath();
        int deltaSensible = (int)(this.fragmentRadius / 1.8);
        this.eastSensibleShape = new Polygon();
        this.eastSensibleShape.addPoint(this.centerX + this.radius / 2, this.centerY - deltaSensible);
        this.eastSensibleShape.addPoint(this.centerX + this.radius / 2, this.centerY + deltaSensible);
        this.eastSensibleShape.addPoint(this.centerX + 5 * this.radius / 6, this.centerY);
        this.westSensibleShape = new Polygon();
        this.westSensibleShape.addPoint(this.centerX - this.radius / 2, this.centerY - deltaSensible);
        this.westSensibleShape.addPoint(this.centerX - this.radius / 2, this.centerY + deltaSensible);
        this.westSensibleShape.addPoint(this.centerX - 5 * this.radius / 6, this.centerY);
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public GeneralPath getControlShape() {
        return this.controlShape;
    }

    public void setControlShape(GeneralPath controlShape) {
        this.controlShape = controlShape;
    }

    public Polygon getNorthSensibleShape() {
        return this.northSensibleShape;
    }

    public void setNorthSensibleShape(Polygon northSensibleShape) {
        this.northSensibleShape = northSensibleShape;
    }

    public Polygon getEastSensibleShape() {
        return this.eastSensibleShape;
    }

    public void setEastSensibleShape(Polygon eastSensibleShape) {
        this.eastSensibleShape = eastSensibleShape;
    }

    public Polygon getSouthSensibleShape() {
        return this.southSensibleShape;
    }

    public void setSouthSensibleShape(Polygon southSensibleShape) {
        this.southSensibleShape = southSensibleShape;
    }

    public Polygon getWestSensibleShape() {
        return this.westSensibleShape;
    }

    public void setWestSensibleShape(Polygon westSensibleShape) {
        this.westSensibleShape = westSensibleShape;
    }

    public boolean isLockNorthSensible() {
        return this.lockNorth;
    }

    public void setLockNorthSensible(boolean lockNorth) {
        this.lockNorth = lockNorth;
    }

    public boolean isLockEastSensible() {
        return this.lockEast;
    }

    public void setLockEastSensible(boolean lockEast) {
        this.lockEast = lockEast;
    }

    public boolean isLockSouthSensible() {
        return this.lockSouth;
    }

    public void setLockSouthSensible(boolean lockSouth) {
        this.lockSouth = lockSouth;
    }

    public boolean isLockWestSensible() {
        return this.lockWest;
    }

    public void setLockWestSensible(boolean lockWest) {
        this.lockWest = lockWest;
    }
}

