/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol.core;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.linesymbol.LineSymbolPlugin;
import org.jensoft.core.plugin.linesymbol.core.LineSymbolComponent;
import org.jensoft.core.projection.Projection;

public class LineSymbolGeometry {
    private LineSymbolComponent lineSymbolComponent;

    public LineSymbolGeometry(LineSymbolComponent lineSymbolComponent) {
        this.lineSymbolComponent = lineSymbolComponent;
    }

    public LineSymbolComponent getLineSymbolComponent() {
        return this.lineSymbolComponent;
    }

    public void setLineSymbolComponent(LineSymbolComponent lineSymbolComponent) {
        this.lineSymbolComponent = lineSymbolComponent;
    }

    public Rectangle2D getBounds() {
        Projection w2d = this.lineSymbolComponent.getHost().getProjection();
        if (this.lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineX) {
            double y = this.lineSymbolComponent.getLocation();
            double thickness = this.lineSymbolComponent.getThickness();
            Rectangle2D.Double bound = new Rectangle2D.Double(0.0, (double)w2d.getDevice2D().getDeviceHeight() - y - thickness, w2d.getDevice2D().getDeviceWidth() - 1, thickness);
            return bound;
        }
        if (this.lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineY) {
            double x = this.lineSymbolComponent.getLocation();
            double thickness = this.lineSymbolComponent.getThickness();
            Rectangle2D.Double bound = new Rectangle2D.Double(x, 0.0, x + thickness, w2d.getDevice2D().getDeviceHeight() - 1);
            return bound;
        }
        return null;
    }

    public Line2D getBaseLine() {
        Projection w2d = this.lineSymbolComponent.getHost().getProjection();
        if (this.lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineX) {
            double y = this.lineSymbolComponent.getLocation();
            double thickness = this.lineSymbolComponent.getThickness();
            Line2D.Double baseLine = new Line2D.Double(0.0, (double)w2d.getDevice2D().getDeviceHeight() - y - thickness / 2.0, w2d.getDevice2D().getDeviceWidth() - 1, (double)w2d.getDevice2D().getDeviceHeight() - y - thickness / 2.0);
            return baseLine;
        }
        if (this.lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineY) {
            double x = this.lineSymbolComponent.getLocation();
            double thickness = this.lineSymbolComponent.getThickness();
            Line2D.Double baseLine = new Line2D.Double(x + thickness / 2.0, 0.0, x + thickness / 2.0, w2d.getDevice2D().getDeviceHeight() - 1);
            return baseLine;
        }
        return null;
    }
}

