/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol.iconline;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.linesymbol.LineSymbolPlugin;
import org.jensoft.core.plugin.linesymbol.core.LineSymbolComponent;
import org.jensoft.core.plugin.linesymbol.iconline.IconLineSymbol;
import org.jensoft.core.plugin.linesymbol.iconline.LineEntry;
import org.jensoft.core.plugin.linesymbol.painter.AbstractLinePainter;
import org.jensoft.core.projection.Projection;

public class IconLinePainter
extends AbstractLinePainter {
    @Override
    public void paintLineSymbol(Graphics2D g2d, LineSymbolComponent lineSymbolComponent) {
        if (lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineX) {
            this.paintXLineSymbol(g2d, lineSymbolComponent);
        } else if (lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineY) {
            this.paintYLineSymbol(g2d, lineSymbolComponent);
        }
    }

    private void paintXLineSymbol(Graphics2D g2d, LineSymbolComponent lineSymbolComponent) {
        IconLineSymbol ils = (IconLineSymbol)lineSymbolComponent;
        for (LineEntry entry : ils.getEntries()) {
            double value = entry.getValue();
            Projection w2d = lineSymbolComponent.getHost().getProjection();
            Point2D devicePoint = w2d.userToPixel(new Point2D.Double(value, 0.0));
            double y = ils.getGeometry().getBaseLine().getY1();
            ImageIcon image = null;
            image = entry.getIconSymbol() != null ? entry.getIconSymbol() : ils.getIconSymbol();
            g2d.drawImage(image.getImage(), (int)(devicePoint.getX() - (double)(image.getIconWidth() / 2)), (int)(y - (double)(image.getIconHeight() / 2)), image.getIconWidth(), image.getIconHeight(), null);
        }
        Line2D baseLine = lineSymbolComponent.getGeometry().getBaseLine();
        double ystart = baseLine.getY1();
        g2d.setColor(TangoPalette.SKYBLUE2);
        if (ils.getSymbol() != null) {
            g2d.drawString(ils.getSymbol(), 20, (int)(ystart - 4.0));
        }
    }

    private void paintYLineSymbol(Graphics2D g2d, LineSymbolComponent lineSymbolComponent) {
        IconLineSymbol ils = (IconLineSymbol)lineSymbolComponent;
        for (LineEntry entry : ils.getEntries()) {
            double value = entry.getValue();
            Projection w2d = lineSymbolComponent.getHost().getProjection();
            Point2D devicePoint = w2d.userToPixel(new Point2D.Double(0.0, value));
            double x = lineSymbolComponent.getLocation();
            ImageIcon image = null;
            image = entry.getIconSymbol() != null ? entry.getIconSymbol() : ils.getIconSymbol();
            g2d.drawImage(image.getImage(), (int)(x - (double)(image.getIconWidth() / 2)), (int)(devicePoint.getY() - (double)(image.getIconHeight() / 2)), image.getIconWidth(), image.getIconHeight(), null);
        }
    }
}

