/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import org.jensoft.core.plugin.linesymbol.core.LineSymbolComponent;
import org.jensoft.core.plugin.linesymbol.painter.AbstractLinePainter;

public class LinePainter
extends AbstractLinePainter {
    private Color themeColor = Color.WHITE;
    private Stroke lineStroke = new BasicStroke(1.0f);

    public LinePainter(Color themeColor) {
        this.themeColor = themeColor;
    }

    public LinePainter(Color themeColor, Stroke lineStroke) {
        this.themeColor = themeColor;
        this.lineStroke = lineStroke;
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke lineStroke) {
        this.lineStroke = lineStroke;
    }

    @Override
    public void paintLineSymbol(Graphics2D g2d, LineSymbolComponent lineSymbolComponent) {
        Line2D baseLine = lineSymbolComponent.getGeometry().getBaseLine();
        g2d.setColor(this.themeColor);
        g2d.setStroke(this.lineStroke);
        g2d.draw(baseLine);
        g2d.setStroke(new BasicStroke());
    }
}

