/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.catalog.ui.ViewFrameUI;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.map.layer.highway.GroupRenderingProperties;
import org.jensoft.core.map.layer.highway.Highway;
import org.jensoft.core.map.layer.highway.HighwayGroup;
import org.jensoft.core.map.layer.highway.HighwayLayer;
import org.jensoft.core.map.layer.highway.HighwayNature;
import org.jensoft.core.map.primitive.Node;
import org.jensoft.core.map.primitive.Primitive;
import org.jensoft.core.map.primitive.Way;
import org.jensoft.core.map.projection.GeoPosition;
import org.jensoft.core.plugin.map.MapLayerPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.Portfolio;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewDefaultBackground;

public class TraceDemo
extends View {
    GeoPosition g16 = new GeoPosition(25.8546608, -80.1372134);
    GeoPosition g17 = new GeoPosition(25.8544677, -80.1380718);
    GeoPosition g18 = new GeoPosition(25.8541819, -80.1390331);
    GeoPosition g19 = new GeoPosition(25.8540583, -80.1397626);
    GeoPosition g20 = new GeoPosition(25.8540583, -80.1408527);
    GeoPosition g21 = new GeoPosition(25.8540429, -80.1418483);
    GeoPosition g22 = new GeoPosition(25.8538884, -80.1426551);
    GeoPosition g23 = new GeoPosition(25.8536567, -80.1435821);
    GeoPosition g24 = new GeoPosition(25.8534404, -80.1445262);
    GeoPosition g25 = new GeoPosition(25.8531911, -80.1453899);
    GeoPosition g26 = new GeoPosition(25.8522642, -80.1450037);
    GeoPosition g27 = new GeoPosition(25.8516463, -80.1446604);
    GeoPosition g28 = new GeoPosition(25.8509511, -80.1440166);
    GeoPosition g29 = new GeoPosition(25.8504104, -80.1434158);
    GeoPosition g30 = new GeoPosition(25.8498311, -80.1426433);
    GeoPosition g31 = new GeoPosition(25.8494835, -80.141785);
    GeoPosition g32 = new GeoPosition(25.8491359, -80.1407551);
    GeoPosition g33 = new GeoPosition(25.8489042, -80.1395963);
    GeoPosition g34 = new GeoPosition(25.8488655, -80.1384376);
    GeoPosition g35 = new GeoPosition(25.84902, -80.1373647);
    GeoPosition g36 = new GeoPosition(25.8492131, -80.1363348);
    GeoPosition g37 = new GeoPosition(25.8495993, -80.1353906);
    GeoPosition g38 = new GeoPosition(25.8502559, -80.1342319);
    GeoPosition g39 = new GeoPosition(25.8509511, -80.133159);
    GeoPosition g40 = new GeoPosition(25.8514531, -80.1323866);
    GeoPosition g41 = new GeoPosition(25.8520325, -80.1313995);
    GeoPosition g42 = new GeoPosition(25.8522642, -80.1304125);
    GeoPosition g43 = new GeoPosition(25.8523414, -80.1290392);
    GeoPosition g44 = new GeoPosition(25.8524573, -80.1280521);
    GeoPosition g45 = new GeoPosition(25.8524959, -80.1270651);
    GeoPosition g46 = new GeoPosition(25.8525345, -80.1262926);
    GeoPosition g47 = new GeoPosition(25.852689, -80.1258634);
    GeoPosition g48 = new GeoPosition(25.8529593, -80.1256489);
    GeoPosition g49 = new GeoPosition(25.8534614, -80.1255201);
    private List<GeoPosition> testPositions = new ArrayList<GeoPosition>();

    public TraceDemo() {
        this.createPositions();
        final Projection.Map proj = new Projection.Map();
        proj.setThemeColor(Color.WHITE);
        this.registerProjection(proj);
        MapLayerPlugin mapLayerPlugin = new MapLayerPlugin();
        proj.registerPlugin(mapLayerPlugin);
        HighwayLayer highwayLayer = new HighwayLayer();
        mapLayerPlugin.registerLayer(highwayLayer);
        HighwayGroup residentialGroup = highwayLayer.getGroup(HighwayNature.RESIDENTIAL);
        GroupRenderingProperties residentialProperties = new GroupRenderingProperties(14, Color.WHITE);
        residentialGroup.setRenderingProperties(residentialProperties);
        HighwayGroup unclassifiedGroup = highwayLayer.getGroup(HighwayNature.UNCLASSIFIED);
        GroupRenderingProperties unclassifiedProperties = new GroupRenderingProperties(14, Color.WHITE);
        unclassifiedGroup.setRenderingProperties(unclassifiedProperties);
        HighwayGroup roadGroup = highwayLayer.getGroup(HighwayNature.ROAD);
        GroupRenderingProperties roadProperties = new GroupRenderingProperties(14, Color.WHITE);
        roadGroup.setRenderingProperties(roadProperties);
        HighwayGroup primaryGroup = highwayLayer.getGroup(HighwayNature.PRIMARY);
        GroupRenderingProperties primaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        primaryGroup.setRenderingProperties(primaryProperties);
        HighwayGroup secondaryGroup = highwayLayer.getGroup(HighwayNature.SECONDARY);
        GroupRenderingProperties secondaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        secondaryGroup.setRenderingProperties(secondaryProperties);
        HighwayGroup tertiaryGroup = highwayLayer.getGroup(HighwayNature.TERTIARY);
        GroupRenderingProperties tertiaryProperties = new GroupRenderingProperties(14, Color.WHITE);
        tertiaryGroup.setRenderingProperties(tertiaryProperties);
        HighwayGroup serviceGroup = highwayLayer.getGroup(HighwayNature.SERVICE);
        GroupRenderingProperties serviceProperties = new GroupRenderingProperties(6, Color.WHITE);
        serviceGroup.setRenderingProperties(serviceProperties);
        HighwayGroup motorwayGroup = highwayLayer.getGroup(HighwayNature.MOTORWAY);
        GroupRenderingProperties motorwayProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayGroup.setRenderingProperties(motorwayProperties);
        HighwayGroup motorwayLinkGroup = highwayLayer.getGroup(HighwayNature.MOTORWAY_LINK);
        GroupRenderingProperties motorwayLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        motorwayLinkGroup.setRenderingProperties(motorwayLinkProperties);
        HighwayGroup trunkGroup = highwayLayer.getGroup(HighwayNature.TRUNK);
        GroupRenderingProperties trunkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkGroup.setRenderingProperties(trunkProperties);
        HighwayGroup trunkLinkGroup = highwayLayer.getGroup(HighwayNature.TRUNK_LINK);
        GroupRenderingProperties trunkLinkProperties = new GroupRenderingProperties(14, Color.WHITE);
        trunkLinkGroup.setRenderingProperties(trunkLinkProperties);
        HighwayGroup pedestrianGroup = highwayLayer.getGroup(HighwayNature.PEDESTRIAN);
        GroupRenderingProperties pedestrianProperties = new GroupRenderingProperties(6, Color.WHITE);
        pedestrianGroup.setRenderingProperties(pedestrianProperties);
        Highway highway = new Highway(1, HighwayNature.RESIDENTIAL);
        highway.setName("jensoft API highway");
        Way w = new Way();
        w.setId(1);
        ArrayList<Node> nodes = new ArrayList<Node>();
        w.setNodes(nodes);
        int count = 0;
        for (GeoPosition position : this.testPositions) {
            Node n = new Node(count++);
            n.setGeoPosition(position);
            nodes.add(n);
        }
        Primitive p = new Primitive(w);
        highway.setPrimitive(p);
        highwayLayer.registerHighway(highway);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    System.out.println("min x " + proj.getMinX());
                    System.out.println("max x " + proj.getMaxX());
                    System.out.println("min y " + proj.getMinY());
                    System.out.println("max y " + proj.getMaxY());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    private void createPositions() {
        this.testPositions.add(this.g16);
        this.testPositions.add(this.g17);
        this.testPositions.add(this.g18);
        this.testPositions.add(this.g19);
        this.testPositions.add(this.g20);
        this.testPositions.add(this.g21);
        this.testPositions.add(this.g22);
        this.testPositions.add(this.g23);
        this.testPositions.add(this.g24);
        this.testPositions.add(this.g25);
        this.testPositions.add(this.g26);
        this.testPositions.add(this.g27);
        this.testPositions.add(this.g28);
        this.testPositions.add(this.g29);
        this.testPositions.add(this.g30);
        this.testPositions.add(this.g31);
        this.testPositions.add(this.g32);
        this.testPositions.add(this.g33);
        this.testPositions.add(this.g34);
        this.testPositions.add(this.g35);
        this.testPositions.add(this.g36);
        this.testPositions.add(this.g37);
        this.testPositions.add(this.g38);
        this.testPositions.add(this.g39);
        this.testPositions.add(this.g40);
        this.testPositions.add(this.g41);
        this.testPositions.add(this.g42);
        this.testPositions.add(this.g43);
        this.testPositions.add(this.g44);
        this.testPositions.add(this.g45);
        this.testPositions.add(this.g46);
        this.testPositions.add(this.g47);
        this.testPositions.add(this.g48);
        this.testPositions.add(this.g49);
    }

    @Portfolio(name="FreeGridDemo", width=500, height=250)
    public static View getPortofolio() {
        TraceDemo demo = new TraceDemo();
        ViewDefaultBackground viewBackground = new ViewDefaultBackground();
        Shader s = new Shader(new float[]{0.0f, 1.0f}, new Color[]{new Color(32, 39, 55), Color.BLACK});
        viewBackground.setShader(s);
        viewBackground.setOutlineStroke(new BasicStroke(2.5f));
        demo.setBackgroundPainter(viewBackground);
        return demo;
    }

    public static void main(String[] args) throws Exception {
        TraceDemo demo = new TraceDemo();
        ViewFrameUI demoFrame = new ViewFrameUI(demo);
    }
}

