/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.marker.context;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.PluginListener;
import org.jensoft.core.plugin.marker.MarkerPlugin;
import org.jensoft.core.plugin.marker.context.AbstractMarkerCreator;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;
import org.jensoft.core.sharedicon.marker.Marker;

public abstract class AbstractMarkerDefaultDeviceContext
extends ContextEntry {
    private JMenu markerMenu;
    private JMenuItem activeItem;
    private JMenu addMarkerMenu;
    private JMenuItem deleteAllMarker;
    private List<AbstractMarkerCreator> markerCreators;
    private ImageIcon markerIcon = SharedIcon.getMarker(Marker.MARKER_ROUNDED_LIGHTBLUE);
    private ImageIcon markerAdd = SharedIcon.getMarker(Marker.MARKER_ROUNDED_BLUE_ADD);
    private ImageIcon markerRemove = SharedIcon.getMarker(Marker.MARKER_ROUNDED_BLUE_REMOVE);
    private ImageIcon itemIcon = SharedIcon.getCommon(Common.ITEM);
    private ImageIcon lockIcon = SharedIcon.getCommon(Common.LOCK);
    private ImageIcon unlockIcon = SharedIcon.getCommon(Common.UNLOCK);

    public AbstractMarkerDefaultDeviceContext() {
        this.markerCreators = new ArrayList<AbstractMarkerCreator>();
    }

    public void registerMarkerCreator(AbstractMarkerCreator creator) {
        this.markerCreators.add(creator);
    }

    @Override
    public void buildContext() {
        for (AbstractMarkerCreator creator : this.markerCreators) {
            creator.setHost((MarkerPlugin)this.getHost());
            creator.registerListener();
        }
        this.markerMenu = new JMenu("Marker");
        this.markerMenu.setIcon(this.markerIcon);
        MarkerPlugin markerPlugin = (MarkerPlugin)this.getHost();
        this.activeItem = new JMenuItem();
        this.activeItem.addActionListener(markerPlugin.getMarkerLockUnlockAction());
        markerPlugin.addPluginListener(new PluginListener(){

            public void pluginUnlockSelected(PluginEvent pluginEvent) {
                AbstractMarkerDefaultDeviceContext.this.activeItem.setText("lock");
                AbstractMarkerDefaultDeviceContext.this.activeItem.setIcon(AbstractMarkerDefaultDeviceContext.this.unlockIcon);
                AbstractMarkerDefaultDeviceContext.this.addMarkerMenu.setEnabled(false);
                AbstractMarkerDefaultDeviceContext.this.deleteAllMarker.setEnabled(false);
            }

            public void pluginSelected(PluginEvent pluginEvent) {
                AbstractMarkerDefaultDeviceContext.this.activeItem.setText("unlock");
                AbstractMarkerDefaultDeviceContext.this.activeItem.setIcon(AbstractMarkerDefaultDeviceContext.this.lockIcon);
                AbstractMarkerDefaultDeviceContext.this.addMarkerMenu.setEnabled(true);
                AbstractMarkerDefaultDeviceContext.this.deleteAllMarker.setEnabled(true);
            }
        });
        this.markerMenu.add(this.activeItem);
        this.addMarkerMenu = new JMenu("Add");
        this.addMarkerMenu.setIcon(this.markerAdd);
        for (AbstractMarkerCreator creator : this.markerCreators) {
            this.addMarkerMenu.add(creator);
        }
        this.markerMenu.add(this.addMarkerMenu);
        this.deleteAllMarker = new JMenuItem("Remove All");
        this.deleteAllMarker.setIcon(this.markerRemove);
        this.deleteAllMarker.addActionListener(markerPlugin.getMarkerDeleteAllAction());
        this.markerMenu.add(this.deleteAllMarker);
        if (!((AbstractPlugin)this.getHost()).isLockSelected()) {
            this.activeItem.setSelected(false);
            this.activeItem.setText("lock");
            this.activeItem.setIcon(this.unlockIcon);
            this.addMarkerMenu.setEnabled(false);
            this.deleteAllMarker.setEnabled(false);
        } else {
            this.activeItem.setSelected(true);
            this.activeItem.setText("unlock");
            this.activeItem.setIcon(this.lockIcon);
            this.addMarkerMenu.setEnabled(true);
            this.deleteAllMarker.setEnabled(true);
        }
        this.setGroup("marker");
        this.setItem(this.markerMenu);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof MarkerPlugin;
    }
}

