/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.marker.marker;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;

public abstract class AbstractMarker {
    private String name;
    private AbstractPlugin host;
    private double markerX;
    private double markerY;
    private boolean lockIntercept;
    private boolean lockMove;
    private MarkerNature markerNature = MarkerNature.MarkerUser;
    private Point2D markerPoint;

    public Point2D getMarkerPoint() {
        if (this.markerNature == MarkerNature.MarkerDevice) {
            this.markerPoint = new Point2D.Double(this.getMarkerX(), this.getMarkerY());
        }
        if (this.markerNature == MarkerNature.MarkerUser) {
            this.markerPoint = this.getHost().getProjection().userToPixel(new Point2D.Double(this.getMarkerX(), this.getMarkerY()));
        }
        return this.markerPoint;
    }

    public MarkerNature getMarkerNature() {
        return this.markerNature;
    }

    public void setMarkerNature(MarkerNature markerNature) {
        this.markerNature = markerNature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractPlugin getHost() {
        return this.host;
    }

    public void setHost(AbstractPlugin host) {
        this.host = host;
    }

    public void lockIntercept() {
        this.lockIntercept = true;
    }

    public void unlockIntercept() {
        this.lockIntercept = false;
    }

    public boolean isLockIntercept() {
        return this.lockIntercept;
    }

    public void lockMove() {
        this.lockMove = true;
    }

    public void unlockMove() {
        this.lockMove = false;
    }

    public boolean isLockMove() {
        return this.lockMove;
    }

    public double getMarkerX() {
        return this.markerX;
    }

    public void setMarkerX(double markerX) {
        this.markerX = markerX;
    }

    public double getMarkerY() {
        return this.markerY;
    }

    public void setMarkerY(double markerY) {
        this.markerY = markerY;
    }

    public abstract void paintMarker(View var1, Graphics2D var2);

    public static enum MarkerNature {
        MarkerUser,
        MarkerDevice;

    }
}

