/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.marker.marker;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.marker.marker.AbstractMarker;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;

public class CrossMarker
extends AbstractMarker {
    private Color crossMarkerColor;
    private Shape shapeMarkerV;
    private Shape shapeMarkerH;

    public Shape getShapeMarkerV() {
        return this.shapeMarkerV;
    }

    public void setShapeMarkerV(Shape shapeMarkerV) {
        this.shapeMarkerV = shapeMarkerV;
    }

    public Shape getShapeMarkerH() {
        return this.shapeMarkerH;
    }

    public void setShapeMarkerH(Shape shapeMarkerH) {
        this.shapeMarkerH = shapeMarkerH;
    }

    public Color getCrossMarkerColor() {
        return this.crossMarkerColor;
    }

    public void setCrossMarkerColor(Color crossMarkerColor) {
        this.crossMarkerColor = crossMarkerColor;
    }

    protected void paintCross(Graphics2D g2d) {
        if (this.getHost() == null || !this.getHost().isLockSelected()) {
            return;
        }
        Projection proj = this.getHost().getProjection();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Point2D.Double targetP2dDevice = new Point2D.Double(this.getMarkerX(), this.getMarkerY());
        Point2D targetP2dUser = proj.pixelToUser(targetP2dDevice);
        g2d.setStroke(new BasicStroke());
        g2d.setColor(Color.RED);
        g2d.drawLine((int)this.getMarkerX(), 0, (int)this.getMarkerX(), proj.getDevice2D().getDeviceHeight());
        g2d.drawLine(0, (int)this.getMarkerY(), proj.getDevice2D().getDeviceWidth(), (int)this.getMarkerY());
        g2d.drawString("X = " + (int)targetP2dUser.getX() + " , Y = " + (int)targetP2dUser.getY(), (int)this.getMarkerX() + 10, (int)this.getMarkerY() - 10);
    }

    @Override
    public final void paintMarker(View view, Graphics2D g2d) {
        this.paintCross(g2d);
    }
}

