/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.message;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.plugin.message.MessagePlugin;
import org.jensoft.core.widget.bar.AbstractBackwardForwardBarWidget;
import org.jensoft.core.widget.bar.AbstractBarGeometry;

public class MessageSelecterWidget
extends AbstractBackwardForwardBarWidget {
    public static final String widgetBarXObjectifID = "@widget/message";
    private static final double defaultBarWidth = 180.0;
    private static final double defaultBarHeight = 16.0;
    private static final int defaultXFolderIndex = 2;
    private static final int defaultYFolderIndex = 100;
    private float[] fractions = new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f};
    private Color[] colors = new Color[]{new Color(0, 0, 0, 20), new Color(0, 0, 0, 150), new Color(0, 0, 0, 200), new Color(0, 0, 0, 150), new Color(0, 0, 0, 20)};
    private Color outlineColor = Color.BLACK;
    private Stroke buttonStroke = new BasicStroke(2.0f, 1, 2);
    private Stroke basicStroke = new BasicStroke(0.8f);
    private Color buttonRolloverDrawColor = RosePalette.LEMONPEEL;
    private Color buttonDrawColor = Spectral.SPECTRAL_BLUE1;

    public MessageSelecterWidget(double width, double height) {
        super(widgetBarXObjectifID, width, height, 2, 100, AbstractBarGeometry.BarWidgetOrientation.Horizontal);
        this.setShader(this.fractions, this.colors);
        this.setOutlineStroke(this.basicStroke);
        this.setOutlineColor(this.outlineColor);
        this.setButtonFillColor(Color.BLACK);
        this.setButtonRolloverFillColor(Spectral.SPECTRAL_RED);
        this.setOrphanLock(true);
    }

    public MessageSelecterWidget(double width, double height, int xIndex, int yIndex) {
        super(widgetBarXObjectifID, width, height, xIndex, yIndex, AbstractBarGeometry.BarWidgetOrientation.Horizontal);
        this.setShader(this.fractions, this.colors);
        this.setOutlineStroke(this.basicStroke);
        this.setOutlineColor(this.outlineColor);
        this.setButtonDrawColor(this.buttonDrawColor);
        this.setButtonFillColor(Color.BLACK);
        this.setButtonRolloverFillColor(Spectral.SPECTRAL_RED);
        this.setOrphanLock(true);
    }

    public MessageSelecterWidget() {
        super(widgetBarXObjectifID, 180.0, 16.0, 2, 100, AbstractBarGeometry.BarWidgetOrientation.Horizontal);
        this.setShader(this.fractions, this.colors);
        this.setOutlineStroke(this.basicStroke);
        this.setOutlineColor(this.outlineColor);
        this.setButtonFillColor(Spectral.SPECTRAL_RED);
        this.setButtonRolloverFillColor(Spectral.SPECTRAL_RED.brighter().brighter());
        this.setOrphanLock(true);
    }

    @Override
    public final boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof MessagePlugin;
    }

    private MessagePlugin getMessagePlugin() {
        return (MessagePlugin)this.getHost();
    }

    @Override
    public void onPaintStart() {
        this.setButton1Visible(false);
        this.setButton2Visible(false);
        if (this.getMessagePlugin().getCurrentIndex() >= 0) {
            this.setButton1Visible(true);
        }
        if (this.getMessagePlugin().getCurrentIndex() <= this.getMessagePlugin().messageCount() - 1) {
            this.setButton2Visible(true);
        }
        super.onPaintStart();
    }

    @Override
    public void onButton1Press() {
        if (!this.isButton1Visible()) {
            return;
        }
        if (!this.getMessagePlugin().isLockSelected()) {
            return;
        }
        if (this.getMessagePlugin().isSliding()) {
            return;
        }
        if (this.getMessagePlugin().getCurrentIndex() == 0) {
            this.getMessagePlugin().showMessage(this.getMessagePlugin().messageCount(), MessagePlugin.Slide.PreviousMessage);
            this.getMessagePlugin().setCurrentIndex(-1);
        } else {
            this.getMessagePlugin().previousMessage();
        }
        super.onButton1Press();
    }

    @Override
    public void onButton2Press() {
        if (!this.isButton2Visible()) {
            return;
        }
        if (!this.getMessagePlugin().isLockSelected()) {
            return;
        }
        if (this.getMessagePlugin().isSliding()) {
            return;
        }
        if (this.getMessagePlugin().getCurrentIndex() == this.getMessagePlugin().messageCount() - 1) {
            this.getMessagePlugin().showMessage(-1, MessagePlugin.Slide.NextMessage);
            this.getMessagePlugin().setCurrentIndex(this.getMessagePlugin().messageCount());
        } else {
            this.getMessagePlugin().nextMessage();
        }
        super.onButton2Press();
    }

    @Override
    public void onButton1Released() {
        super.onButton1Released();
    }

    @Override
    public void onButton2Released() {
        super.onButton2Released();
    }
}

