/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.message.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.plaf.metal.MetalScrollButton;
import org.jensoft.core.palette.color.Spectral;

class MessageScrollButton
extends MetalScrollButton {
    private Color scrollerButtonColor = Spectral.SPECTRAL_BLUE2.brighter();

    public MessageScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
        this.setOpaque(false);
    }

    public MessageScrollButton(int direction, int width, boolean freeStanding, Color scrollerButtonColor) {
        super(direction, width, freeStanding);
        this.scrollerButtonColor = scrollerButtonColor;
        this.setOpaque(false);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(17, 17);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.scrollerButtonColor);
        switch (this.getDirection()) {
            case 7: {
                GeneralPath pw = new GeneralPath();
                pw.moveTo(2.0f, this.getHeight() / 2);
                pw.lineTo(this.getWidth() - 2, 2.0f);
                pw.lineTo(this.getWidth() - 2, this.getHeight() - 2);
                pw.closePath();
                g2d.fill(pw);
                break;
            }
            case 3: {
                GeneralPath pe = new GeneralPath();
                pe.moveTo(this.getWidth() - 2, this.getHeight() / 2);
                pe.lineTo(2.0f, 2.0f);
                pe.lineTo(2.0f, this.getHeight() - 2);
                pe.closePath();
                g2d.fill(pe);
                break;
            }
            case 1: {
                GeneralPath pn = new GeneralPath();
                pn.moveTo(this.getWidth() / 2, 2.0f);
                pn.lineTo(this.getWidth() - 2, this.getHeight() - 2);
                pn.lineTo(2.0f, this.getHeight() - 2);
                pn.closePath();
                g2d.fill(pn);
                break;
            }
            case 5: {
                GeneralPath ps = new GeneralPath();
                ps.moveTo(this.getWidth() / 2, this.getHeight() - 2);
                ps.lineTo(this.getWidth() - 2, 2.0f);
                ps.lineTo(2.0f, 2.0f);
                ps.closePath();
                g2d.fill(ps);
            }
        }
    }
}

